/*******************************************************************************
 *
 *    ADOBE CONFIDENTIAL
 *     ___________________
 *
 *     Copyright 2021 Adobe
 *     All Rights Reserved.
 *
 *     NOTICE: All information contained herein is, and remains
 *     the property of Adobe and its suppliers, if any. The intellectual
 *     and technical concepts contained herein are proprietary to Adobe
 *     and its suppliers and are protected by all applicable intellectual
 *     property laws, including trade secret and copyright laws.
 *     Dissemination of this information or reproduction of this material
 *     is strictly forbidden unless prior written permission is obtained
 *     from Adobe.
 *
 ******************************************************************************/
package com.adobe.cq.cif.common.associatedcontent;

import java.util.Iterator;

/**
 * An {@link AssociatedContentQuery} is returned by the {@link AssociatedContentService} and can be used to trill down the result set
 * further.
 *
 * @param <T> the type of the results returned by the Query
 */
public interface AssociatedContentQuery<T> {

    /**
     * Set a limit to the {@link AssociatedContentQuery}.
     * <p>
     * If not called, the limit is {@link Long#MAX_VALUE}.
     *
     * @param limit the limit
     * @return the {@link AssociatedContentQuery} itself
     */
    AssociatedContentQuery<T> withLimit(long limit);

    /**
     * Set an offset to the {@link AssociatedContentQuery}.
     * <p>
     * If not called, the offset is {@code 0}
     *
     * @param offset the offset
     * @return the {@link AssociatedContentQuery} itself
     */
    AssociatedContentQuery<T> withOffset(long offset);

    /**
     * Executes the {@link AssociatedContentQuery} returning an {@link Iterator} on the result set. This iterator may contain all query
     * hits or not, depending if a hit can be converted to the result type of the {@link AssociatedContentQuery}.
     *
     * @return an {@link Iterator} of a hits that can be converted to the result type, {@code null} values filtered out
     */
    Iterator<T> execute();

    /**
     * Sets a custom transformer for this query results. This would transform the results from type {@code T} to type {@code N}
     * <p>
     * If not called, the default transformer is used.
     *
     * @param transformer a {@link QueryResultTransformer} implementation
     * @param <N> the new result type
     * @return an {@link AssociatedContentQuery} object
     */
    <N> AssociatedContentQuery<N> withTransformer(QueryResultTransformer<N> transformer);

}
