/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.cif.common.associatedcontent;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
abstract class BaseParams<P extends BaseParams<P>> {
    Collection<String> identifiers;
    String path;

    BaseParams() {
    }

    public Collection<String> identifiers() {
        return this.identifiers;
    }

    public String path() {
        return this.path;
    }

    public P path(String path) {
        this.path = path;
        return (P)this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{identifiers=" + this.identifiers + ", path='" + this.path + '\'' + Arrays.stream(this.getClass().getDeclaredFields()).filter(f -> !f.isSynthetic()).map(f -> {
            try {
                f.setAccessible(true);
                return f.getName() + "=" + (String.class.equals(f.getType()) ? "'" + f.get(this) + "'" : f.get(this));
            }
            catch (Exception x) {
                return f.getName() + "=?";
            }
        }).reduce("", (s1, s2) -> s1 + ", " + s2) + '}';
    }

    static <T extends BaseParams<T>> T of(Supplier<T> function, String identifier) {
        if (StringUtils.isBlank((CharSequence)identifier)) {
            throw new IllegalArgumentException("Missing identifier");
        }
        BaseParams params = (BaseParams)function.get();
        params.identifiers = Collections.singletonList(identifier);
        return (T)params;
    }

    static <T extends BaseParams<T>> T of(Supplier<T> function, Collection<String> identifiers) {
        if (identifiers == null) {
            throw new IllegalArgumentException("Missing identifiers");
        }
        if ((identifiers = (Collection)identifiers.stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList())).isEmpty()) {
            throw new IllegalArgumentException("Missing identifiers");
        }
        BaseParams params = (BaseParams)function.get();
        params.identifiers = Collections.unmodifiableCollection(identifiers);
        return (T)params;
    }
}

