/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.graphql.client;

import com.adobe.cq.commerce.graphql.client.HttpMethod;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(name="CIF GraphQL Client Configuration Factory")
public @interface GraphqlClientConfiguration {
    public static final String CQ_GRAPHQL_CLIENT = "cq:graphqlClient";
    public static final String DEFAULT_IDENTIFIER = "default";
    public static final int MAX_HTTP_CONNECTIONS_DEFAULT = 20;
    public static final boolean ACCEPT_SELF_SIGNED_CERTIFICATES = false;
    public static final boolean ALLOW_HTTP_PROTOCOL = false;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 5000;
    public static final int DEFAULT_REQUESTPOOL_TIMEOUT = 2000;
    public static final int DEFAULT_CONNECTION_KEEP_ALIVE = -1;

    @AttributeDefinition(name="GraphQL Service Identifier", description="A unique identifier for this GraphQL client, used by the JCR resource property cq:graphqlClient to identify the service.", type=AttributeType.STRING, required=true)
    public String identifier() default "default";

    @AttributeDefinition(name="GraphQL Service URL", description="The URL of the GraphQL server endpoint, this must be a secure host using HTTPS.", type=AttributeType.STRING, required=true)
    public String url();

    @AttributeDefinition(name="Default HTTP method", description="The default HTTP method used to send GraphQL requests.", required=true)
    public HttpMethod httpMethod() default HttpMethod.POST;

    @AttributeDefinition(name="Accept self-signed SSL certificates", description="Enable insecure/developer mode to accept self-signed SSL certificates. Do NOT activate on production systems!", type=AttributeType.BOOLEAN)
    public boolean acceptSelfSignedCertificates() default false;

    @AttributeDefinition(name="Allow HTTP communication", description="Enable insecure/developer mode to allow communication via HTTP. Do NOT activate on production systems!", type=AttributeType.BOOLEAN)
    public boolean allowHttpProtocol() default false;

    @AttributeDefinition(name="Max HTTP connections", description="The maximum number of concurrent HTTP connections the connector can make", type=AttributeType.INTEGER)
    public int maxHttpConnections() default 20;

    @AttributeDefinition(name="Http connection timeout", description="The timeout in milliseconds until a connection is established. Is the timeout longer than the default timeout a warning will be logged. Is it 0 or smaller it will fallback to the default timeout and a warning will be logged. Defaults to 5000", type=AttributeType.INTEGER)
    public int connectionTimeout() default 5000;

    @AttributeDefinition(name="Http socket timeout", description="The socket timeout in milliseconds, which is the timeout for waiting for data or, put differently, a maximum period inactivity between two consecutive data packets. Is the timeout longer than the default timeout a warning will be logged. Is it 0 or smaller it will fallback to the default timeout and a warning will be logged. Defaults to 5000", type=AttributeType.INTEGER)
    public int socketTimeout() default 5000;

    @AttributeDefinition(name="Request pool timeout", description="The timeout in milliseconds used when requesting a connection from the connection manager. Is the timeout longer than the default timeout a warning will be logged. Is it 0 or smaller it will fallback to the default timeout and a warning will be logged. Defaults to 2000", type=AttributeType.INTEGER)
    public int requestPoolTimeout() default 2000;

    @AttributeDefinition(name="Connection keep alive timeout", description="The maximum number of seconds an unused connections is kept in the connection pool. If the value is < 0 than connections are kept alive indefinitely. Defaults to -1", type=AttributeType.INTEGER)
    public int connectionKeepAlive() default -1;

    @AttributeDefinition(name="Default HTTP Headers", description="HTTP Headers which shall be sent with each request. Might be used for authentication. The format of each header is name:value", type=AttributeType.STRING)
    public String[] httpHeaders();

    @AttributeDefinition(name="GraphQL cache configurations", description="Each entry must follow the format NAME:ENABLE:MAXSIZE:TIMEOUT like for example product:true:1000:5 - NAME (String) : the name of the cache - ENABLE (true|false) : enables or disables the cache with that NAME - MAXSIZE (Integer) : the maximum size of the cache in number of entries - TIMEOUT (Integer) : the timeout for each cache entry, in seconds.", type=AttributeType.STRING)
    public String[] cacheConfigurations();

    @AttributeDefinition(name="Ranking", description="Integer value defining the ranking of this queue configuration. If more than one GraphQL Client use the same identifier the one with the higher ranking will be used. Defaults to 0")
    public int service_ranking() default 0;
}

