/*******************************************************************************
 *
 *    ADOBE CONFIDENTIAL
 *     ___________________
 *
 *     Copyright 2021 Adobe
 *     All Rights Reserved.
 *
 *     NOTICE: All information contained herein is, and remains
 *     the property of Adobe and its suppliers, if any. The intellectual
 *     and technical concepts contained herein are proprietary to Adobe
 *     and its suppliers and are protected by all applicable intellectual
 *     property laws, including trade secret and copyright laws.
 *     Dissemination of this information or reproduction of this material
 *     is strictly forbidden unless prior written permission is obtained
 *     from Adobe.
 *
 ******************************************************************************/

package com.adobe.cq.cif.common.associatedcontent;

import java.util.Optional;

import org.apache.sling.api.resource.Resource;

/**
 * The {@link QueryResultTransformer} is used by the {@link AssociatedContentQuery} object to adapt the result set items
 * from {@link Resource} to whatever type is needed.
 *
 * @param <T> the type of the result
 */
public interface QueryResultTransformer<T> {
    /**
     * Transforms a {@link Resource} object to a different type.
     *
     * @param resource the object to transform
     * @return an {@link Optional} of the requested type
     */
    Optional<T> transform(Resource resource);
}
