/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.graphql.client;

import com.adobe.cq.commerce.graphql.client.CachingStrategy;
import com.adobe.cq.commerce.graphql.client.HttpMethod;
import com.google.gson.Gson;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.http.Header;

public class RequestOptions {
    private static final Comparator<Header> HEADER_COMPARATOR = Comparator.comparing(Header::getName).thenComparing(Header::getValue);
    private Gson gson;
    private List<Header> headers;
    private HttpMethod httpMethod;
    private CachingStrategy cachingStrategy;
    private Integer hash;

    public RequestOptions withGson(Gson gson) {
        this.gson = gson;
        return this;
    }

    public RequestOptions withHeaders(List<Header> headers) {
        this.headers = headers;
        return this;
    }

    public RequestOptions withHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public RequestOptions withCachingStrategy(CachingStrategy cachingStrategy) {
        this.cachingStrategy = cachingStrategy;
        return this;
    }

    public Gson getGson() {
        return this.gson;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public CachingStrategy getCachingStrategy() {
        return this.cachingStrategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestOptions that = (RequestOptions)o;
        if (!Objects.equals((Object)this.httpMethod, (Object)that.httpMethod)) {
            return false;
        }
        if (CollectionUtils.isEmpty(this.headers) && CollectionUtils.isEmpty(that.headers)) {
            return true;
        }
        if (this.headers == null ^ that.headers == null) {
            return false;
        }
        if (this.headers.size() != that.headers.size()) {
            return false;
        }
        List sortedHeaders = this.headers.stream().sorted(HEADER_COMPARATOR).collect(Collectors.toList());
        List thatSortedHeaders = that.headers.stream().sorted(HEADER_COMPARATOR).collect(Collectors.toList());
        int l = sortedHeaders.size();
        for (int i = 0; i < l; ++i) {
            Header header = (Header)sortedHeaders.get(i);
            Header thatHeader = (Header)thatSortedHeaders.get(i);
            if (!StringUtils.equals((CharSequence)header.getName(), (CharSequence)thatHeader.getName())) {
                return false;
            }
            if (StringUtils.equals((CharSequence)header.getValue(), (CharSequence)thatHeader.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash != null) {
            return this.hash;
        }
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.httpMethod);
        if (this.headers != null) {
            this.headers.stream().sorted(HEADER_COMPARATOR).forEach(h -> builder.append((Object)h.getName()).append((Object)h.getValue()));
        } else {
            builder.append(this.headers);
        }
        this.hash = builder.toHashCode();
        return this.hash;
    }
}

