/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.api.bridge;

import com.adobe.aem.dermis.api.bridge.ValidationOptions;
import com.adobe.aem.dermis.model.IDataModel;
import com.adobe.aem.dermis.model.value.IValueMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.json.JSONObject;

public class OperationOptions {
    private JSONObject arguments;
    private IValueMap argumentsValueMap;
    private String configurationPath;
    private String selectionPoints;
    private String schemaName;
    private Map<String, String> entityOperationMapping;
    private boolean isOutputTypeArray;
    private ValidationOptions validationOptions = ValidationOptions.BASIC;
    private List<? extends IDataModel> dataModelList = new ArrayList<IDataModel>();

    public OperationOptions(String selectionPoints, Map<String, String> entityOperationMapping) {
        this.selectionPoints = selectionPoints;
        this.entityOperationMapping = entityOperationMapping;
    }

    @Deprecated
    public OperationOptions(String operationId, JSONObject arguments) {
        this.entityOperationMapping = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)operationId)) {
            this.entityOperationMapping.put(null, operationId);
        }
        this.arguments = arguments;
    }

    public OperationOptions(String operationId, IValueMap argumentsValueMap) {
        this.entityOperationMapping = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)operationId)) {
            this.entityOperationMapping.put(null, operationId);
        }
        this.argumentsValueMap = argumentsValueMap;
    }

    public String getSelectionPoints() {
        return this.selectionPoints;
    }

    public void setSelectionPoints(String selectionPoints) {
        this.selectionPoints = selectionPoints;
    }

    public Map<String, String> getEntityOperationMapping() {
        return this.entityOperationMapping;
    }

    public void setEntityOperationMapping(Map<String, String> entityOperationMapping) {
        this.entityOperationMapping = entityOperationMapping;
    }

    @Deprecated
    public JSONObject getArguments() {
        return this.arguments;
    }

    public IValueMap getArgumentsValueMap() {
        return this.argumentsValueMap;
    }

    @Deprecated
    public void setArguments(JSONObject arguments) {
        this.arguments = arguments;
    }

    public void setArgumentsValueMap(IValueMap arguments) {
        this.argumentsValueMap = arguments;
    }

    public String getEntityId() {
        Map.Entry<String, String> entry;
        String entityName = null;
        if (this.entityOperationMapping != null && this.entityOperationMapping.size() > 0 && (entry = this.entityOperationMapping.entrySet().iterator().next()) != null) {
            entityName = entry.getKey();
        }
        return entityName;
    }

    public String getOperationId() {
        Map.Entry<String, String> entry;
        String operationId = null;
        if (this.entityOperationMapping != null && this.entityOperationMapping.size() > 0 && (entry = this.entityOperationMapping.entrySet().iterator().next()) != null) {
            operationId = entry.getValue();
        }
        return operationId;
    }

    public void setSchemaName(String name) {
        this.schemaName = name;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public boolean getOutputTypeArray() {
        return this.isOutputTypeArray;
    }

    public void setOutputTypeArray(boolean isOutputTypeArray) {
        this.isOutputTypeArray = isOutputTypeArray;
    }

    public ValidationOptions getValidationOptions() {
        return this.validationOptions;
    }

    public void setValidationOptions(ValidationOptions validationOptions) {
        this.validationOptions = validationOptions;
    }

    public List<? extends IDataModel> getDataModelList() {
        return this.dataModelList;
    }

    public void setDataModelList(List<? extends IDataModel> dataModelList) {
        this.dataModelList = dataModelList;
    }

    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public void setConfigurationPath(String configurationPath) {
        this.configurationPath = configurationPath;
    }
}

