/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideNode;
import com.adobe.aemds.guide.common.GuidePanel;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.script.SimpleBindings;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class GuideTable
extends GuidePanel {
    private static String TABLE_ITEM = "tableItem";
    private static String HEADER_ROW = "HeaderRow";
    private static String HEADER_ITEM = "headerItem";
    private static String RESOURCE = "resource";
    private static String REQUEST = "request";
    private static final Map<String, String> TABLE_HEADER_PROPERTIES = new HashMap<String, String>();
    private static final Map<String, String> TABLE_HEADER_ITEM_PROPERTIES = new HashMap<String, String>();
    private static final Map<String, String> TABLE_LAYOUT_PROPERTIES = new HashMap<String, String>();

    public static Boolean isTableHeader(GuideNode guideNode) {
        Boolean isTableHeader = Boolean.TRUE;
        String itemType = guideNode.getResourceType();
        String itemSuperType = guideNode.getResourceSuperType();
        if (!"fd/af/components/tableHeader".equals(itemType) && !"fd/af/components/tableHeader".equals(itemSuperType)) {
            isTableHeader = Boolean.FALSE;
        }
        return isTableHeader;
    }

    private void addProperties(Node node, Map<String, String> map) throws Exception {
        Set<String> keys = map.keySet();
        for (String key : keys) {
            node.setProperty(key, map.get(key));
        }
    }

    private GuideNode createTableHeader(GuideNode firstItem) {
        GuideNode tableHeader = null;
        ResourceResolver resourceResolver = this.getResourceResolver();
        try {
            Resource itemsResource = this.getResource().getChild("items");
            Node itemsNode = (Node)itemsResource.adaptTo(Node.class);
            Iterable children = itemsResource.getChildren();
            StringBuilder sb = new StringBuilder();
            for (Resource child : children) {
                sb.append(",");
                sb.append(child.getName());
            }
            String names = HEADER_ROW + sb.toString();
            Node tableHeaderNode = itemsNode.addNode(HEADER_ROW, "nt:unstructured");
            tableHeaderNode.setProperty("visible", Boolean.FALSE.booleanValue());
            this.addProperties(tableHeaderNode, TABLE_HEADER_PROPERTIES);
            JcrUtil.setChildNodeOrder((Node)itemsNode, (String)names);
            Node tableHeaderLayout = tableHeaderNode.addNode("layout", "nt:unstructured");
            this.addProperties(tableHeaderLayout, TABLE_LAYOUT_PROPERTIES);
            tableHeaderLayout.setProperty("nonNavigable", Boolean.TRUE.booleanValue());
            Node tableHeaderItemsNode = tableHeaderNode.addNode("items", "nt:unstructured");
            this.addProperties(tableHeaderItemsNode, TABLE_LAYOUT_PROPERTIES);
            Iterable columnList = firstItem.getResource().getChild("items").getChildren();
            int numberOfColumns = 0;
            for (Resource column : columnList) {
                String colspan = (String)column.getValueMap().get("colspan", (Object)"1");
                int span = 1;
                try {
                    span = Integer.parseInt(colspan);
                }
                catch (Exception e) {
                    this.logger.error("Incorrect colspan configured {} at path {}", new Object[]{colspan, column.getPath(), e});
                    span = 1;
                }
                numberOfColumns += span;
            }
            for (int i = 1; i <= numberOfColumns; ++i) {
                Node childNode = tableHeaderItemsNode.addNode(TABLE_ITEM + i, "nt:unstructured");
                childNode.setProperty("name", HEADER_ITEM + i);
                this.addProperties(childNode, TABLE_HEADER_ITEM_PROPERTIES);
            }
            resourceResolver.commit();
            tableHeader = new GuideNode();
            SimpleBindings bindings = new SimpleBindings();
            bindings.put(RESOURCE, (Object)itemsResource.getChild(HEADER_ROW));
            bindings.put(REQUEST, (Object)this.slingRequest);
            tableHeader.init(bindings);
        }
        catch (Exception e) {
            this.logger.error("Error occured in creating dummy table header for table at path " + this.getPath(), (Throwable)e);
        }
        return tableHeader;
    }

    @Override
    public List<GuideNode> getItems() {
        List<GuideNode> items;
        List<GuideNode> finalItems = items = super.getItems();
        GuideNode firstItem = items.get(0);
        if (this.getIsEditMode().booleanValue() && !GuideTable.isTableHeader(firstItem).booleanValue()) {
            finalItems = new ArrayList<GuideNode>();
            GuideNode tableHeader = this.createTableHeader(firstItem);
            if (tableHeader != null) {
                finalItems.add(tableHeader);
            }
            finalItems.addAll(items);
        }
        return finalItems;
    }

    public int getColumns(GuideNode row) {
        GuidePanel panel = new GuidePanel();
        SimpleBindings bindings = new SimpleBindings();
        bindings.put(RESOURCE, (Object)this.slingRequest.getResourceResolver().getResource(row.getPath()));
        bindings.put(REQUEST, (Object)this.slingRequest);
        panel.init(bindings);
        return panel.getItems().size();
    }

    public ArrayList<Boolean> getSortingAllowedHeader() {
        List<GuideNode> elements = this.getItems();
        ArrayList<Boolean> sortableHeaderList = new ArrayList<Boolean>();
        int currColumn = 0;
        int totalColumns = this.getColumns();
        Boolean isSortingAllowed = "true".equals(this.isSortingEnabled());
        for (currColumn = 0; currColumn < totalColumns; ++currColumn) {
            sortableHeaderList.add(isSortingAllowed);
        }
        if (isSortingAllowed.booleanValue()) {
            try {
                for (GuideNode guideNode : elements) {
                    if (guideNode.getResourceType().equals("fd/ccm/web-channel/components/tableHeader/v1/tableHeader") || guideNode.getResourceType().equals("fd/af/components/tableHeader")) continue;
                    List<GuideNode> tableCellNode = this.getTableRowItems(guideNode);
                    for (currColumn = 0; currColumn < tableCellNode.size(); ++currColumn) {
                        String guideNodeClass;
                        if (!sortableHeaderList.get(currColumn).booleanValue() || !this.isTableCellPrimitiveComponent(guideNodeClass = tableCellNode.get(currColumn).getNodeClass()).booleanValue()) continue;
                        sortableHeaderList.set(currColumn, false);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Error in updating tableHeader info", (Throwable)e);
            }
        }
        return sortableHeaderList;
    }

    private List<GuideNode> getTableRowItems(GuideNode row) {
        GuidePanel panel = new GuidePanel();
        SimpleBindings bindings = new SimpleBindings();
        bindings.put(RESOURCE, (Object)row.getResource());
        bindings.put(REQUEST, (Object)this.slingRequest);
        panel.init(bindings);
        return panel.getItems();
    }

    private Boolean isTableCellPrimitiveComponent(String guideNodeClass) {
        return guideNodeClass != null && !guideNodeClass.equals("guideTextBox") && !guideNodeClass.equals("guideNumericBox") && !guideNodeClass.equals("guideDatePicker") && !guideNodeClass.equals("guideTextDraw");
    }

    public int getColumns() {
        List<GuideNode> elements = this.getItems();
        int max = -1;
        int size = elements.size();
        for (int j = 0; j < size; ++j) {
            GuideNode par = elements.get(j);
            int columns = this.getColumns(par);
            if (columns <= max) continue;
            max = columns;
        }
        return max;
    }

    public String getMobileLayout() {
        return (String)this.resourceProps.get("./layout/mobileLayout", (Object)"");
    }

    public String getSummary() {
        return (String)this.resourceProps.get("./tableSummaryText", (Object)"");
    }

    public String isSortingEnabled() {
        return (String)this.resourceProps.get("./sortingEnabled", (Object)"false");
    }

    public String getColumnWidth() {
        return (String)this.resourceProps.get("columnWidth", (Object)"");
    }

    static {
        TABLE_HEADER_PROPERTIES.put("guideNodeClass", "guideTableRow");
        TABLE_HEADER_PROPERTIES.put("jcr:title", "Header Row");
        TABLE_HEADER_PROPERTIES.put("sling:resourceType", "fd/af/components/tableHeader");
        TABLE_HEADER_PROPERTIES.put("guideComponentType", "true");
        TABLE_HEADER_PROPERTIES.put("name", "headerRow");
        TABLE_LAYOUT_PROPERTIES.put("sling:resourceType", "fd/af/layouts/table/headerLayout");
        TABLE_HEADER_ITEM_PROPERTIES.put("guideNodeClass", "guideTextDraw");
        TABLE_HEADER_ITEM_PROPERTIES.put("_value", "");
        TABLE_HEADER_ITEM_PROPERTIES.put("sling:resourceType", "fd/af/components/guidetextdraw");
        TABLE_HEADER_ITEM_PROPERTIES.put("guideComponentType", "true");
    }
}

