/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common.xfa;

import com.adobe.aemds.guide.common.xfa.XFAElement;
import com.adobe.aemds.guide.common.xfa.XFAJSONVisitor;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

public class XFADraw
extends XFAElement {
    private static final String defaultDrawElement = "{\"_class\":\"draw\",\"children\":[{\"_class\":\"extras\",\"name\":\"\",\"children\":[{\"_class\":\"extras\",\"children\":[{\"_class\":\"text\",\"_value\":\"${somExpression}\",\"name\":\"FS_SOM\"}],\"name\":\"FS_EXTRAS\"}]},{\"_class\":\"ui\",\"children\":[{\"_class\":\"textEdit\",\"children\":[{\"_class\":\"margin\"}]}]},{\"_class\":\"value\",\"children\":[{\"_class\":\"exData\",\"_value\":\"<body><p style=\\\"font-weight:normal;font-style:normal;letter-spacing:0in\\\">Element with ${somExpression} cannot be translated</p></body>\",\"contentType\":\"text/html\",\"rid\":\"2EC0D980-03D6-41E5-8C42-866C6A7DF060\"}]}],\"name\":\"${name}\"}";

    public XFADraw(ObjectNode object) {
        super(object);
    }

    public static XFADraw createDrawElement(String somExpression, String name) throws IOException {
        String drawElement = defaultDrawElement.replace("${somExpression}", somExpression).replace("${name}", name);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(drawElement);
        return new XFADraw((ObjectNode)jsonNode);
    }

    @Override
    public void accept(XFAJSONVisitor visitor) throws Exception {
        visitor.visit(this);
    }

    public boolean isRichText() throws Exception {
        JsonNode node = this.getOrElse("value.oneOfChild._class", null, true);
        String drawValueType = "string";
        if (node != null) {
            drawValueType = node.asText();
        }
        return "exData".equals(drawValueType);
    }

    public String getValue() throws Exception {
        JsonNode node = this.getOrElse("value.oneOfChild._class", null, true);
        String drawValueType = null;
        if (node != null) {
            drawValueType = node.asText();
        }
        node = this.getOrElse("value." + drawValueType + "._value", true);
        String textValue = null;
        if (node != null) {
            textValue = node.asText();
        }
        return textValue;
    }
}

