/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemfd.dermis.authentication.model;

import com.adobe.aemfd.dermis.authentication.exception.DermisLogger;
import com.adobe.aemfd.dermis.authentication.model.Configuration;
import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import javax.inject.Inject;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;

@Model(adaptables={Resource.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class AzureConfiguration
extends Configuration {
    @OSGiService
    private CryptoSupport cryptoSupport;
    @Inject
    private String accountName;
    @Inject
    private String accountKey;
    @Inject
    @Optional
    private String blobEndPoint;
    @Inject
    @Optional
    private boolean honorProxy;

    public AzureConfiguration(Resource resource) {
        super(resource);
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountKey() {
        String decryptedAccountKey = this.accountKey;
        if (this.cryptoSupport != null) {
            try {
                if (this.cryptoSupport.isProtected(this.accountKey)) {
                    decryptedAccountKey = this.cryptoSupport.unprotect(this.accountKey);
                }
            }
            catch (CryptoException cryptoException) {
                DermisLogger.logErrorAndDebug(AzureConfiguration.class, "Error while decrypting the Account Key", (Exception)((Object)cryptoException));
            }
        }
        return decryptedAccountKey;
    }

    public void setAccountKey(String accountKey) {
        this.accountKey = accountKey;
    }

    public String getBlobEndPoint() {
        return this.blobEndPoint;
    }

    public void setBlobEndPoint(String blobEndPoint) {
        this.blobEndPoint = blobEndPoint;
    }

    public boolean isHonorProxy() {
        return this.honorProxy;
    }

    public void setHonorProxy(boolean honourProxy) {
        this.honorProxy = honourProxy;
    }
}

