/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.assembler.client;

import com.adobe.fd.assembler.Util.Constants;
import com.adobe.fd.assembler.client.ASMMsgSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class MsgUtil {
    private static Pattern pattern = Pattern.compile(Constants.CODE_CAPTURE_REGEX);

    private MsgUtil() {
    }

    public static String getMsg(String code) {
        return ASMMsgSet.getMessage(code, null);
    }

    public static String getMsg(String code, Object arg0) {
        Object[] args = new Object[]{arg0};
        return ASMMsgSet.getMessage(code, args);
    }

    public static String getMsg(String code, Object arg0, Object arg1) {
        Object[] args = new Object[]{arg0, arg1};
        return ASMMsgSet.getMessage(code, args);
    }

    public static String getMsg(String code, Object arg0, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        return ASMMsgSet.getMessage(code, args);
    }

    public static String getMsg(String code, Object arg0, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        return ASMMsgSet.getMessage(code, args);
    }

    public static String getBaseErrorMessage(String errorMessage) {
        StringBuilder sourceErrorMessage = new StringBuilder();
        String sourceCode = "";
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            String[] parts = errorMessage.split(":");
            for (int i = 0; i < parts.length; ++i) {
                Matcher matcher = pattern.matcher(parts[i].trim());
                if (matcher.matches()) {
                    sourceCode = parts[i].trim();
                    sourceErrorMessage.setLength(0);
                    continue;
                }
                sourceErrorMessage.append(parts[i]);
                if (i == parts.length - 1) continue;
                sourceErrorMessage.append(":");
            }
        }
        return sourceCode + ":" + sourceErrorMessage;
    }

    public static String getMessageFromBaseErrorMessage(String baseErrorMessage, boolean includeOSGICode) {
        if (StringUtils.isBlank((CharSequence)baseErrorMessage)) {
            return "";
        }
        String resultMessage = baseErrorMessage;
        String osgiCode = MsgUtil.getOSGICodeFromExceptionMessge(baseErrorMessage);
        if (StringUtils.isBlank((CharSequence)osgiCode) || !includeOSGICode) {
            resultMessage = baseErrorMessage.substring(baseErrorMessage.indexOf(":") + 1);
        }
        return resultMessage;
    }

    public static String getOSGICodeFromBaseErrorMessage(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return "";
        }
        return message.substring(0, message.indexOf(":"));
    }

    public static String getMessageFromExceptionMessage(String message, boolean includeOSGICode) {
        return MsgUtil.getMessageFromBaseErrorMessage(MsgUtil.getBaseErrorMessage(message), includeOSGICode);
    }

    public static String getOSGICodeFromExceptionMessge(String message) {
        return MsgUtil.getOSGICodeFromBaseErrorMessage(MsgUtil.getBaseErrorMessage(message));
    }
}

