/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.util;

import com.adobe.aem.dermis.model.IDataModel;
import com.adobe.aem.dermis.model.IProperty;
import com.adobe.aem.dermis.model.PropertyFormatType;
import com.adobe.aem.dermis.model.PropertyType;
import com.adobe.aem.dermis.model.value.TypeValue;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.SerializationUtils;

public class DataModelUtils {
    private static final String FDM_ADDITIONAL_DATA_KEY = "_fdm_additionalData";
    private static final String TYPE = "_type";
    private static final String SCHEMA = "_schema";

    public static Class getJavaClassForTypeAndFormat(PropertyType propertyType, PropertyFormatType formatType) {
        Class type = null;
        if (formatType != null) {
            type = formatType.getClassType();
        } else if (propertyType != null) {
            type = propertyType.getClassType();
        }
        return type;
    }

    public static IDataModel resolveType(List<? extends IDataModel> dataModels, Map data) {
        if (data instanceof Map && DataModelUtils.hasTypeInfoInAdditonalData(data)) {
            Map fdm_additionalData = (Map)data.get(FDM_ADDITIONAL_DATA_KEY);
            Object typeObject = fdm_additionalData.get(TYPE);
            Object schemaObject = fdm_additionalData.get(SCHEMA);
            String type = null;
            String schema = null;
            if (typeObject instanceof String) {
                type = (String)typeObject;
            } else if (typeObject instanceof TypeValue) {
                type = (String)((TypeValue)typeObject).get();
            }
            if (schemaObject instanceof String) {
                schema = (String)schemaObject;
            } else if (schemaObject instanceof TypeValue) {
                schema = (String)((TypeValue)schemaObject).get();
            }
            return DataModelUtils.getDatamodelByNameAndSchema(dataModels, type, schema);
        }
        return null;
    }

    public static IDataModel getDatamodelByNameAndSchema(List<? extends IDataModel> dataModels, String entityName, String schema) {
        IDataModel result = null;
        if ((entityName != null || entityName.length() != 0) && dataModels != null) {
            for (IDataModel iDataModel : dataModels) {
                if (!iDataModel.getName().equals(entityName) || schema != null && !schema.isEmpty() && !iDataModel.getSchemaName().equals(schema)) continue;
                result = iDataModel;
                break;
            }
        }
        return (IDataModel)SerializationUtils.clone(result);
    }

    public static IDataModel getRefDatamodel(List<? extends IDataModel> dataModels, IProperty property) {
        PropertyType type;
        IDataModel refDataModel = null;
        if (property != null && (PropertyType.ARRAY == (type = property.getType()) || PropertyType.OBJECT == type)) {
            String dataModelNameRef = property.getReferenceName();
            if (dataModels != null && dataModelNameRef != null && !dataModelNameRef.trim().isEmpty()) {
                refDataModel = DataModelUtils.getDatamodelByNameAndSchema(dataModels, dataModelNameRef, null);
            }
        }
        return refDataModel;
    }

    private static boolean hasTypeInfoInAdditonalData(Object data) {
        Map fdmAdditionalData;
        return DataModelUtils.hasFDMAdditionalDataInfoInData(data) && (fdmAdditionalData = (Map)((Map)data).get(FDM_ADDITIONAL_DATA_KEY)).containsKey(TYPE);
    }

    private static boolean hasFDMAdditionalDataInfoInData(Object data) {
        return data instanceof Map && ((Map)data).containsKey(FDM_ADDITIONAL_DATA_KEY);
    }
}

