/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.StyledFDField;
import com.adobe.aemds.guide.model.ResponsiveConfiguration;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.utils.GuideConstants;
import com.adobe.aemds.guide.utils.GuideContainerThreadLocal;
import com.adobe.aemds.guide.utils.GuideFragmentHolder;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.cq.sightly.WCMUsePojo;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.WCMMode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.jcr.RepositoryException;
import javax.script.SimpleBindings;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={StyledFDField.class})
public class GuideNode
extends WCMUsePojo
implements Serializable,
StyledFDField {
    @Self
    protected SlingHttpServletRequest slingRequest;
    @SlingObject
    protected Resource resource;
    @ScriptVariable(name="properties")
    protected ValueMap resourceProps;
    @OSGiService
    private org.apache.sling.xss.XSSAPI slingXSSApi;
    protected String id = null;
    protected String clientLibRef = null;
    protected String baseName = null;
    protected String localeName = null;
    public I18n i18n = null;
    protected Locale locale = null;
    protected XSSAPI xssapi = null;
    protected String error = null;
    protected Map<String, String> inlineStyles = null;
    protected Logger logger = LoggerFactory.getLogger(GuideNode.class);
    private static String DEFAULT_RESPONSIVE_CLASSES = "fd-col-lg-12 fd-col-md-12 fd-col-sm-12 fd-col-xs-12";

    public void activate() throws Exception {
        this.resourceProps = ResourceUtil.getValueMap((Resource)this.getResource());
        this.id = GuideUtils.getGuideNodeHtmlId(this.getResource());
        this.setSlingRequest(this.getRequest());
        this.setSlingXssApi(this.slingRequest);
    }

    @PostConstruct
    private void initModel() {
        if (this.slingRequest != null && this.resource != null) {
            SlingBindings existingBindings = (SlingBindings)this.slingRequest.getAttribute(SlingBindings.class.getName());
            SimpleBindings bindings = new SimpleBindings();
            bindings.putAll((Map<? extends String, ? extends Object>)existingBindings);
            this.init(bindings);
        }
    }

    private ResponsiveConfiguration getResponsiveConfiguration() {
        Resource responsiveResource;
        ResponsiveConfiguration responsiveConfiguration = null;
        Resource resource = this.getResource();
        if (resource != null && (responsiveResource = resource.getChild("cq:responsive")) != null) {
            responsiveConfiguration = (ResponsiveConfiguration)responsiveResource.adaptTo(ResponsiveConfiguration.class);
        }
        return responsiveConfiguration;
    }

    public String getResponsiveClasses() {
        String responsiveClasses = DEFAULT_RESPONSIVE_CLASSES;
        ResponsiveConfiguration responsiveConfiguration = this.getResponsiveConfiguration();
        if (responsiveConfiguration != null) {
            responsiveClasses = responsiveConfiguration.getResponsiveClasses();
        }
        return responsiveClasses;
    }

    @Override
    public String getGuideFieldType() {
        return "";
    }

    @Override
    public String getAuthoringConfigJSON() {
        Map<String, Object> authoringConfig = this.getAuthoringConfig();
        JSONObject authoringConfigJson = new JSONObject(authoringConfig);
        return authoringConfigJson.toString();
    }

    public Map<String, Object> getAuthoringConfig() {
        HashMap<String, Object> authoringConfig = new HashMap<String, Object>();
        int colspan = this.getColspan();
        String inlineCssClass = this.getInlineCssClass();
        String title = this.getTitle();
        String enabled = this.getEnabled();
        String visible = this.getVisible();
        authoringConfig.put("colspan", colspan);
        authoringConfig.put("title", " ".equals(title) ? this.getName() : title);
        authoringConfig.put("name", this.getName());
        if (!inlineCssClass.isEmpty()) {
            authoringConfig.put("inlineCssClass", inlineCssClass);
        }
        if (enabled != null) {
            authoringConfig.put("enabled", enabled);
        }
        if (visible != null) {
            authoringConfig.put("visible", visible);
        }
        return authoringConfig;
    }

    public boolean checkIfPathIsAbsolute(String path) {
        return (StringUtils.startsWith((CharSequence)path, (CharSequence)"/libs") || StringUtils.startsWith((CharSequence)path, (CharSequence)"/apps")) && StringUtils.endsWith((CharSequence)path, (CharSequence)".jsp");
    }

    public String getAppearance() {
        return (String)this.resourceProps.get("appearance", (Object)"");
    }

    public String getStyles() {
        String style = "";
        String width = this.getWidth();
        String height = this.getHeight();
        style = style + (width.length() > 0 ? "max-width:" + width + "%;" : "");
        style = style + (height.length() > 0 ? "height:" + height + "px;" : "");
        return style;
    }

    public String getInlineStyles(String name) {
        if (this.inlineStyles == null) {
            this.inlineStyles = new HashMap<String, String>();
            String[] test = new String[]{""};
            String[] inlineStylesProperties = (String[])this.resourceProps.get("inlineStyles", (Object)test);
            if (!"".equals(inlineStylesProperties[0])) {
                for (int i = 0; i < inlineStylesProperties.length; ++i) {
                    String componentProperties = inlineStylesProperties[i].substring(inlineStylesProperties[i].indexOf("{") + 1, inlineStylesProperties[i].indexOf("}"));
                    componentProperties = componentProperties.replace(',', ';');
                    componentProperties = GuideUtils.sanitizeCSSString(componentProperties, this.slingXSSApi);
                    String prefix = inlineStylesProperties[i].substring(0, inlineStylesProperties[i].indexOf("{"));
                    if ("Field".equalsIgnoreCase(prefix)) {
                        this.inlineStyles.put("Field", componentProperties);
                        continue;
                    }
                    if ("Panel".equalsIgnoreCase(prefix)) {
                        this.inlineStyles.put("Panel", componentProperties);
                        continue;
                    }
                    if ("PanelDescription".equalsIgnoreCase(prefix)) {
                        this.inlineStyles.put("PanelDescription", componentProperties);
                        continue;
                    }
                    if ("Widget".equalsIgnoreCase(prefix)) {
                        this.inlineStyles.put("Widget", componentProperties);
                        continue;
                    }
                    if ("Caption".equalsIgnoreCase(prefix)) {
                        this.inlineStyles.put("Caption", componentProperties);
                        continue;
                    }
                    if ("QuestionMark".equalsIgnoreCase(prefix)) {
                        this.inlineStyles.put("QuestionMark", componentProperties);
                        continue;
                    }
                    if ("ShortDescription".equalsIgnoreCase(prefix)) {
                        this.inlineStyles.put("ShortDescription", componentProperties);
                        continue;
                    }
                    if (!"LongDescription".equalsIgnoreCase(prefix)) continue;
                    this.inlineStyles.put("LongDescription", componentProperties);
                }
            }
        }
        return this.inlineStyles.get(name);
    }

    public String getFieldInlineStyles() {
        return this.getInlineStyles("Field");
    }

    public String getQuestionMarkInlineStyles() {
        return this.getInlineStyles("QuestionMark");
    }

    public String getLongDescriptionInlineStyles() {
        return this.getInlineStyles("LongDescription");
    }

    public Integer getColspan() {
        return Integer.parseInt((String)this.resourceProps.get("colspan", (Object)"1"));
    }

    public String getInlineCssClass() {
        return (String)this.resourceProps.get("cq:cssClass", (Object)"");
    }

    @Override
    public String getHeight() {
        return (String)this.resourceProps.get("height", (Object)"");
    }

    @Override
    public String getWidth() {
        return (String)this.resourceProps.get("width", (Object)"");
    }

    public String getVersion() {
        return (String)this.resourceProps.get("fd:version", (Object)"1.0");
    }

    public String getTargetVersion() {
        return (String)this.resourceProps.get("fd:targetVersion", (Object)"1.0");
    }

    public void setResource(Resource resource) {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("resource", (Object)resource);
        this.init(bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSlingRequest(SlingHttpServletRequest slingRequest) {
        ResourceResolverFactory resourceResolverFactory;
        SlingBindings bindings;
        this.slingRequest = slingRequest;
        try {
            GuideFragmentHolder guideFragmentHolder = GuideContainerThreadLocal.getGuideFragmentHolder();
            if (guideFragmentHolder != null) {
                this.i18n = guideFragmentHolder.getI18n();
                if (this.i18n == null && slingRequest != null) {
                    this.i18n = GuideUtils.getI18n(slingRequest, this.getResource());
                }
            } else if (slingRequest != null) {
                this.i18n = GuideUtils.getI18n(slingRequest, this.getResource());
            }
        }
        catch (Exception e) {
            this.logger.error("Error in setting sling request in guide node", (Throwable)e);
        }
        if (slingRequest != null && (bindings = (SlingBindings)slingRequest.getAttribute(SlingBindings.class.getName())) != null && (resourceResolverFactory = (ResourceResolverFactory)bindings.getSling().getService(ResourceResolverFactory.class)) != null) {
            try (ResourceResolver serviceResourceResolver = null;){
                serviceResourceResolver = resourceResolverFactory.getServiceResourceResolver(null);
                this.validate(serviceResourceResolver);
            }
        }
    }

    public void setSlingXssApi(SlingHttpServletRequest slingRequest) {
        try {
            SlingBindings bindings;
            if (slingRequest != null && (bindings = (SlingBindings)slingRequest.getAttribute(SlingBindings.class.getName())) != null) {
                this.slingXSSApi = (org.apache.sling.xss.XSSAPI)bindings.getSling().getService(org.apache.sling.xss.XSSAPI.class);
            }
        }
        catch (Exception e) {
            this.logger.info("[AF] problem occured in setSlingXssApi GuideNode.java {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public I18n getI18n() {
        return this.i18n;
    }

    public String getEnabledExp() {
        return (String)this.resourceProps.get("enabledExp", (Object)"");
    }

    @Override
    public String getName() {
        return StringEscapeUtils.escapeHtml4((String)GuideUtils.getGuideName(this.getResource()));
    }

    @Override
    public String getDescription() {
        return this.externalize((String)this.resourceProps.get("jcr:description", (Object)""), "jcr:description");
    }

    public String getXssDescription() {
        return this.i18n.getVar(this.getDescription());
    }

    @Override
    public String getId() throws RepositoryException {
        return GuideUtils.encodeForHtml(this.id, this.getXssapi());
    }

    public Boolean getIsEditMode() {
        return WCMMode.fromRequest((ServletRequest)this.slingRequest) == WCMMode.EDIT || WCMMode.fromRequest((ServletRequest)this.slingRequest) == WCMMode.DESIGN;
    }

    public boolean getIsRepeatable() {
        return false;
    }

    public List<GuideNode> getItems() {
        return new ArrayList<GuideNode>();
    }

    @Override
    public String getPath() {
        return this.getResource().getPath();
    }

    public String getResourceType() {
        return this.getResource().getResourceType();
    }

    public String getResourceSuperType() {
        return this.getResource().getResourceSuperType();
    }

    public String getLayoutPath() throws PersistenceException {
        return (String)this.getLayoutProperty("sling:resourceType");
    }

    public Boolean getNonNavigableProperty() {
        Boolean nonNavigable = Boolean.FALSE;
        try {
            Object nonNavigableLayoutPropertyValue = this.getLayoutProperty("nonNavigable");
            if (nonNavigableLayoutPropertyValue == null) {
                Map<String, Object> layoutproperties = GuideUtils.getLayoutProperties(this.slingRequest, this.getResource(), "panel");
                Object resourceType = layoutproperties.get("sling:resourceType");
                String resourceTypeAsString = null;
                if (resourceType != null) {
                    resourceTypeAsString = resourceType.toString();
                }
                if (StringUtils.isNotBlank(resourceTypeAsString) && (StringUtils.equals((CharSequence)resourceTypeAsString, (CharSequence)"fd/af/layouts/gridFluidLayout") || StringUtils.equals((CharSequence)resourceTypeAsString, (CharSequence)"fd/af/layouts/gridFluidLayout2"))) {
                    nonNavigable = Boolean.TRUE;
                }
            } else {
                nonNavigable = nonNavigableLayoutPropertyValue instanceof String ? Boolean.valueOf(Boolean.parseBoolean((String)nonNavigableLayoutPropertyValue)) : (Boolean)nonNavigableLayoutPropertyValue;
            }
        }
        catch (Exception e) {
            this.logger.error("AF: Unable to fetch nonNavigable property" + e.getMessage(), (Throwable)e);
        }
        return nonNavigable;
    }

    public boolean isLayoutNavigable() throws PersistenceException {
        Boolean nonNavigableProp = this.getNonNavigableProperty();
        if (nonNavigableProp == null) {
            String layoutPath = GuideUtils.getNormalizedNodeType(this.getLayoutPath(), null);
            nonNavigableProp = "fd/af/layouts/gridFluidLayout".equals(layoutPath) || "fd/af/layouts/gridFluidLayout2".equals(layoutPath) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return nonNavigableProp == false;
    }

    public boolean isMenuRequired() {
        Resource res = this.getResource();
        String normalizedResourceType = GuideUtils.getNormalizedNodeType(this.getResourceType(), this.getResourceSuperType());
        if (GuideConstants.MOBILE_MENU_RESOURCES.contains(normalizedResourceType)) {
            return true;
        }
        return res != null && res.isResourceType("fd/af/components/panel");
    }

    public boolean isDocumentFragmentGroup() {
        String normalizedResourceType = GuideUtils.getNormalizedNodeType(this.getResourceType(), this.getResourceSuperType());
        return "fd/adaddon/components/guideAdModuleGroup".equals(normalizedResourceType) || "fd/ccm/web-channel/components/documentFragmentGroup/v1/documentFragmentGroup".equals(normalizedResourceType);
    }

    protected Object getLayoutProperty(String property) throws PersistenceException {
        Map<String, Object> layoutproperties = GuideUtils.getLayoutProperties(this.slingRequest, this.getResource(), "panel");
        if (layoutproperties != null) {
            return layoutproperties.get(property);
        }
        return null;
    }

    public String getLayoutTabType() throws PersistenceException {
        String tabType = (String)this.getLayoutProperty("guideNavigatorTab");
        if (tabType == null) {
            String layoutPath = GuideUtils.getNormalizedNodeType(this.getLayoutPath(), null);
            tabType = "fd/af/layouts/panel/wizard".equals(layoutPath) ? "wizard-tab" : "tab";
        }
        return tabType;
    }

    public String getToolbarPosition() throws PersistenceException {
        String layout;
        Map<String, Object> layoutproperties = GuideUtils.getLayoutProperties(this.slingRequest, this.getResource(), "panel");
        if (layoutproperties != null && StringUtils.isNotEmpty((CharSequence)(layout = (String)layoutproperties.get("toolbarPosition")))) {
            return layout;
        }
        return "Bottom";
    }

    public String getAddMessage() {
        String add = this.i18n.get("Add ");
        return add + this.getNavTitle();
    }

    public String getRemoveMessage() {
        String add = this.i18n.get("Remove ");
        return add + this.getNavTitle();
    }

    public String getNavTitle() {
        return this.externalize((String)this.resourceProps.get("navTitle", (Object)this.getTitle()), "navTitle");
    }

    public Boolean getIsTitleRichText() {
        return (Boolean)this.resourceProps.get("isTitleRichText", (Object)false);
    }

    @Override
    public String getTitle() {
        String title = this.externalize((String)this.resourceProps.get("jcr:title", (Object)" "), "jcr:title");
        return this.getIsTitleRichText() != false ? GuideUtils.filterHtml(title, this.getXssapi()) : title;
    }

    public SlingHttpServletRequest getSlingRequest() {
        return this.slingRequest;
    }

    public String getNodeClass() {
        return (String)this.resourceProps.get("guideNodeClass", (Object)"");
    }

    public String getVisibleExp() {
        return (String)this.resourceProps.get("visibleExp", (Object)"");
    }

    public XSSAPI getXssapi() {
        if (this.slingRequest != null) {
            return (XSSAPI)this.slingRequest.adaptTo(XSSAPI.class);
        }
        return null;
    }

    @Override
    public String getCssClassName() {
        return (String)this.resourceProps.get("css", (Object)"");
    }

    public String externalize(String value, String key) {
        boolean editMode;
        boolean bl = editMode = WCMMode.fromRequest((ServletRequest)this.slingRequest) == WCMMode.EDIT || WCMMode.fromRequest((ServletRequest)this.slingRequest) == WCMMode.DESIGN;
        if (editMode) {
            return value;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return GuideUtils.translateOrReturnOriginal(value, key, this.i18n, this.resourceProps);
    }

    @Deprecated
    public String externalize(String key) {
        String value = (String)this.resourceProps.get((Object)key);
        return this.externalize(value, key);
    }

    public String getError() {
        return this.error;
    }

    public String getBindRef() {
        return (String)this.resourceProps.get((Object)"bindRef");
    }

    private String getXDPJSON(String bindref) {
        boolean refersXSD;
        ResourceResolver resourceResolver = this.getResource().getResourceResolver();
        Resource guideContainerResource = resourceResolver.getResource(GuideUtils.getGuideContainerPath(this.slingRequest, this.getResource()));
        ValueMap map = ResourceUtil.getValueMap((Resource)guideContainerResource);
        boolean refersXDP = map.get((Object)"xdpRef") != null;
        boolean bl = refersXSD = map.get((Object)"xsdRef") != null;
        if (bindref == null) {
            return null;
        }
        if (refersXSD) {
            return "xsd";
        }
        if (!refersXDP) {
            return "";
        }
        Resource assetsResource = resourceResolver.getResource(guideContainerResource, "assets/xfaObjects");
        if (assetsResource != null) {
            ValueMap xfaObjects = ResourceUtil.getValueMap((Resource)assetsResource);
            return (String)xfaObjects.get((Object)bindref);
        }
        return null;
    }

    public boolean isValid() {
        String bindref = this.getBindRef();
        if (bindref != null) {
            String json = this.getXDPJSON(bindref);
            if ("xsd".equals(json)) {
                return true;
            }
            if (json == null) {
                I18n i18n = new I18n((HttpServletRequest)this.slingRequest);
                String e1 = i18n.get("NoSuchSOMExpression: bindRef (");
                String e2 = i18n.get(") provided doesn't point to an valid element in XDP.");
                this.error = e1 + bindref + e2;
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean isPropertySame(Object oldProp, Object newProp) throws JSONException {
        if (oldProp == null && newProp == null) {
            return true;
        }
        if (oldProp == null) {
            return false;
        }
        if (newProp == null) {
            return false;
        }
        if (oldProp instanceof JSONArray && newProp instanceof String[]) {
            JSONArray sop = (JSONArray)oldProp;
            String[] snp = (String[])newProp;
            if (sop.length() != snp.length) {
                return false;
            }
            boolean flag = true;
            for (int i = 0; i < sop.length(); ++i) {
                flag = flag && sop.get(i).equals(snp[i]);
            }
            return flag;
        }
        return oldProp.equals(newProp);
    }

    private ArrayList<String> getModifiedXfaProps(JSONObject oldXfaProps) {
        ArrayList<String> props = new ArrayList<String>();
        if (oldXfaProps != null) {
            String prop = null;
            try {
                Iterator propIterator = oldXfaProps.keys();
                while (propIterator.hasNext()) {
                    prop = (String)propIterator.next();
                    if (!this.isPropertySame(oldXfaProps.get(prop), this.resourceProps.get((Object)prop))) continue;
                    this.logger.info("AEMAF unmodified property in Guide " + prop);
                    props.add(prop);
                }
            }
            catch (JSONException e) {
                this.logger.error("AEMAF error in accessing old properties " + e.getMessage() + " old property " + prop, (Throwable)e);
            }
        } else {
            this.logger.error("AEMAF xfajson attribute not present in the node " + this.getResource().getPath());
        }
        return props;
    }

    private void syncProp(String prop, Object newJSONVal, ModifiableValueMap modifiableResourceProps) throws JSONException {
        Object[] newVal = newJSONVal;
        if (newJSONVal instanceof JSONArray) {
            JSONArray newJSONArr = (JSONArray)newJSONVal;
            Object[] list = new Object[newJSONArr.length()];
            for (int j = 0; j < newJSONArr.length(); ++j) {
                list[j] = newJSONArr.get(j);
            }
            newVal = list;
        }
        Object oldVal = this.resourceProps.get((Object)prop);
        if (newVal == null) {
            modifiableResourceProps.remove((Object)prop);
            if (this.logger.isDebugEnabled()) {
                this.logger.info("AEMAF Removed property [ " + prop + " : " + oldVal + " ]");
            }
        } else {
            modifiableResourceProps.put((Object)prop, (Object)newVal);
            if (this.logger.isDebugEnabled()) {
                this.logger.info("AEMAF Modified property [ " + prop + " : " + oldVal + " => " + newVal + " ]");
            }
        }
    }

    private void syncProps(JSONObject bindNode, ArrayList<String> unchangedProps, JSONObject oldProps) throws JSONException {
        Iterator newPropIterator = bindNode.keys();
        ModifiableValueMap modifiableResourceProps = (ModifiableValueMap)this.getResource().adaptTo(ModifiableValueMap.class);
        while (newPropIterator.hasNext()) {
            String prop = (String)newPropIterator.next();
            if (!unchangedProps.contains(prop) && (oldProps.has(prop) || this.resourceProps.containsKey((Object)prop))) continue;
            this.syncProp(prop, bindNode.get(prop), modifiableResourceProps);
            if (!unchangedProps.contains(prop)) continue;
            unchangedProps.remove(prop);
        }
        for (int i = 0; i < unchangedProps.size(); ++i) {
            String prop = unchangedProps.get(i);
            this.syncProp(prop, null, modifiableResourceProps);
        }
        try {
            modifiableResourceProps.put((Object)"xfajson", (Object)bindNode.toString());
            this.getResource().getResourceResolver().commit();
            this.resourceProps = (ValueMap)this.getResource().adaptTo(ValueMap.class);
        }
        catch (PersistenceException e) {
            this.logger.error("AEMAF Unable to commit changes for the node " + this.getResource().getPath(), (Throwable)e);
        }
    }

    public void syncNode() throws GuideException {
        String bindref = this.getBindRef();
        String jsonString = (String)this.resourceProps.get((Object)"xfajson");
        if (bindref != null && jsonString != null) {
            try {
                JSONObject oldXfaProps = new JSONObject(jsonString);
                ArrayList<String> unchangedProps = this.getModifiedXfaProps(oldXfaProps);
                if (!unchangedProps.isEmpty()) {
                    String json = this.getXDPJSON(bindref);
                    if (json != null) {
                        try {
                            JSONObject bindNode = new JSONObject(json);
                            this.syncProps(bindNode, unchangedProps, oldXfaProps);
                        }
                        catch (JSONException e) {
                            this.logger.error("AEMAF error in accessing new properties " + e.getMessage() + " properties " + json, (Throwable)e);
                        }
                    } else if (!"".equals(json)) {
                        this.logger.error("AEMAF unable to sync. Invalid SOM Reference in node " + bindref);
                    }
                }
            }
            catch (JSONException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.error("AEMAF error in accessing old properties " + e.getMessage() + " old properties " + jsonString, (Throwable)e);
                } else {
                    this.logger.error("AEMAF error in accessing old properties " + e.getMessage(), (Throwable)e);
                }
                throw new GuideException((Exception)((Object)e));
            }
        }
    }

    public boolean validate(ResourceResolver serviceResourceResolver) {
        return true;
    }

    public boolean isValidDorTemplateRef() {
        ResourceResolver resourceResolver = this.getResource().getResourceResolver();
        Resource guideContainerResource = resourceResolver.getResource(GuideUtils.getGuideContainerPath(this.slingRequest, this.getResource()));
        ValueMap map = ResourceUtil.getValueMap((Resource)guideContainerResource);
        String dorTemplateRef = null;
        dorTemplateRef = (String)map.get((Object)"dorTemplateRef");
        return dorTemplateRef != null && dorTemplateRef.length() > 0;
    }

    public String getClientLibRef() {
        return this.clientLibRef;
    }

    public void setClientLibRef(String clientLibRef) {
        this.clientLibRef = clientLibRef;
    }

    public String getEnabled() {
        return (String)this.resourceProps.get("enabled", String.class);
    }

    public String getVisible() {
        return (String)this.resourceProps.get("visible", String.class);
    }
}

