/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common.xfa;

import com.adobe.aemds.guide.common.xfa.XFAElement;
import com.adobe.aemds.guide.common.xfa.XFAJSONVisitor;
import com.adobe.aemds.guide.common.xfa.XFAScript;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.List;

public class XFAField
extends XFAElement {
    public XFAField(ObjectNode object) {
        super(object);
    }

    private ObjectNode getItems() {
        ObjectNode result = this.json.objectNode();
        if (this.json.has("children") && this.json.get("children").isArray()) {
            ObjectNode saveItems = null;
            ObjectNode displayItems = null;
            ArrayNode fieldChildren = (ArrayNode)this.json.get("children");
            for (int i = 0; i < fieldChildren.size(); ++i) {
                ObjectNode fieldChild = (ObjectNode)fieldChildren.get(i);
                if (!"items".equals(fieldChild.get("_class").asText())) continue;
                if (fieldChild.has("save") && "1".equals(fieldChild.get("save").asText())) {
                    saveItems = fieldChild;
                    continue;
                }
                displayItems = fieldChild;
            }
            if (saveItems == null && displayItems != null) {
                saveItems = displayItems;
            }
            if (saveItems != null) {
                result.set("saveItems", saveItems);
                if (displayItems == null) {
                    displayItems = saveItems;
                }
                result.set("displayItems", displayItems);
            }
        }
        return result;
    }

    @Override
    public void accept(XFAJSONVisitor visitor) throws Exception {
        visitor.visit(this);
    }

    public ObjectNode getEnums() throws Exception {
        ObjectNode items = this.getItems();
        ObjectNode result = this.json.objectNode();
        ArrayNode enums = this.json.arrayNode();
        ArrayNode enumNames = this.json.arrayNode();
        result.set("enum", (JsonNode)enums);
        result.set("enumNames", (JsonNode)enumNames);
        ObjectNode saveItems = (ObjectNode)items.get("saveItems");
        ObjectNode displayItems = (ObjectNode)items.get("displayItems");
        ArrayNode saveChildren = null;
        ArrayNode displayChildren = null;
        if (saveItems != null && saveItems.has("children")) {
            saveChildren = (ArrayNode)saveItems.get("children");
            displayChildren = displayItems.has("children") ? (ArrayNode)displayItems.get("children") : saveChildren;
        }
        if (saveChildren != null && saveChildren.size() > 0) {
            for (int i = 0; i < saveChildren.size(); ++i) {
                ObjectNode saveChild = (ObjectNode)saveChildren.get(i);
                ObjectNode displayChild = (ObjectNode)displayChildren.get(i);
                JsonNode saveValue = XFAElement.getOrElse((JsonNode)saveChild, "_value", (JsonNode)new TextNode(""), true);
                JsonNode saveValueType = XFAElement.getOrElse((JsonNode)saveChild, "_class", (JsonNode)new TextNode("text"), true);
                String type = saveValueType.asText();
                if (items.size() > 0) {
                    switch (type) {
                        case "integer": {
                            enums.add(saveValue.asInt());
                            break;
                        }
                        case "float": 
                        case "decimal": {
                            enums.add(saveValue.asDouble());
                            break;
                        }
                        case "boolean": {
                            type = "boolean";
                            enums.add(saveValue.asBoolean());
                            break;
                        }
                        default: {
                            type = "string";
                            enums.add(saveValue.asText());
                        }
                    }
                }
                String displayValue = XFAElement.getOrElse((JsonNode)displayChild, "_value", saveValue, true).asText();
                enumNames.add(displayValue);
            }
        }
        return result;
    }

    public boolean isFloatingField() {
        JsonNode node = this.json.get("id");
        if (node != null && !node.isNull()) {
            String text = node.asText("");
            return text.startsWith("floatingField");
        }
        return false;
    }

    @Override
    public List<XFAScript> getScripts() throws Exception {
        JsonNode calculateScript;
        List<XFAScript> scripts = super.getScripts();
        JsonNode validateScript = this.getOrElse("validate.script", null, false);
        if (validateScript != null) {
            scripts.add(this.scriptNode("validate", validateScript));
        }
        if ((calculateScript = this.getOrElse("calculate.script", null, false)) != null) {
            scripts.add(this.scriptNode("calculate", calculateScript));
        }
        return scripts;
    }
}

