/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.util;

import com.adobe.aemds.guide.utils.GuideWCMUtils;
import com.adobe.cq.forms.core.components.util.ComponentUtils;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.ComponentDataBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.style.ComponentStyleInfo;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import java.util.Calendar;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public abstract class AbstractComponentImpl
implements com.adobe.cq.wcm.core.components.models.Component {
    @Self(injectionStrategy=InjectionStrategy.OPTIONAL)
    protected SlingHttpServletRequest request;
    @SlingObject
    private Resource resource;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected Component component;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected ComponentContext componentContext;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private Page currentPage;
    private String id;
    protected I18n i18n = null;
    protected static final String REQ_ATTR_RESOURCE_CALLER_PATH = "resourceCallerPath";
    private Boolean dataLayerEnabled;
    private ComponentData componentData;

    protected Page getCurrentPage() {
        return this.currentPage;
    }

    protected void setCurrentPage(Page currentPage) {
        this.currentPage = currentPage;
    }

    @PostConstruct
    private void init() {
        String pagePath;
        PageManager pageManager;
        Page resourcePage;
        if (this.currentPage != null && this.resource != null && this.request.getAttribute("referencedPage") != null && !GuideWCMUtils.isForms(this.getCurrentPage().getPath()) && (resourcePage = (pageManager = this.currentPage.getPageManager()).getContainingPage(pagePath = (String)this.request.getAttribute("referencedPage"))) != null && !StringUtils.equals((CharSequence)this.currentPage.getPath(), (CharSequence)resourcePage.getPath())) {
            this.setCurrentPage(resourcePage);
        }
    }

    @NotNull
    public String getId() {
        if (this.id == null) {
            String resourceCallerPath = this.request != null ? (String)this.request.getAttribute(REQ_ATTR_RESOURCE_CALLER_PATH) : null;
            this.id = com.adobe.cq.wcm.core.components.util.ComponentUtils.getId((Resource)this.resource, (Page)this.currentPage, (String)resourceCallerPath, (ComponentContext)this.componentContext);
        }
        return this.id;
    }

    @NotNull
    public String getExportedType() {
        return this.resource.getResourceType();
    }

    @Nullable
    public ComponentData getData() {
        if (this.componentData == null) {
            if (this.dataLayerEnabled == null) {
                this.dataLayerEnabled = this.currentPage != null ? Boolean.valueOf(com.adobe.cq.wcm.core.components.util.ComponentUtils.isDataLayerEnabled((Resource)this.currentPage.getContentResource())) : Boolean.valueOf(com.adobe.cq.wcm.core.components.util.ComponentUtils.isDataLayerEnabled((Resource)this.resource));
            }
            if (this.dataLayerEnabled.booleanValue()) {
                this.componentData = this.getComponentData();
            }
        }
        return this.componentData;
    }

    @Nullable
    public String getAppliedCssClasses() {
        return Optional.ofNullable((ComponentStyleInfo)this.resource.adaptTo(ComponentStyleInfo.class)).map(ComponentStyleInfo::getAppliedCssClasses).filter(StringUtils::isNotBlank).orElse(null);
    }

    @NotNull
    protected ComponentData getComponentData() {
        return ((ComponentDataBuilder)((ComponentDataBuilder)((ComponentDataBuilder)DataLayerBuilder.forComponent().withId(this::getId)).withLastModifiedDate(() -> Optional.ofNullable((Calendar)this.resource.getValueMap().get("jcr:lastModified", Calendar.class)).map(Calendar::getTime).orElseGet(() -> Optional.ofNullable((Calendar)this.resource.getValueMap().get("jcr:created", Calendar.class)).map(Calendar::getTime).orElse(null)))).withType(() -> this.resource.getResourceType())).build();
    }

    @Nullable
    protected String translate(@NotNull String propertyName, @Nullable String propertyValue) {
        if (StringUtils.isBlank((CharSequence)propertyValue)) {
            return null;
        }
        return ComponentUtils.translate(propertyValue, propertyName, this.resource, this.i18n);
    }
}

