/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.util;

import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.cq.forms.core.components.models.form.BaseConstraint;
import com.adobe.cq.forms.core.components.util.CacheManager;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.http.util.EntityUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentUtils {
    private static final String EDGE_DELIVERY_FRAGMENT_CONTAINER_REL_PATH = "root/section/form";
    private static final String[] EDGE_DELIVERY_RESOURCE_TYPES = new String[]{"core/franklin/components/page/v1/page"};
    private static final Logger logger = LoggerFactory.getLogger(ComponentUtils.class);

    private ComponentUtils() {
    }

    @NotNull
    public static String getEncodedPath(@NotNull String path) {
        return new String(Base64.getEncoder().encode(path.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    @NotNull
    public static boolean isAFContainer(@NotNull Resource resource) {
        String fieldType = (String)resource.getValueMap().get("fieldType", String.class);
        return "form".equals(fieldType);
    }

    public static Resource getFormContainer(Resource resource) {
        if (resource == null) {
            return null;
        }
        if (ComponentUtils.isAFContainer(resource)) {
            return resource;
        }
        return ComponentUtils.getFormContainer(resource.getParent());
    }

    @NotNull
    public static String translate(@NotNull String propertyValue, @NotNull String propertyName, @NotNull Resource resource, @Nullable I18n i18n) {
        return ComponentUtils.translate(propertyValue, propertyName, resource.getValueMap(), i18n);
    }

    @NotNull
    public static String translate(@NotNull String propertyValue, @NotNull String propertyName, @NotNull ValueMap valueMap, @Nullable I18n i18n) {
        String translatedValue = propertyValue;
        if (i18n != null) {
            translatedValue = GuideUtils.translateOrReturnOriginal(propertyValue, propertyName, i18n, valueMap);
        }
        return translatedValue;
    }

    public static Date clone(@Nullable Date date) {
        return Optional.ofNullable(date).map(Date::getTime).map(Date::new).orElse(null);
    }

    public static <T> T getExclusiveValue(Object exclusiveValue, T value, Object exclusiveValueCheck) {
        if (exclusiveValue instanceof Boolean && (Boolean.TRUE.equals(exclusiveValue) || Boolean.TRUE.equals(exclusiveValueCheck)) && value != null) {
            return value;
        }
        if (exclusiveValue instanceof Long) {
            return (T)exclusiveValue;
        }
        if (exclusiveValue instanceof String) {
            if (((String)exclusiveValue).equalsIgnoreCase("true") && value != null) {
                return value;
            }
            return null;
        }
        if (Boolean.TRUE.equals(exclusiveValueCheck) && value != null) {
            return value;
        }
        return null;
    }

    public static Number parseNumber(@Nullable String value) {
        try {
            return value != null ? Long.valueOf(Long.parseLong(value)) : null;
        }
        catch (NumberFormatException e) {
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }

    @NotNull
    public static Object[] coerce(@NotNull BaseConstraint.Type type, @NotNull Object[] objArr) {
        block7: {
            block6: {
                block5: {
                    block4: {
                        if (type.equals((Object)BaseConstraint.Type.NUMBER)) break block4;
                        if (!type.equals((Object)BaseConstraint.Type.NUMBER_ARRAY)) break block5;
                    }
                    return Arrays.stream(objArr).filter(Objects::nonNull).map(Object::toString).map(Long::parseLong).toArray(Long[]::new);
                }
                if (type.equals((Object)BaseConstraint.Type.BOOLEAN)) break block6;
                if (!type.equals((Object)BaseConstraint.Type.BOOLEAN_ARRAY)) break block7;
            }
            return Arrays.stream(objArr).filter(Objects::nonNull).map(Object::toString).map(Boolean::parseBoolean).toArray(Boolean[]::new);
        }
        return ArrayUtils.clone((Object[])objArr);
    }

    public static ContentPolicy getPolicy(String contentPath, ResourceResolver resourceResolver) {
        ContentPolicy policy = null;
        Resource contentResource = resourceResolver.getResource(contentPath);
        ContentPolicyManager policyManager = (ContentPolicyManager)resourceResolver.adaptTo(ContentPolicyManager.class);
        if (contentResource != null && policyManager != null) {
            policy = policyManager.getPolicy(contentResource);
        }
        return policy;
    }

    public static Resource getFragmentContainer(ResourceResolver resourceResolver, @NotNull String fragmentPath) {
        Resource pageContentResource;
        String fragmentRef = fragmentPath;
        if (StringUtils.contains((CharSequence)fragmentPath, (CharSequence)"/content/dam/formsanddocuments")) {
            fragmentRef = GuideUtils.convertFMAssetPathToFormPagePath(fragmentPath);
        }
        if ((pageContentResource = resourceResolver.getResource(fragmentRef + "/" + "jcr:content")) != null) {
            if (Arrays.stream(EDGE_DELIVERY_RESOURCE_TYPES).anyMatch(arg_0 -> ((Resource)pageContentResource).isResourceType(arg_0))) {
                return pageContentResource.getChild(EDGE_DELIVERY_FRAGMENT_CONTAINER_REL_PATH);
            }
            return pageContentResource.getChild("guideContainer");
        }
        return null;
    }

    public static boolean isFragmentComponent(Resource resource) {
        return resource != null && resource.getValueMap().get("fragmentPath", String.class) != null;
    }

    public static boolean shouldIncludeSubmitProperties(SlingHttpServletRequest request) {
        if (request == null) {
            return false;
        }
        String submissionHeaderName = "submission";
        return submissionHeaderName.equals(request.getAttribute("x-adobe-form-definition")) || submissionHeaderName.equals(request.getHeader("x-adobe-form-definition"));
    }

    public static List<String> getSupportedSubmitActions(HttpClientBuilderFactory clientBuilderFactory) {
        List<String> cachedActions = CacheManager.getFromCache("supportedsubmit_actions");
        if (cachedActions != null) {
            return cachedActions;
        }
        String supportedSubmitActionsUrl = "https://forms.adobe.com/adobe/forms/af/submit";
        ArrayList<String> supportedSubmitActions = new ArrayList<String>();
        if (clientBuilderFactory == null) {
            logger.error("clientBuilderFactory is null");
            return supportedSubmitActions;
        }
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(5000).setConnectionRequestTimeout(5000).build();
            CloseableHttpClient httpClient = clientBuilderFactory.newBuilder().setDefaultRequestConfig(requestConfig).build();
            HttpGet httpGet = new HttpGet(supportedSubmitActionsUrl);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                if (ComponentUtils.isSuccessfulResponse(response)) {
                    String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                    JsonNode rootNode = new ObjectMapper().readTree(responseBody);
                    ArrayNode submissionsNode = (ArrayNode)rootNode.get("supported");
                    if (submissionsNode != null && submissionsNode.isArray()) {
                        submissionsNode.forEach(submission -> {
                            String submissionText = submission.asText();
                            supportedSubmitActions.add(submissionText);
                        });
                    } else {
                        logger.error("supported node was null or not an array");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while fetching supported submit actions", (Throwable)e);
        }
        CacheManager.putInCache("supportedsubmit_actions", supportedSubmitActions);
        return supportedSubmitActions;
    }

    private static boolean isSuccessfulResponse(CloseableHttpResponse response) {
        return response.getStatusLine() != null && response.getStatusLine().getStatusCode() == 200;
    }
}

