/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.signatures.pki.client.types.prefs;

import com.adobe.fd.signatures.pki.client.types.common.HashAlgorithm;
import com.adobe.fd.signatures.pki.client.types.common.RevocationCheckStyle;
import com.adobe.fd.signatures.pki.client.types.prefs.CommonPreferencesImpl;
import com.adobe.fd.signatures.pki.client.types.prefs.PreferencesMap;
import com.adobe.fd.signatures.pki.client.types.prefs.TSPPreferences;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;

public class TSPPreferencesImpl
extends CommonPreferencesImpl
implements TSPPreferences {
    private static final long serialVersionUID = -1825117560859208430L;
    private static final String tspServerURLStr = "tspServerURL";
    private static final String sendNonceStr = "sendNonce";
    private static final Boolean sendNonce_Default = new Boolean(true);
    private static final String tspHashAlgo = "hashAlgo";
    private static final HashAlgorithm tspHashAlgo_Default = HashAlgorithm.SHA256;
    private static final String tspSize = "size";
    public static final Integer MIN_TSP_SIZE = new Integer(64);
    public static final Integer MAX_TSP_SIZE = new Integer(10240);
    public static final Integer DEFAULT_TSP_SIZE = new Integer(4096);
    private static final String tspServerUsername = "serverUsername";
    private static final String tspServerPassword = "serverPassword";
    private static final String useExpriedTimestampsStr = "useExpiredTimestamps";
    private static final Boolean useExpriedTimestamps_Default = new Boolean(true);

    @Override
    protected Object getPrefValueFromString(String prefName, String value) {
        if (prefName.equalsIgnoreCase(tspServerURLStr)) {
            return value.trim().length() != 0 ? value : null;
        }
        if (prefName.equalsIgnoreCase(sendNonceStr) || prefName.equalsIgnoreCase(useExpriedTimestampsStr)) {
            return Boolean.valueOf(value);
        }
        if (prefName.equalsIgnoreCase(tspServerUsername) || prefName.equalsIgnoreCase(tspServerPassword)) {
            return value.trim().length() != 0 ? value : null;
        }
        if (prefName.equalsIgnoreCase(tspHashAlgo)) {
            return HashAlgorithm.getValueFromString(value.trim());
        }
        if (prefName.equalsIgnoreCase(tspSize)) {
            return this.checkTSPSize(new Integer(value));
        }
        return super.getPrefValueFromString(prefName, value);
    }

    private Integer checkTSPSize(Integer size) {
        if (size.compareTo(MIN_TSP_SIZE) < 0 || size.compareTo(MAX_TSP_SIZE) > 0) {
            size = DEFAULT_TSP_SIZE;
        }
        return size;
    }

    public TSPPreferencesImpl() {
        super(RevocationCheckStyle.BestEffort);
        this.put(sendNonceStr, (Object)sendNonce_Default);
        this.put(tspHashAlgo, (Object)tspHashAlgo_Default);
        this.put(tspSize, (Object)DEFAULT_TSP_SIZE);
        this.put(useExpriedTimestampsStr, (Object)useExpriedTimestamps_Default);
    }

    public TSPPreferencesImpl(TSPPreferences tspPrefs) {
        this();
        this.put(sendNonceStr, (Object)tspPrefs.getSendNonce());
        this.put(tspHashAlgo, (Object)tspPrefs.getTSPHashAlgorithm());
        this.put(tspSize, (Object)tspPrefs.getSize());
        this.put(useExpriedTimestampsStr, (Object)tspPrefs.isUseExpiredTimestamps());
        this.put(tspServerURLStr, (Object)tspPrefs.getTspServerURL());
        this.put(tspServerUsername, (Object)tspPrefs.getUsername());
        this.put(tspServerPassword, (Object)tspPrefs.getPassword());
    }

    @Override
    @JsonGetter(value="tspServerURL")
    public String getTspServerURL() {
        return (String)this.get(tspServerURLStr);
    }

    @JsonSetter(value="tspServerURL")
    public void setTspServerURL(String tspServerURL) {
        this.put(tspServerURLStr, (Object)tspServerURL);
    }

    @Override
    @JsonGetter(value="sendNonce")
    public boolean getSendNonce() {
        return (Boolean)this.get(sendNonceStr);
    }

    @JsonSetter(value="sendNonce")
    public void setSendNonce(boolean sendNonce) {
        this.put(sendNonceStr, (Object)sendNonce);
    }

    @Override
    @JsonGetter(value="hashAlgo")
    public HashAlgorithm getTSPHashAlgorithm() {
        return (HashAlgorithm)((Object)this.get(tspHashAlgo));
    }

    @JsonSetter(value="hashAlgo")
    public void setTSPHashAlgorithm(HashAlgorithm hashAlgo) {
        this.put(tspHashAlgo, (Object)hashAlgo);
    }

    @Override
    @JsonGetter(value="serverUsername")
    public String getUsername() {
        return (String)this.get(tspServerUsername);
    }

    @Override
    @JsonGetter(value="serverPassword")
    public char[] getPassword() {
        if (this.get(tspServerPassword) instanceof String) {
            return ((String)this.get(tspServerPassword)).toCharArray();
        }
        return (char[])this.get(tspServerPassword);
    }

    @JsonSetter(value="serverUsername")
    public void setUsername(String userName) {
        this.put(tspServerUsername, (Object)userName);
    }

    @JsonSetter(value="serverPassword")
    public void setPassword(char[] password) {
        this.put(tspServerPassword, password != null ? (Object)String.copyValueOf(password) : password);
    }

    @Override
    @JsonGetter(value="size")
    public Integer getSize() {
        return (Integer)this.get(tspSize);
    }

    @JsonSetter(value="size")
    public void setSize(int size) {
        this.put(tspSize, (Object)this.checkTSPSize(size));
    }

    @Override
    @JsonGetter(value="useExpiredTimestamps")
    public boolean isUseExpiredTimestamps() {
        return (Boolean)this.get(useExpriedTimestampsStr);
    }

    @JsonSetter(value="useExpiredTimestamps")
    public void setUseExpiredTimestamps(boolean useExpiredTimestamps) {
        this.put(useExpriedTimestampsStr, (Object)useExpiredTimestamps);
    }

    @Override
    public PreferencesMap newInstance() {
        return new TSPPreferencesImpl();
    }

    @Override
    protected PreferencesMap createChild(String myKey) {
        return null;
    }
}

