/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.model;

import com.adobe.aem.dermis.api.util.Assert;
import com.adobe.aem.dermis.exception.DermisException;
import com.adobe.aem.dermis.model.CombinedSchemaType;
import com.adobe.aem.dermis.model.IAsset;
import com.adobe.aem.dermis.model.ICombinedSchema;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class CombinedSchema
implements ICombinedSchema,
Serializable {
    @JsonProperty(value="oneOf")
    List<IAsset> oneOf;
    @JsonProperty(value="anyOf")
    List<IAsset> anyOf;
    @JsonProperty(value="allOf")
    List<IAsset> allOf;
    @JsonIgnore
    private CombinedSchemaType type;

    public CombinedSchema(CombinedSchemaType type) throws DermisException {
        Assert.assertNotNull((Object)((Object)type), (String)"Type of combined schema should be set");
        this.type = type;
        switch (type) {
            case AllOf: {
                this.allOf = new ArrayList<IAsset>();
                break;
            }
            case AnyOf: {
                this.anyOf = new ArrayList<IAsset>();
                break;
            }
            case OneOf: {
                this.oneOf = new ArrayList<IAsset>();
            }
        }
    }

    @Override
    public CombinedSchemaType getType() {
        return this.type;
    }

    @Override
    public void addSchema(IAsset schema) throws DermisException {
        Assert.assertNotNull((Object)schema, (String)"Provided schema should not be null");
        List<IAsset> schemaList = this.getSchemas();
        Assert.assertNotNull(schemaList, (String)"Schema list should not be null");
        schemaList.add(schema);
    }

    @Override
    @JsonIgnore
    public List<IAsset> getSchemas() {
        List<IAsset> schemaList = null;
        switch (this.type) {
            case AllOf: {
                schemaList = this.allOf;
                break;
            }
            case AnyOf: {
                schemaList = this.anyOf;
                break;
            }
            case OneOf: {
                schemaList = this.oneOf;
            }
        }
        return schemaList;
    }
}

