/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common.xfa;

import com.adobe.aemds.guide.common.xfa.XFAElementFactory;
import com.adobe.aemds.guide.common.xfa.XFAInstanceManager;
import com.adobe.aemds.guide.common.xfa.XFAJSONVisitor;
import com.adobe.aemds.guide.common.xfa.XFAScript;
import com.adobe.aemds.guide.common.xfa.XFASubform;
import com.adobe.xfa.ut.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XFAElement {
    public static final Hashtable<String, List<String>> oneOfChild = new Hashtable();
    private Logger logger = LoggerFactory.getLogger(XFAElement.class);
    protected ObjectNode json;
    private String generatedName;
    private List<XFAElement> children;
    private String fieldId;

    public XFAElement(ObjectNode object) {
        this.json = object;
        this.generatedName = "";
    }

    public ObjectNode getJson() {
        return this.json;
    }

    public void accept(XFAJSONVisitor visitor) throws Exception {
    }

    protected static final JsonNode getOneOfChild(JsonNode jsonObject, List<String> oneOfChildList) throws Exception {
        if (jsonObject != null && jsonObject.has("children") && jsonObject.get("children") instanceof ArrayNode) {
            ArrayNode objectChildren = (ArrayNode)jsonObject.get("children");
            for (int i = 0; i < objectChildren.size(); ++i) {
                ObjectNode child = (ObjectNode)objectChildren.get(i);
                String childType = child.get("_class").asText();
                if (!oneOfChildList.contains(childType)) continue;
                return child;
            }
        }
        return null;
    }

    public static final JsonNode getOrElse(JsonNode jsonObject, String jsonXpath, JsonNode defaultValue, boolean isAttr) throws Exception {
        JsonNode currObject = jsonObject;
        String[] propChain = jsonXpath.split("\\.");
        JsonNode value = null;
        block0: for (int i = 0; i < propChain.length; ++i) {
            String property = propChain[i];
            String attrName = "";
            String attrValue = "";
            int attrIndex = property.indexOf("(");
            if (attrIndex != -1) {
                String attrString;
                property = propChain[i].substring(0, attrIndex);
                attrName = attrString = propChain[i].substring(attrIndex + 1, propChain[i].length() - 1);
                int ind = attrString.indexOf("=");
                if (ind != -1) {
                    attrName = attrString.substring(0, ind);
                    attrValue = attrString.substring(ind + 1);
                }
            }
            boolean isLastProp = i == propChain.length - 1;
            JsonNode tmpCurrentObject = currObject;
            currObject = null;
            value = null;
            if (tmpCurrentObject != null) {
                if ("oneOfChild".equals(property)) {
                    currObject = XFAElement.getOneOfChild(tmpCurrentObject, oneOfChild.get(tmpCurrentObject.get("_class").asText()));
                    continue;
                }
                if (isLastProp && tmpCurrentObject.has(property)) {
                    value = tmpCurrentObject.get(property);
                    continue;
                }
                if ((isLastProp && isAttr || !tmpCurrentObject.has("children") || !(tmpCurrentObject.get("children") instanceof ArrayNode)) && (!tmpCurrentObject.has("items") || !(tmpCurrentObject.get("items") instanceof ArrayNode))) continue;
                ArrayNode array = (ArrayNode)tmpCurrentObject.get("children");
                HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
                for (int j = 0; j < array.size(); ++j) {
                    boolean flag;
                    ObjectNode arrayItem = (ObjectNode)array.get(j);
                    if (arrayItem.has("_class")) {
                        String cls = arrayItem.get("_class").asText();
                        if (indexMap.containsKey(cls)) {
                            indexMap.put(cls, (Integer)indexMap.get(cls) + 1);
                        } else {
                            indexMap.put(cls, 0);
                        }
                    }
                    if (!property.equals(arrayItem.get("_class").asText()) && (!arrayItem.has("guideNodeClass") || !property.equals(arrayItem.get("guideNodeClass").asText()))) continue;
                    boolean bl = flag = attrIndex == -1;
                    if (!flag) {
                        String arrayItemAttrValue;
                        String string = arrayItemAttrValue = arrayItem.has(attrName) ? arrayItem.get(attrName).asText() : null;
                        if (attrValue.equals(arrayItemAttrValue)) {
                            flag = true;
                        } else if ("index".equals(attrName)) {
                            String cls = arrayItem.get("_class").asText();
                            boolean bl2 = flag = (Integer)indexMap.get(cls) == j;
                        }
                    }
                    if (!flag) continue;
                    currObject = arrayItem;
                    continue block0;
                }
                continue;
            }
            return defaultValue;
        }
        if (currObject != null) {
            return currObject;
        }
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public final JsonNode getOrElse(String jsonXpath, JsonNode defaultValue, boolean isAttr) throws Exception {
        return XFAElement.getOrElse((JsonNode)this.json, jsonXpath, defaultValue, isAttr);
    }

    public final JsonNode getOrElse(String jsonXpath, boolean isAttr) throws Exception {
        return XFAElement.getOrElse((JsonNode)this.json, jsonXpath, null, isAttr);
    }

    public final JsonNode getOrElse(String jsonXpath, JsonNode defaultValue) throws Exception {
        return XFAElement.getOrElse((JsonNode)this.json, jsonXpath, defaultValue, false);
    }

    public final JsonNode getOrElse(String jsonXpath) throws Exception {
        return XFAElement.getOrElse((JsonNode)this.json, jsonXpath, null, false);
    }

    public final String getName() {
        try {
            TextNode textNode = new TextNode(this.generatedName);
            return this.getOrElse("name", (JsonNode)textNode, true).asText();
        }
        catch (Exception e) {
            return "";
        }
    }

    public final String getSomExpression() {
        try {
            return this.getOrElse("extras.extras(name=FS_EXTRAS).text(name=FS_SOM)._value", (JsonNode)new TextNode(""), true).asText();
        }
        catch (Exception e) {
            this.logger.error("unable to find Som Expression for the element {}", (Object)this.pretty());
            return "";
        }
    }

    public final void setName(String generatedName) {
        if (StringUtils.isEmpty((CharSequence)this.getName())) {
            this.generatedName = generatedName;
        }
    }

    public final String getClassName() {
        if (this.json.has("_class")) {
            try {
                return this.json.get("_class").asText();
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public boolean isTitleRichText() throws Exception {
        JsonNode res = this.getOrElse("caption.value.oneOfChild", null, false);
        if (res == null) {
            return false;
        }
        return "exData".equals(res.get("_class").asText());
    }

    public String getTitle() throws Exception {
        String name;
        String title = "";
        if ("field".equals(this.getClassName())) {
            JsonNode res = this.getOrElse("caption.value.oneOfChild", null, false);
            boolean isTitleRichText = false;
            if (res != null) {
                isTitleRichText = "exData".equals(res.get("_class").asText());
                if (res.has("_value")) {
                    title = res.get("_value").asText();
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)title) && !StringUtils.isEmpty((CharSequence)(name = this.getName()))) {
            title = XFAElement.humanize(name);
        }
        return title;
    }

    private static String humanize(String name) {
        if (name == null) {
            return null;
        }
        String humanizedName = name.replaceAll("_", " ");
        humanizedName = humanizedName.replaceAll("([A-Z][a-z]+)", " $1").replaceAll("([A-Z][A-Z]+)", " $1").replaceAll("([^A-Za-z ]+)", " $1").trim();
        humanizedName = WordUtils.capitalize((String)humanizedName);
        return humanizedName;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public List<XFAElement> getChildren() throws Exception {
        if (this.children == null) {
            this.children = new ArrayList<XFAElement>();
            XFAInstanceManager instanceManager = null;
            if (this.json.has("children") && this.json.get("children").isArray()) {
                ArrayNode containerChildren = (ArrayNode)this.json.get("children");
                for (int i = 0; i < containerChildren.size(); ++i) {
                    ObjectNode childJson = (ObjectNode)containerChildren.get(i);
                    XFAElement element = XFAElementFactory.getXFAElement(childJson);
                    if (element instanceof XFAInstanceManager) {
                        instanceManager = (XFAInstanceManager)element;
                    } else if (element instanceof XFASubform && instanceManager != null) {
                        ((XFASubform)element).setInstanceManager(instanceManager);
                    }
                    this.children.add(element);
                }
            }
        }
        return this.children;
    }

    public static String getOrElse(JsonNode jsonObject, String propertyName, String defaultValue) {
        if (jsonObject.has(propertyName)) {
            return jsonObject.get(propertyName).asText();
        }
        return defaultValue;
    }

    protected XFAScript scriptNode(String activity, JsonNode scriptNode) {
        String value = XFAElement.getOrElse(scriptNode, "_value", "");
        String runAt = XFAElement.getOrElse(scriptNode, "runAt", "");
        String contentType = XFAElement.getOrElse(scriptNode, "contentType", "");
        return new XFAScript(activity, value, runAt, contentType);
    }

    public List<XFAScript> getScripts() throws Exception {
        List<XFAElement> children = this.getChildren();
        return children.stream().filter(child -> child.getClassName().equals("event")).map(child -> {
            try {
                String activity = child.getOrElse("activity", true).asText();
                return this.scriptNode(activity, child.getOrElse("script"));
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String pretty() {
        return this.json.toString();
    }

    static {
        oneOfChild.put("ui", Arrays.asList("barcode", "button", "checkButton", "choiceList", "dateTimeEdit", "defaultUi", "exObject", "imageEdit", "numericEdit", "passwordEdit", "signature", "textEdit"));
        oneOfChild.put("value", Arrays.asList("arc", "boolean", "date", "dateTime", "decimal", "exData", "float", "image", "integer", "line", "rectangle", "text", "time"));
    }
}

