/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common.xfa;

import com.adobe.aemds.guide.common.xfa.XFADraw;
import com.adobe.aemds.guide.common.xfa.XFAElement;
import com.adobe.aemds.guide.common.xfa.XFAInstanceManager;
import com.adobe.aemds.guide.common.xfa.XFAJSONVisitor;
import com.adobe.aemds.guide.service.GuideException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XFASubform
extends XFAElement {
    private Logger logger = LoggerFactory.getLogger(XFASubform.class);
    private XFAInstanceManager instanceManager;

    public XFASubform(ObjectNode object) {
        super(object);
    }

    protected void visitChildren(XFAJSONVisitor visitor) throws Exception {
        try {
            List<XFAElement> elements = this.getChildren();
            for (XFAElement element : elements) {
                try {
                    element.accept(visitor);
                }
                catch (Exception e) {
                    this.logger.error("Error in transforming child {}. Converting it into a dummy draw now", (Object)element.getSomExpression(), (Object)e);
                    String name = element.getName() + "_" + element.getClassName() + "_invalid";
                    XFADraw.createDrawElement(element.getSomExpression(), name).accept(visitor);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error in transforming subform {}", (Object)this.pretty());
            throw new GuideException(e);
        }
    }

    public void setInstanceManager(XFAInstanceManager instanceManager) {
        if (this.instanceManager == null) {
            this.instanceManager = instanceManager;
            this.instanceManager.addInstance(this);
        }
    }

    public XFAInstanceManager getInstanceManager() {
        return this.instanceManager;
    }

    public int getInstanceIndex() {
        return this.instanceManager.getInstances().indexOf(this);
    }

    @Override
    public void accept(XFAJSONVisitor visitor) throws Exception {
        boolean visited = visitor.visitStart(this);
        if (!visited) {
            this.visitChildren(visitor);
            visitor.visitEnd(this);
        }
    }
}

