/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common.xfa;

import com.adobe.aemds.guide.common.xfa.XFADraw;
import com.adobe.aemds.guide.common.xfa.XFAElement;
import com.adobe.aemds.guide.common.xfa.XFAField;
import com.adobe.aemds.guide.common.xfa.XFAJSONVisitor;
import com.adobe.aemds.guide.common.xfa.XFASubform;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XFATable
extends XFASubform {
    private Logger logger = LoggerFactory.getLogger(XFATable.class);

    public XFATable(ObjectNode object) {
        super(object);
    }

    @Override
    public void accept(XFAJSONVisitor visitor) throws Exception {
        boolean visited = visitor.visitStart(this);
        if (!visited) {
            this.visitChildren(visitor);
            visitor.visitEnd(this);
        }
    }

    public List<List<XFAElement>> getRows() throws Exception {
        ArrayList<List<XFAElement>> result = new ArrayList<List<XFAElement>>();
        List<XFAElement> children = this.getChildren();
        for (XFAElement child : children) {
            if (!(child instanceof XFASubform)) continue;
            ArrayList<XFAElement> row = new ArrayList<XFAElement>();
            row.add(child);
            List<XFAElement> subformChildren = ((XFASubform)child).getChildren();
            for (XFAElement subformChild : subformChildren) {
                if (!(subformChild instanceof XFAField) && !(subformChild instanceof XFADraw)) continue;
                row.add(subformChild);
            }
            result.add(row);
        }
        return result;
    }

    public List<String> getHeaders() throws Exception {
        List<List<XFAElement>> rows = this.getRows();
        List<XFAElement> header = rows.get(0);
        return header.stream().skip(1L).map(element -> {
            String value = null;
            try {
                if (element instanceof XFADraw) {
                    value = ((XFADraw)element).getValue();
                } else if (element instanceof XFAElement) {
                    value = element.getTitle();
                } else {
                    this.logger.warn("table header contains a unknown element. Unsupported use case");
                }
            }
            catch (Exception e) {
                this.logger.error("Error in transforming table header", (Throwable)e);
            }
            if (value == null) {
                return "";
            }
            return value;
        }).collect(Collectors.toList());
    }
}

