/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.model;

import com.adobe.aemds.guide.model.ReCaptchaConfiguration;
import com.adobe.aemds.guide.service.AdaptiveFormConfigurationService;
import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
public class ReCaptchaConfigurationModel
implements ReCaptchaConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ReCaptchaConfigurationModel.class);
    @OSGiService
    private CryptoSupport cryptoSupport;
    @OSGiService
    private AdaptiveFormConfigurationService afConfigurationService;
    @Inject
    private String siteKey;
    @Inject
    private String secretKey;
    @Inject
    private String name;
    @Inject
    @Optional
    @Named(value="jcr:title")
    private String title;
    @Inject
    @Optional
    private String description;
    @Inject
    @Optional
    private String thumbnailPath;
    @Inject
    @Optional
    private String version;
    @Inject
    @Optional
    private String keyType;
    @Inject
    @Optional
    private String projectId;
    @Inject
    @Optional
    private double threshold;
    @Inject
    @Optional
    private String enterpriseVerifyUrl;

    @Override
    public String siteKey() {
        return this.siteKey;
    }

    @Override
    public String secretKey() {
        String unprotectedSecretKey = null;
        try {
            unprotectedSecretKey = this.cryptoSupport.unprotect(this.secretKey);
        }
        catch (CryptoException cryptoException) {
            logger.error("Error while decrypting the Secret Key:" + cryptoException.getMessage(), (Throwable)cryptoException);
        }
        return unprotectedSecretKey;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String thumbnailPath() {
        return this.thumbnailPath;
    }

    @Override
    public String domain() {
        String recaptchaDomain = this.afConfigurationService.recaptchaDomain();
        return recaptchaDomain;
    }

    @Override
    public String version() {
        return StringUtils.isEmpty((CharSequence)this.version) ? "v2" : this.version;
    }

    @Override
    public String keyType() {
        return StringUtils.isEmpty((CharSequence)this.keyType) ? "checkbox" : this.keyType;
    }

    @Override
    public String projectId() {
        return this.projectId;
    }

    @Override
    public double threshold() {
        return this.threshold;
    }

    @Override
    public String enterpriseVerifyUrl() {
        return this.enterpriseVerifyUrl;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return null;
    }
}

