/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemfd.dermis.authentication.model;

import com.adobe.aemfd.dermis.authentication.api.IAuthenticationConfig;
import com.adobe.aemfd.dermis.authentication.api.IConfiguration;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class Configuration
implements IConfiguration {
    private static Logger logger = LoggerFactory.getLogger(Configuration.class);
    private Resource resource;
    @Inject
    @Named(value="jcr:title")
    private String title;
    @Inject
    private String url;
    @Inject
    private String thumbnailPath;
    @Inject
    private String dataSourceType;
    @Inject
    @Optional
    private String authenticationType;
    private String id;
    private String name;
    private String path;
    private IAuthenticationConfig authentication;
    @Inject
    private String serviceEndPoint;

    public Configuration(Resource resource) {
        if (resource != null) {
            this.resource = resource;
            this.path = resource.getPath();
            Resource parent = resource.getParent();
            if (parent != null) {
                this.id = parent.getPath();
                this.name = parent.getName();
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getUrl() {
        if (this.url != null) {
            return this.url.trim();
        }
        return null;
    }

    @Override
    public String getDataSourceType() {
        return this.dataSourceType;
    }

    public void setDataSourceType(String dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    @Override
    public String getAuthenticationType() {
        return this.authenticationType;
    }

    @Override
    public IAuthenticationConfig getAuthentication() {
        return this.authentication;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public void setAuthentication(IAuthenticationConfig authentication) {
        this.authentication = authentication;
    }

    @Override
    public String getThumbnailPath() {
        return this.thumbnailPath;
    }

    public void setThumbnailPath(String thumbnailPath) {
        this.thumbnailPath = thumbnailPath;
    }

    @PostConstruct
    public void removeResource() {
        if (this.resource != null) {
            this.authentication = (IAuthenticationConfig)this.resource.adaptTo(IAuthenticationConfig.class);
            this.resource = null;
        }
    }

    public String getServiceEndPoint() {
        return this.serviceEndPoint;
    }

    public void setServiceEndPoint(String serviceEndPoint) {
        this.serviceEndPoint = serviceEndPoint;
    }
}

