/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.models.form;

import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface AutoSaveConfiguration {
    default public boolean isEnableAutoSave() {
        return false;
    }

    default public AutoSaveStrategyType getAutoSaveStrategyType() {
        return AutoSaveStrategyType.TIME;
    }

    default public Integer getAutoSaveInterval() {
        return 0;
    }

    public static enum AutoSaveStrategyType {
        TIME("time");

        private String strategyType;

        private AutoSaveStrategyType(String strategyType) {
            this.strategyType = strategyType;
        }

        public String getStrategyType() {
            return this.strategyType;
        }

        public static AutoSaveStrategyType fromString(String strategyType) {
            for (AutoSaveStrategyType type : AutoSaveStrategyType.values()) {
                if (!StringUtils.equals((CharSequence)strategyType, (CharSequence)type.strategyType)) continue;
                return type;
            }
            return null;
        }

        @JsonValue
        public String toString() {
            return this.getStrategyType();
        }
    }
}

