/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.util;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class CacheManager {
    private static final Map<String, List<String>> SUBMIT_ACTIONS_CACHE = new ConcurrentHashMap<String, List<String>>();
    private static final Map<String, Long> CACHE_TIMESTAMPS = new ConcurrentHashMap<String, Long>();
    private static final long CACHE_TTL = TimeUnit.HOURS.toMillis(24L);
    public static final String SUPPORTED_SUBMIT_ACTIONS_CACHE_KEY = "supportedsubmit_actions";

    public static List<String> getFromCache(String cacheKey) {
        Long timestamp = CACHE_TIMESTAMPS.get(cacheKey);
        if (timestamp == null) {
            return null;
        }
        if (System.currentTimeMillis() - timestamp > CACHE_TTL) {
            SUBMIT_ACTIONS_CACHE.remove(cacheKey);
            CACHE_TIMESTAMPS.remove(cacheKey);
            return null;
        }
        return SUBMIT_ACTIONS_CACHE.get(cacheKey);
    }

    public static void putInCache(String cacheKey, List<String> value) {
        SUBMIT_ACTIONS_CACHE.put(cacheKey, value);
        CACHE_TIMESTAMPS.put(cacheKey, System.currentTimeMillis());
    }
}

