/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DefaultValueSerializer
extends StdSerializer<Object[]> {
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

    public DefaultValueSerializer() {
        this(null);
    }

    public DefaultValueSerializer(Class<Object[]> t) {
        super(t);
    }

    private void serialize(Object value, JsonGenerator gen) throws IOException {
        if (value instanceof Boolean) {
            gen.writeBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Long) {
            gen.writeNumber(((Long)value).longValue());
        } else if (value instanceof Double) {
            gen.writeNumber(((Double)value).doubleValue());
        } else if (value instanceof Integer) {
            gen.writeNumber(((Integer)value).intValue());
        } else if (value instanceof String) {
            gen.writeString((String)value);
        } else if (value instanceof Date) {
            gen.writeString(this.formatter.format(value));
        } else if (value instanceof Calendar) {
            gen.writeString(this.formatter.format(((Calendar)value).getTime()));
        }
    }

    public void serialize(Object[] value, JsonGenerator gen, SerializerProvider arg2) throws IOException, JsonProcessingException {
        if (value.length == 1) {
            this.serialize(value[0], gen);
        } else {
            gen.writeStartArray();
            for (Object objValue : value) {
                this.serialize(objValue, gen);
            }
            gen.writeEndArray();
        }
    }
}

