/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aem.forms.core.components.common.FormGenerator;
import com.adobe.aemds.guide.fdfl.utils.AdaptiveFormUtil;
import com.adobe.aemds.guide.schema.FormDataSchema;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FormGenerator.class}, immediate=true)
public class CoreComponentFormGenerator
implements FormGenerator {
    @Reference
    protected ResourceResolverFactory resourceResolverHelper;
    private static final Logger logger = LoggerFactory.getLogger(CoreComponentFormGenerator.class);
    private ResourceResolver resourceResolver;
    private JsonObject form;
    private final Map<String, String> resourceMappings = new HashMap<String, String>();
    private boolean createResources;
    private FormDataSchema.SchemaType dataSchemaType;
    private Boolean keyAsResourceName;

    public CoreComponentFormGenerator(@Nullable ResourceResolver resourceResolver, @Nonnull String crisprJsonString, @Nullable Map<String, String> resourceMappings, boolean createResources, FormDataSchema.SchemaType dataSchemaType) {
        this.resourceResolver = resourceResolver;
        this.form = this.parseJsonString(crisprJsonString);
        this.createResources = createResources;
        this.dataSchemaType = dataSchemaType;
        if (resourceMappings != null) {
            this.resourceMappings.putAll(resourceMappings);
        } else {
            this.initializeResourceMappings();
        }
    }

    public CoreComponentFormGenerator() {
    }

    public CoreComponentFormGenerator(@Nullable ResourceResolver resourceResolver, @Nonnull String crisprJsonString) {
        this(resourceResolver, crisprJsonString, null, false, FormDataSchema.SchemaType.JSON);
    }

    public CoreComponentFormGenerator(@Nullable ResourceResolver resourceResolver, @Nonnull String crisprJsonString, @Nullable Map<String, String> resourceMappings, FormDataSchema.SchemaType schemaType) {
        this(resourceResolver, crisprJsonString, resourceMappings, false, schemaType);
    }

    public CoreComponentFormGenerator(@Nullable ResourceResolver resourceResolver, @Nonnull String crisprJsonString, FormDataSchema.SchemaType schemaType) {
        this(resourceResolver, crisprJsonString, null, false, schemaType);
    }

    public CoreComponentFormGenerator(@Nullable ResourceResolver resourceResolver, @Nonnull String crisprJsonString, @Nullable Map<String, String> resourceMappings, boolean createResources, FormDataSchema.SchemaType dataSchemaType, @Nullable boolean keyAsResourceName) {
        this(resourceResolver, crisprJsonString, resourceMappings, createResources, dataSchemaType);
        this.keyAsResourceName = keyAsResourceName;
    }

    private static JsonObjectBuilder createObjectBuilderWithDefaults() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("jcr:primaryType", "nt:unstructured");
        return builder;
    }

    private JsonObject parseJsonString(String crisprJsonString) {
        JsonObject jsonObject;
        block8: {
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(crisprJsonString));
            try {
                jsonObject = jsonReader.readObject();
                if (jsonReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    logger.error("Failed to parse JSON string", (Throwable)ex);
                    throw new IllegalArgumentException("Invalid JSON string provided", ex);
                }
            }
            jsonReader.close();
        }
        return jsonObject;
    }

    private void initializeResourceMappings() {
        String productComponentPrefix = "core/fd/components/form";
        String productComponentPrintPrefix = "core/fd/components/print/";
        this.resourceMappings.put("plain-text", "core/fd/components/form/text/v1/text");
        this.resourceMappings.put("multiline-input", "core/fd/components/form/textinput/v1/textinput");
        this.resourceMappings.put("text-input", "core/fd/components/form/textinput/v1/textinput");
        this.resourceMappings.put("image", "core/fd/components/form/image/v1/image");
        this.resourceMappings.put("panel", "core/fd/components/form/panelcontainer/v1/panelcontainer");
        this.resourceMappings.put("file-input", "core/fd/components/form/fileinput/v1/fileinput");
        this.resourceMappings.put("checkbox-group", "core/fd/components/form/checkboxgroup/v1/checkboxgroup");
        this.resourceMappings.put("checkbox", "core/fd/components/form/checkbox/v1/checkbox");
        this.resourceMappings.put("radio-group", "core/fd/components/form/radiobutton/v1/radiobutton");
        this.resourceMappings.put("button", "core/fd/components/form/button/v1/button");
        this.resourceMappings.put("drop-down", "core/fd/components/form/dropdown/v1/dropdown");
        this.resourceMappings.put("date-input", "core/fd/components/form/datepicker/v1/datepicker");
        this.resourceMappings.put("number-input", "core/fd/components/form/numberinput/v1/numberinput");
        this.resourceMappings.put("email", "core/fd/components/form/emailinput/v1/emailinput");
        this.resourceMappings.put("captcha", "core/fd/components/form/recaptcha/v1/recaptcha");
        this.resourceMappings.put("submit", "core/fd/components/form/actions/submit/v1/submit");
        this.resourceMappings.put("form", "core/fd/components/form/container/v2/container");
        this.resourceMappings.put("pageTemplate", "core/fd/components/print//pagetemplate/v1/pagetemplate");
        this.resourceMappings.put("template", "core/fd/components/print//template/v1/template");
        this.resourceMappings.put("medium", "core/fd/components/form/medium/v1/medium");
        this.resourceMappings.put("contentarea", "core/fd/components/form/contentarea/v1/contentarea");
        this.resourceMappings.put("pagearea", "core/fd/components/print//pagearea/v1/pagearea");
        this.resourceMappings.put("pageset", "core/fd/components/print//pageset/v1/pageset");
        this.resourceMappings.put("barcode", "core/fd/components/print//barcode/v1/barcode");
        this.resourceMappings.put("line", "core/fd/components/print//line/v1/line");
        this.resourceMappings.put("rectangle", "core/fd/components/print//rectangle/v1/rectangle");
        this.resourceMappings.put("caption", "core/fd/components/print//caption/v1/caption");
        this.resourceMappings.put("proto", "core/fd/components/print//proto/v1/proto");
        this.resourceMappings.put("container", "core/fd/components/print//container/v1/container");
        this.resourceMappings.put("fragment", "core/fd/components/form/fragment/v1/fragment");
    }

    @Override
    public String generateForm(String formContainerPath, @Nonnull String crisprJsonString, boolean createResources, @Nullable boolean keyAsResourceName) throws Exception {
        this.resourceResolver = this.resourceResolverHelper.getServiceResourceResolver(null);
        this.form = this.parseJsonString(crisprJsonString);
        this.createResources = createResources;
        this.dataSchemaType = FormDataSchema.SchemaType.JSON;
        this.keyAsResourceName = keyAsResourceName;
        if (this.resourceMappings != null && this.resourceMappings == null && !this.resourceMappings.isEmpty()) {
            this.resourceMappings.putAll(this.resourceMappings);
        } else {
            this.initializeResourceMappings();
        }
        return this.generateForm(formContainerPath);
    }

    @Override
    public String generateForm() throws Exception {
        return this.generateForm(null);
    }

    @Override
    public String generateForm(@Nullable String formContainerPath) throws Exception {
        JsonObjectBuilder formBuilder = CoreComponentFormGenerator.createObjectBuilderWithDefaults();
        this.generateForm(formContainerPath, true, formBuilder);
        JsonObject formObject = formBuilder.build();
        return this.wrapContents(formObject);
    }

    private String wrapContents(JsonObject formObject) {
        JsonObject itemsObject;
        String contentTreeJson = "";
        if (formObject != null && (itemsObject = formObject.getJsonObject("items")) != null) {
            JsonObject itemsWithoutTypeObject = this.removeTypeFromItems(itemsObject);
            contentTreeJson = this.buildRootObject(itemsWithoutTypeObject);
        }
        return contentTreeJson;
    }

    private JsonObject removeTypeFromItems(JsonObject itemsObject) {
        JsonObjectBuilder itemsWithoutTypeBuilder = Json.createObjectBuilder();
        for (String key : itemsObject.keySet()) {
            if (key.equals("jcr:primaryType")) continue;
            itemsWithoutTypeBuilder.add(key, (JsonValue)itemsObject.get((Object)key));
        }
        return itemsWithoutTypeBuilder.build();
    }

    private JsonObjectBuilder createObjectBuilderFromJsonObject(JsonObject jsonObject, String ... propertiesToRemove) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        List<String> propertiesToRemoveList = Arrays.asList(propertiesToRemove);
        for (String key : jsonObject.keySet()) {
            if (propertiesToRemoveList.contains(key)) continue;
            builder.add(key, (JsonValue)jsonObject.get((Object)key));
        }
        return builder;
    }

    private String buildRootObject(JsonObject itemsWithoutTypeObject) {
        JsonObjectBuilder rootBuilder = Json.createObjectBuilder();
        if (itemsWithoutTypeObject.size() == 1) {
            String key = (String)itemsWithoutTypeObject.keySet().iterator().next();
            rootBuilder.add("afJsonSchemaRoot", (JsonValue)itemsWithoutTypeObject.get((Object)key));
        } else {
            JsonObjectBuilder wrapperBuilder = this.createWrapper(itemsWithoutTypeObject);
            rootBuilder.add("afJsonSchemaRoot", wrapperBuilder);
        }
        return rootBuilder.build().toString();
    }

    private JsonObjectBuilder createWrapper(JsonObject itemsWithoutTypeObject) {
        JsonObjectBuilder wrapperBuilder = CoreComponentFormGenerator.createObjectBuilderWithDefaults();
        JsonObjectBuilder itemsWrapperBuilder = CoreComponentFormGenerator.createObjectBuilderWithDefaults();
        String panelResourceTypeforWrapper = this.resourceMappings.get("panel");
        for (String key : itemsWithoutTypeObject.keySet()) {
            JsonObject itemObject;
            JsonValue itemValue = (JsonValue)itemsWithoutTypeObject.get((Object)key);
            if (itemValue.getValueType() == JsonValue.ValueType.OBJECT && (itemObject = (JsonObject)itemValue).containsKey((Object)"fieldType") && "panel".equals(itemObject.getString("fieldType"))) {
                panelResourceTypeforWrapper = this.determineResourceType(itemObject);
            }
            itemsWrapperBuilder.add(key, itemValue);
        }
        wrapperBuilder.add("name", "wrapperPanel");
        wrapperBuilder.add("fieldType", "panel");
        wrapperBuilder.add("items", itemsWrapperBuilder);
        wrapperBuilder.add("sling:resourceType", panelResourceTypeforWrapper);
        return wrapperBuilder;
    }

    private void generateForm(@Nullable String formContainerPath, boolean deleteExisting, JsonObjectBuilder formBuilder) throws Exception {
        logger.debug("[AF] Generating core component based form");
        Resource formContainer = null;
        if (StringUtils.isNotBlank((String)formContainerPath) && this.resourceResolver != null) {
            formContainer = this.resourceResolver.getResource(formContainerPath);
        }
        if (deleteExisting && this.createResources && formContainer != null) {
            this.deleteExistingChildren(formContainer);
        }
        this.handleFormContainerProperties(formContainer);
        this.processItems(this.form, formContainer, formBuilder);
        if (this.createResources && formContainer != null) {
            this.commitResourceResolver();
        }
    }

    private void handleFormContainerProperties(@Nullable Resource formContainer) throws Exception {
        ModifiableValueMap valueMap;
        Map<String, Object> formContainerPropertiesfromJson = this.extractCommonProperties(this.form);
        formContainerPropertiesfromJson.put("fieldType", "form");
        if (this.createResources && formContainer != null && (valueMap = (ModifiableValueMap)formContainer.adaptTo(ModifiableValueMap.class)) != null) {
            valueMap.putAll(formContainerPropertiesfromJson);
        }
        this.addPropertiesToBuilder(formContainerPropertiesfromJson, null);
        this.createCommonChildren(this.form, formContainer, null);
    }

    private void processItems(JsonObject form, @Nullable Resource parent, JsonObjectBuilder parentBuilder) throws Exception {
        JsonObjectBuilder itemsBuilder;
        JsonObject itemsObject = null;
        JsonArray itemsOrder = null;
        JsonArray itemsArray = null;
        if (form.containsKey((Object)"properties")) {
            JsonObject properties = form.getJsonObject("properties");
            JsonValue isFragment = null;
            if (properties != null && properties.get((Object)"fd:fragment") != null) {
                isFragment = (JsonValue)properties.get((Object)"fd:fragment");
            }
            if (isFragment != null && isFragment.toString().equals("true")) {
                return;
            }
        }
        if (form.containsKey((Object)"items")) {
            itemsArray = form.getJsonArray("items");
        } else if (form.containsKey((Object)":items") && form.containsKey((Object)":itemsOrder")) {
            itemsObject = form.getJsonObject(":items");
            itemsOrder = form.getJsonArray(":itemsOrder");
        }
        HashMap<String, Integer> nameMap = new HashMap<String, Integer>();
        if (itemsObject != null && itemsOrder != null) {
            itemsBuilder = CoreComponentFormGenerator.createObjectBuilderWithDefaults();
            for (JsonValue itemNameInOrder : itemsOrder) {
                if (itemNameInOrder instanceof JsonString) {
                    String itemName = ((JsonString)itemNameInOrder).getString();
                    JsonValue itemValue = (JsonValue)itemsObject.get((Object)itemName);
                    if (itemValue != null) {
                        if (itemValue.getValueType() == JsonValue.ValueType.OBJECT) {
                            JsonObject item = itemValue.asJsonObject();
                            itemsBuilder = this.visitInner(item, parent, itemsBuilder, nameMap, itemName);
                            continue;
                        }
                        logger.warn("Expected JsonObject but found " + itemValue.getValueType());
                        continue;
                    }
                    logger.warn("Item with name {} not found", (Object)itemName);
                    continue;
                }
                logger.warn("Expected JsonString but found " + itemNameInOrder.getValueType());
            }
            parentBuilder.add("items", itemsBuilder);
        } else if (itemsArray != null) {
            itemsBuilder = CoreComponentFormGenerator.createObjectBuilderWithDefaults();
            for (JsonValue itemValue : itemsArray) {
                if (itemValue.getValueType() == JsonValue.ValueType.OBJECT) {
                    JsonObject item = itemValue.asJsonObject();
                    itemsBuilder = this.visitInner(item, parent, itemsBuilder, nameMap, null);
                    continue;
                }
                logger.warn("Expected JsonObject but found " + itemValue.getValueType());
            }
            parentBuilder.add("items", itemsBuilder);
        } else {
            logger.warn("Items or itemsOrder not found in the form JsonObject");
        }
    }

    private void deleteExistingChildren(Resource formContainer) {
        try {
            if (this.resourceResolver != null) {
                for (Resource child : formContainer.getChildren()) {
                    this.resourceResolver.delete(child);
                }
                this.commitResourceResolver();
            }
        }
        catch (Exception ex) {
            logger.warn("Unable to delete child nodes of guideContainer", (Throwable)ex);
        }
    }

    private JsonObjectBuilder visitInner(JsonObject current, @Nullable Resource parent, JsonObjectBuilder parentBuilder, Map<String, Integer> nameMap, @Nullable String itemName) throws Exception {
        if (current.containsKey((Object)"fieldType")) {
            String fieldType = current.getString("fieldType");
            JsonObjectBuilder childBuilder = CoreComponentFormGenerator.createObjectBuilderWithDefaults();
            Resource child = this.createResource(current, parent, childBuilder, itemName);
            if (this.createResources && child == null) {
                logger.warn("child resource is null, for parent {}", (Object)current.toString());
                return parentBuilder;
            }
            if (("panel".equals(fieldType) || "proto".equals(fieldType) || "pageset".equals(fieldType) || "pagearea".equals(fieldType)) && (current.containsKey((Object)":items") || current.containsKey((Object)"items"))) {
                this.processItems(current, child, childBuilder);
            }
            if (FormDataSchema.SchemaType.XDP.equals((Object)this.dataSchemaType)) {
                JsonObject childJsonObject = childBuilder.build();
                JsonObjectBuilder tempBuilder = this.createObjectBuilderFromJsonObject(childJsonObject, "items", "jcr:primaryType");
                JsonObject tempJsonObject = tempBuilder.build();
                String xfaJsonString = tempJsonObject.toString();
                JsonObjectBuilder newChildBuilder = this.createObjectBuilderFromJsonObject(childJsonObject, new String[0]);
                newChildBuilder.add("fd:xfajson", xfaJsonString);
                childBuilder = newChildBuilder;
            }
            String name = this.keyAsResourceName != null && this.keyAsResourceName != false ? itemName : this.generateFieldName(current, fieldType);
            JsonObject parentJson = parentBuilder.build();
            parentBuilder = this.createObjectBuilderFromJsonObject(parentJson, new String[0]);
            if (parentJson.containsKey((Object)name)) {
                int nameCount = nameMap.getOrDefault(name, 0);
                name = name + "_" + nameCount;
                nameMap.put(name, nameCount + 1);
                childBuilder.add("name", name);
                parentBuilder.add(name, childBuilder);
            } else {
                parentBuilder.add(name, childBuilder);
            }
        } else {
            JsonObjectBuilder childBuilder = CoreComponentFormGenerator.createObjectBuilderWithDefaults();
            this.createField(current, parent, null, childBuilder, itemName);
            String name = this.keyAsResourceName != null && this.keyAsResourceName != false ? itemName : this.generateFieldName(current, null);
            parentBuilder.add(name, childBuilder);
        }
        return parentBuilder;
    }

    private Resource createResource(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, @Nullable String itemName) {
        String fieldType = field.getString("fieldType", "text-input");
        try {
            switch (fieldType) {
                case "panel": {
                    return this.createPanel(field, parent, builder, itemName);
                }
                case "pageset": {
                    return this.createPageset(field, parent, builder, itemName);
                }
                case "pagearea": {
                    return this.createPagearea(field, parent, builder, itemName);
                }
                case "text-input": {
                    return this.createTextInput(field, parent, builder, itemName);
                }
                case "multiline-input": {
                    return this.createField(field, parent, "multiline-input", builder, itemName);
                }
                case "email": {
                    return this.createEmail(field, parent, builder, itemName);
                }
                case "file-input": {
                    return this.createFileInput(field, parent, builder, itemName);
                }
                case "radio-group": {
                    return this.createRadioGroup(field, parent, builder, itemName);
                }
                case "plain-text": {
                    return this.createPlainText(field, parent, builder, itemName);
                }
                case "image": {
                    return this.createField(field, parent, "image", builder, itemName);
                }
                case "button": 
                case "submit": {
                    return this.createButton(field, parent, builder, itemName);
                }
                case "checkbox-group": {
                    return this.createCheckboxGroup(field, parent, builder, itemName);
                }
                case "checkbox": {
                    return this.createCheckBox(field, parent, builder, itemName);
                }
                case "captcha": {
                    return this.createCaptcha(field, parent, builder, itemName);
                }
                case "drop-down": {
                    return this.createDropDown(field, parent, builder, itemName);
                }
                case "date-input": {
                    return this.createDateInput(field, parent, builder, itemName);
                }
                case "number-input": {
                    return this.createNumberInput(field, parent, builder, itemName);
                }
                case "sign": {
                    return this.createSignBlock(field, parent, builder, itemName);
                }
                case "barcode": {
                    return this.createBarcode(field, parent, builder, itemName);
                }
                case "medium": {
                    return this.createMedium(field, parent, builder, itemName);
                }
                case "rectangle": {
                    return this.createRectangle(field, parent, builder, itemName);
                }
                case "line": {
                    return this.createLine(field, parent, builder, itemName);
                }
                case "dorcontainer": {
                    return this.createDorContainer(field, parent, builder, itemName);
                }
                case "caption": {
                    return this.createCaption(field, parent, builder, itemName);
                }
                case "proto": {
                    return this.createProto(field, parent, builder, itemName);
                }
                case "template": {
                    return this.createTemplate(field, parent, builder, itemName);
                }
                case "contentarea": {
                    return this.createContentarea(field, parent, builder, itemName);
                }
            }
            logger.warn("Transformer for fieldType={} not found.", (Object)fieldType);
            return this.createTextInput(field, parent, builder, itemName);
        }
        catch (PersistenceException ex) {
            logger.error("Unable to create resource", (Throwable)ex);
            return null;
        }
    }

    private void commitResourceResolver() {
        try {
            if (this.resourceResolver != null) {
                this.resourceResolver.commit();
                this.resourceResolver.refresh();
            }
        }
        catch (Exception ex) {
            logger.error("Unable to commit resource resolver", (Throwable)ex);
        }
    }

    private Resource createPanel(JsonObject panel, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(panel, parent, "panel", builder, itemName);
    }

    private Resource createTextInput(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "text-input", builder, itemName);
    }

    private Resource createEmail(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "email", builder, itemName);
    }

    private Resource createFileInput(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "file-input", builder, itemName);
    }

    private Resource createRadioGroup(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "radio-group", builder, itemName);
    }

    private Resource createPlainText(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "plain-text", builder, itemName);
    }

    private Resource createButton(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "button", builder, itemName);
    }

    private Resource createCheckboxGroup(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "checkbox-group", builder, itemName);
    }

    private Resource createCheckBox(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        HashMap<String, Object> extraProps = new HashMap<String, Object>();
        if (field.containsKey((Object)"enum")) {
            JsonArray enums = field.getJsonArray("enum");
            if (enums.size() > 2) {
                logger.warn("Checkbox group with more than 2 options is not supported. Only first 2 options will be considered.");
            }
            if (enums.size() < 1) {
                logger.error("Checkbox group with empty enums is not supported.");
            } else {
                JsonValue value = (JsonValue)enums.get(0);
                switch (value.getValueType()) {
                    case STRING: {
                        extraProps.put("type", "string");
                        extraProps.put("checkedValue", enums.getString(0));
                        if (enums.size() <= 1) break;
                        extraProps.put("uncheckedValue", enums.getString(1));
                        break;
                    }
                    case NUMBER: {
                        extraProps.put("type", "number");
                        extraProps.put("checkedValue", enums.getInt(0));
                        if (enums.size() <= 1) break;
                        extraProps.put("uncheckedValue", enums.getInt(1));
                        break;
                    }
                    case TRUE: 
                    case FALSE: {
                        extraProps.put("type", "boolean");
                        extraProps.put("checkedValue", enums.getBoolean(0));
                        if (enums.size() <= 1) break;
                        extraProps.put("uncheckedValue", enums.getBoolean(1));
                        break;
                    }
                    default: {
                        logger.warn("{} value type in enum is not supported", (Object)value.getValueType());
                        extraProps.put("type", "string");
                    }
                }
                extraProps.put("enableUncheckedValue", enums.size() > 1);
            }
        } else if (field.containsKey((Object)"type") && "boolean".equals(field.getString("type"))) {
            extraProps.put("type", "boolean");
            extraProps.put("checkedValue", true);
            extraProps.put("uncheckedValue", false);
            extraProps.put("enableUncheckedValue", true);
        } else {
            logger.error("Checkbox with empty enums is not supported.");
        }
        return this.createField(field, parent, "checkbox", builder, itemName, extraProps);
    }

    private Resource createCaptcha(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "captcha", builder, itemName);
    }

    private Resource createDropDown(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "drop-down", builder, itemName);
    }

    private Resource createDateInput(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "date-input", builder, itemName);
    }

    private Resource createNumberInput(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "number-input", builder, itemName);
    }

    private Resource createSignBlock(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "sign", builder, itemName);
    }

    private Resource createBarcode(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "barcode", builder, itemName);
    }

    private Resource createMedium(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "medium", builder, itemName);
    }

    private Resource createRectangle(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "rectangle", builder, itemName);
    }

    private Resource createLine(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "line", builder, itemName);
    }

    private Resource createDorContainer(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "dorcontainer", builder, itemName);
    }

    private Resource createCaption(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "caption", builder, itemName);
    }

    private Resource createProto(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "proto", builder, itemName);
    }

    private Resource createPageset(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "pageset", builder, itemName);
    }

    private Resource createPagearea(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "pagearea", builder, itemName);
    }

    private Resource createTemplate(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "template", builder, itemName);
    }

    private Resource createContentarea(JsonObject field, @Nullable Resource parent, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, "contentarea", builder, itemName);
    }

    private Resource createField(JsonObject field, @Nullable Resource parent, String fieldType, JsonObjectBuilder builder, String itemName, Map<String, Object> extraProperties) throws PersistenceException {
        String name;
        Resource resource = null;
        String string = name = this.keyAsResourceName != null && this.keyAsResourceName != false ? itemName : this.generateFieldName(field, fieldType);
        if (StringUtils.isNotBlank((String)fieldType)) {
            Map<String, Object> properties = this.extractCommonProperties(field);
            if (this.keyAsResourceName != null && !this.keyAsResourceName.booleanValue()) {
                properties.put("name", name);
            }
            if (this.keyAsResourceName == null) {
                properties.put("name", name);
            }
            properties.put("fieldType", fieldType);
            properties.putAll(extraProperties);
            if (parent != null && this.resourceResolver != null) {
                resource = this.resourceResolver.create(parent, name, properties);
            }
            this.addPropertiesToBuilder(properties, builder);
            this.createCommonChildren(field, resource, builder);
        } else {
            Map<String, Object> properties = this.extractCommonProperties(field);
            this.addPropertiesToBuilder(properties, builder);
            if (parent != null && this.resourceResolver != null) {
                resource = this.resourceResolver.create(parent, name, properties);
            }
        }
        return resource;
    }

    private Resource createField(JsonObject field, @Nullable Resource parent, String fieldType, JsonObjectBuilder builder, String itemName) throws PersistenceException {
        return this.createField(field, parent, fieldType, builder, itemName, new HashMap<String, Object>());
    }

    private String generateShortHashFromField(JsonObject field) {
        String fieldString = field.toString();
        String fullHash = DigestUtils.sha256Hex((String)fieldString);
        return fullHash.substring(0, 10);
    }

    private String generateFieldName(JsonObject field, @Nullable String fieldType) {
        String name = null;
        name = StringUtils.isNotBlank((String)fieldType) ? (field.containsKey((Object)"name") ? field.getString("name") : fieldType.replace("-", "_") + this.generateShortHashFromField(field)) : (field.containsKey((Object)"name") ? field.getString("name") : this.generateShortHashFromField(field));
        return this.enforceName(name);
    }

    private String enforceName(String name) {
        return name.replaceAll("[^a-zA-Z0-9]", "_");
    }

    private Map<String, Object> extractCommonProperties(JsonObject field) {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        String resourceType = this.determineResourceType(field);
        String icon = this.getIconFromResource(resourceType);
        propertiesMap.put("sling:resourceType", resourceType);
        if (!this.createResources && StringUtils.isNotBlank((String)icon)) {
            propertiesMap.put("icon", icon);
        }
        Resource template = null;
        try {
            template = AdaptiveFormUtil.getTemplateNode((String)resourceType, (ResourceResolver)this.resourceResolver);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (template != null) {
            ValueMap templateProperties = (ValueMap)template.adaptTo(ValueMap.class);
            if (templateProperties != null) {
                for (Map.Entry entry : templateProperties.entrySet()) {
                    propertiesMap.putIfAbsent((String)entry.getKey(), entry.getValue());
                }
            } else {
                logger.warn("Could not adapt template to ValueMap for resource type {}", (Object)resourceType);
            }
        }
        this.populateFieldOrPanelProperties(field, propertiesMap);
        this.populateEnums(field, propertiesMap);
        return propertiesMap;
    }

    private String getIconFromResource(String type) {
        ValueMap superResourceProps;
        Resource superResource;
        String superType = type;
        String icon = "";
        if (this.resourceResolver == null) {
            return icon;
        }
        while (StringUtils.isEmpty((String)icon) && (superResource = this.resourceResolver.getResource(superType)) != null && (superResourceProps = (ValueMap)superResource.adaptTo(ValueMap.class)) != null) {
            if (superResourceProps.containsKey((Object)"cq:icon")) {
                icon = superResourceProps.get((Object)"cq:icon").toString();
                continue;
            }
            Object superResourceType = superResourceProps.get((Object)"sling:resourceSuperType");
            if (superResourceType == null) break;
            superType = superResourceType.toString();
        }
        return icon;
    }

    private void populateEnums(JsonObject field, Map<String, Object> propertiesMap) {
        List<String> fieldTypes = Arrays.asList("drop-down", "checkbox-group", "radio-group", "checkbox");
        if (field.containsKey((Object)"enum")) {
            JsonArray enumArray = field.getJsonArray("enum");
            ArrayList<Object> enumList = new ArrayList<Object>();
            block5: for (JsonValue value : enumArray) {
                switch (value.getValueType()) {
                    case STRING: {
                        enumList.add(((JsonString)value).getString());
                        if (field.containsKey((Object)"type") && field.getString("type").endsWith("[]")) {
                            propertiesMap.put("type", "string[]");
                            continue block5;
                        }
                        propertiesMap.put("type", "string");
                        continue block5;
                    }
                    case NUMBER: {
                        JsonNumber num = (JsonNumber)value;
                        if (num.isIntegral()) {
                            enumList.add(num.longValue());
                        } else {
                            enumList.add(num.doubleValue());
                        }
                        if (field.containsKey((Object)"type") && field.getString("type").endsWith("[]")) {
                            propertiesMap.put("type", "number[]");
                            continue block5;
                        }
                        propertiesMap.put("type", "number");
                        continue block5;
                    }
                    case TRUE: 
                    case FALSE: {
                        enumList.add(value.getValueType() == JsonValue.ValueType.TRUE);
                        if (field.containsKey((Object)"type") && field.getString("type").endsWith("[]")) {
                            propertiesMap.put("type", "boolean[]");
                            continue block5;
                        }
                        propertiesMap.put("type", "boolean");
                        continue block5;
                    }
                }
                throw new IllegalArgumentException("Unsupported enum type");
            }
            propertiesMap.put("enum", enumList.toArray());
            propertiesMap.put("enumNames", enumList.stream().map(Object::toString).toArray(String[]::new));
        } else if (field.containsKey((Object)"fieldType") && fieldTypes.contains(field.getString("fieldType")) && field.containsKey((Object)"type") && "boolean".equals(field.getString("type"))) {
            propertiesMap.put("enum", new String[]{"true", "false"});
            propertiesMap.put("enumNames", new String[]{"true", "false"});
            if (field.containsKey((Object)"type") && field.getString("type").endsWith("[]")) {
                propertiesMap.put("type", "boolean[]");
            } else {
                propertiesMap.put("type", "boolean");
            }
        }
        if (field.containsKey((Object)"enumNames")) {
            String[] enumNamesArr = (String[])field.getJsonArray("enumNames").getValuesAs(JsonString.class).stream().map(JsonString::getString).toArray(String[]::new);
            propertiesMap.put("enumNames", enumNamesArr);
        }
    }

    private String determineResourceType(JsonObject field) {
        String resourceType;
        String string = resourceType = field.containsKey((Object)":type") ? field.getString(":type") : null;
        if (resourceType == null && field.containsKey((Object)"fieldType")) {
            resourceType = this.resourceMappings.get(field.getString("fieldType"));
        }
        if (resourceType == null) {
            resourceType = this.resourceMappings.get("text-input");
        }
        return resourceType;
    }

    private void populateFieldOrPanelProperties(JsonObject field, Map<String, Object> propertiesMap) {
        List<String> layoutIgnoreList = Arrays.asList("columnCount", "columnClassNames", "gridClassNames", "allowedComponents");
        List<String> keysToIgnore = Arrays.asList(":items", "items", ":type", ":itemsOrder", "dataLayer", "id", "events", "rules", "metadata", "allowedComponents", "action", "enum", "enumNames");
        block10: for (Map.Entry entry : field.entrySet()) {
            String key = (String)entry.getKey();
            JsonValue value = (JsonValue)entry.getValue();
            if (keysToIgnore.contains(key) || layoutIgnoreList.contains(key)) continue;
            switch (key) {
                case "label": {
                    this.handleLabel((JsonValue)value.asJsonObject(), propertiesMap);
                    continue block10;
                }
                case "constraintMessages": {
                    if (value.getValueType() != JsonValue.ValueType.OBJECT) continue block10;
                    this.handleConstraintMessages(value, propertiesMap);
                    continue block10;
                }
                case "properties": {
                    this.handleProperties(value, propertiesMap);
                    continue block10;
                }
            }
            this.handleDefault(key, value, propertiesMap);
        }
    }

    private void handleProperties(JsonValue value, Map<String, Object> propertiesMap) {
        List<String> keysToIgnore = Arrays.asList("fd:path", "fd:formDataEnabled", "fd:schemaType");
        if (value.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject propertiesObject = value.asJsonObject();
            block7: for (Map.Entry propEntry : propertiesObject.entrySet()) {
                String propKey = (String)propEntry.getKey();
                JsonValue propValue = (JsonValue)propEntry.getValue();
                if (keysToIgnore.contains(propKey)) continue;
                switch (propKey) {
                    case "afs:layout": 
                    case "fd:dor": {
                        if (propValue.getValueType() != JsonValue.ValueType.OBJECT) continue block7;
                        this.handleComplexProperty(propValue.asJsonObject(), propertiesMap);
                        continue block7;
                    }
                }
                this.handleDefault(propKey, propValue, propertiesMap);
            }
        }
    }

    private void handleConstraintMessages(JsonValue constraintMessagesValue, Map<String, Object> propertiesMap) {
        if (constraintMessagesValue.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject constraintMessages = constraintMessagesValue.asJsonObject();
            HashMap<String, String> constraintMessageMap = new HashMap<String, String>();
            constraintMessageMap.put("required", "mandatoryMessage");
            constraintMessageMap.put("minimum", "minimumMessage");
            constraintMessageMap.put("maximum", "maximumMessage");
            constraintMessageMap.put("minLength", "minLengthMessage");
            constraintMessageMap.put("maxLength", "maxLengthMessage");
            constraintMessageMap.put("step", "stepMessage");
            constraintMessageMap.put("format", "formatMessage");
            constraintMessageMap.put("minItems", "minItemsMessage");
            constraintMessageMap.put("maxItems", "maxItemsMessage");
            constraintMessageMap.put("uniqueItems", "uniqueItemsMessage");
            constraintMessageMap.put("enforceEnum", "enforceEnumMessage");
            constraintMessageMap.put("validationExpression", "validateExpMessage");
            constraintMessageMap.put("maxFileSize", "maxFileSizeMessage");
            constraintMessageMap.put("accept", "acceptMessage");
            for (Map.Entry entry : constraintMessages.entrySet()) {
                String key = (String)entry.getKey();
                JsonValue value = (JsonValue)entry.getValue();
                String mappedKey = constraintMessageMap.getOrDefault(key, key);
                this.handleJsonValue(mappedKey, value, propertiesMap);
            }
        }
    }

    private void handlePropertiesHelper(JsonObject propertiesObject, Map<String, Object> propertiesMap) {
        propertiesMap.put("jcr:primaryType", "nt:unstructured");
        propertiesMap.put("sling:resourceType", this.determineResourceType(propertiesObject));
        for (Map.Entry entry : propertiesObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonValue value = (JsonValue)entry.getValue();
            if ("template".equals(key) && value.getValueType() == JsonValue.ValueType.OBJECT || ":type".equals(key) || "caption".equals(key) || "itemsOrder".equals(key) || ":items".equals(key) || ":itemsOrder".equals(key)) continue;
            this.handleJsonValue(key, value, propertiesMap);
        }
    }

    private void handleComplexProperty(JsonObject complexObject, Map<String, Object> propertiesMap) {
        for (Map.Entry entry : complexObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonValue value = (JsonValue)entry.getValue();
            if ("pageTemplate".equals(key) && value.getValueType() == JsonValue.ValueType.OBJECT) {
                HashMap<String, Object> pageTemplateProps = new HashMap<String, Object>();
                this.handlePropertiesHelper(value.asJsonObject(), pageTemplateProps);
                propertiesMap.put("fd:pageTemplate", pageTemplateProps);
                continue;
            }
            if ("dorContainer".equals(key) && value.getValueType() == JsonValue.ValueType.OBJECT) {
                JsonObject dorContainerObj = value.asJsonObject();
                HashMap<String, Object> dorContainerProps = new HashMap<String, Object>();
                this.handlePropertiesHelper(dorContainerObj, dorContainerProps);
                propertiesMap.put("fd:dorContainer", dorContainerProps);
                continue;
            }
            this.handleJsonValue(key, value, propertiesMap);
        }
    }

    private void handleLabel(JsonValue labelValue, Map<String, Object> propertiesMap) {
        if (labelValue.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonValue isLabelRichText;
            JsonObject labelObject = labelValue.asJsonObject();
            this.handleJsonValue("jcr:title", (JsonValue)labelObject.get((Object)"value"), propertiesMap);
            JsonValue labelVisible = (JsonValue)labelObject.get((Object)"visible");
            if (labelVisible != null) {
                JsonValue hideTitleValue = labelVisible.getValueType() == JsonValue.ValueType.TRUE ? JsonValue.FALSE : JsonValue.TRUE;
                this.handleJsonValue("hideTitle", hideTitleValue, propertiesMap);
            }
            if ((isLabelRichText = (JsonValue)labelObject.get((Object)"richText")) != null) {
                this.handleJsonValue("isTitleRichText", isLabelRichText, propertiesMap);
            }
        }
    }

    private void handleDefault(String key, JsonValue value, Map<String, Object> propertiesMap) {
        HashMap<String, String> jsonToJcrMap = new HashMap<String, String>();
        jsonToJcrMap.put("adaptiveform", "specVersion");
        jsonToJcrMap.put("richText", "textIsRich");
        jsonToJcrMap.put("screenReaderText", "assistPriority");
        String mappedKey = jsonToJcrMap.getOrDefault(key, key);
        if ("assistPriority".equals(mappedKey)) {
            propertiesMap.put("assistPriority", "custom");
            this.handleJsonValue("custom", value, propertiesMap);
        }
        this.handleJsonValue(mappedKey, value, propertiesMap);
    }

    private void handleJsonValue(String key, JsonValue value, Map<String, Object> propertiesMap) {
        if (value != null && value instanceof JsonString) {
            propertiesMap.put(key, ((JsonString)value).getString());
        } else if (value != null && value instanceof JsonNumber) {
            JsonNumber number = (JsonNumber)value;
            if (number.isIntegral()) {
                propertiesMap.put(key, number.longValue());
            } else {
                propertiesMap.put(key, number.doubleValue());
            }
        } else if (value != null && value.getValueType() == JsonValue.ValueType.TRUE || value != null && value.getValueType() == JsonValue.ValueType.FALSE) {
            propertiesMap.put(key, value.getValueType() == JsonValue.ValueType.TRUE);
        } else if (value != null && value.getValueType() == JsonValue.ValueType.OBJECT) {
            if ("pageTemplate".equals(key) || "dorContainer".equals(key) || "template".equals(key)) {
                HashMap<String, Object> nestedProps = new HashMap<String, Object>();
                JsonObject jsonObject = value.asJsonObject();
                this.processJsonObject(jsonObject, nestedProps, null);
                propertiesMap.put(key, nestedProps);
            } else {
                propertiesMap.put(key, value.toString());
            }
        } else {
            propertiesMap.put(key, value != null ? value.toString() : null);
        }
    }

    private void handleSpecialNode(JsonObject element, @Nullable Resource parentResource, String propertyPath, String propertyName, String nodeName, boolean handleTemplate) throws Exception {
        if (!this.nodeExists(element, propertyPath, propertyName)) {
            return;
        }
        JsonObject nodeJson = this.getNestedJsonObject(element, propertyPath, propertyName);
        if (nodeJson == null) {
            return;
        }
        HashMap<String, Object> nodeProps = new HashMap<String, Object>();
        this.handlePropertiesHelper(nodeJson, nodeProps);
        if (parentResource != null && this.createResources) {
            Resource newNode = this.resourceResolver.create(parentResource, nodeName, nodeProps);
            if (handleTemplate) {
                String childNodeKey = "pageTemplate".equals(propertyName) ? "template" : "caption";
                this.handleChildNode(nodeJson, newNode, childNodeKey);
            }
            this.handleItemsIfExist(nodeJson, newNode);
            this.resourceResolver.commit();
        }
    }

    private boolean nodeExists(JsonObject element, String propertyPath, String propertyName) {
        return element.containsKey((Object)"properties") && element.getJsonObject("properties").containsKey((Object)propertyPath) && element.getJsonObject("properties").getJsonObject(propertyPath).containsKey((Object)propertyName);
    }

    private JsonObject getNestedJsonObject(JsonObject element, String propertyPath, String propertyName) throws PersistenceException {
        if (element == null) {
            throw new PersistenceException("Element is null");
        }
        JsonObject properties = element.getJsonObject("properties");
        if (properties == null) {
            throw new PersistenceException(String.format("Properties object not found in element for path: %s, property: %s", propertyPath, propertyName));
        }
        JsonObject pathObject = properties.getJsonObject(propertyPath);
        if (pathObject == null) {
            throw new PersistenceException(String.format("Path object %s not found in properties", propertyPath));
        }
        JsonObject propertyObject = pathObject.getJsonObject(propertyName);
        if (propertyObject == null) {
            throw new PersistenceException(String.format("Property %s not found in path %s", propertyName, propertyPath));
        }
        return propertyObject;
    }

    private void handleChildNode(JsonObject parentJson, Resource parentResource, String childNodeKey) throws Exception {
        if (!parentJson.containsKey((Object)childNodeKey)) {
            return;
        }
        JsonObject childObj = parentJson.getJsonObject(childNodeKey);
        HashMap<String, Object> childProps = new HashMap<String, Object>();
        this.handlePropertiesHelper(childObj, childProps);
        String nodeName = "caption".equals(childNodeKey) ? "fd:caption" : childNodeKey;
        Resource childNode = this.resourceResolver.create(parentResource, nodeName, childProps);
        this.handleItemsIfExist(childObj, childNode);
    }

    private void handleItemsIfExist(JsonObject json, Resource parentResource) throws Exception {
        if (json.containsKey((Object)":items") && json.containsKey((Object)":itemsOrder")) {
            JsonObjectBuilder builder = CoreComponentFormGenerator.createObjectBuilderWithDefaults();
            this.processItems(json, parentResource, builder);
        }
    }

    private Resource createCommonChildren(JsonObject element, @Nullable Resource field, @Nullable JsonObjectBuilder parentBuilder) throws PersistenceException {
        JsonObject rules;
        boolean propertiesRulesExist;
        HashMap properties;
        boolean eventsExist;
        if (field != null) {
            String resourceType = field.getResourceType();
            Resource template = null;
            try {
                template = AdaptiveFormUtil.getTemplateNode((String)resourceType, (ResourceResolver)this.resourceResolver);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (template != null && this.createResources) {
                Resource events;
                Resource rules2 = template.getChild("fd:rules");
                if (rules2 != null) {
                    this.resourceResolver.copy(rules2.getPath(), field.getPath());
                }
                if ((events = template.getChild("fd:events")) != null) {
                    this.resourceResolver.copy(events.getPath(), field.getPath());
                }
                this.resourceResolver.commit();
            }
        }
        if (eventsExist = element.containsKey((Object)"events")) {
            JsonObject events = element.getJsonObject("events");
            JsonObjectBuilder eventsBuilder = CoreComponentFormGenerator.createObjectBuilderWithDefaults();
            properties = new HashMap();
            events.forEach((key, value) -> {
                switch (value.getValueType()) {
                    case ARRAY: {
                        JsonArrayBuilder eventsArrayBuilder = Json.createArrayBuilder();
                        value.asJsonArray().forEach(arrayValue -> {
                            if (arrayValue.getValueType() == JsonValue.ValueType.STRING) {
                                eventsArrayBuilder.add(((JsonString)arrayValue).getString());
                            } else {
                                eventsArrayBuilder.add(arrayValue.toString());
                            }
                        });
                        eventsBuilder.add(key, eventsArrayBuilder);
                        String[] eventsValue = (String[])value.asJsonArray().getValuesAs(JsonString.class).stream().map(JsonString::getString).toArray(String[]::new);
                        properties.put(key, eventsValue);
                        break;
                    }
                    case STRING: {
                        JsonString eventValue = (JsonString)value;
                        properties.put(key, new String[]{eventValue.getString()});
                        JsonArrayBuilder eventsArrayBuilder1 = Json.createArrayBuilder();
                        eventsArrayBuilder1.add(eventValue.getString());
                        eventsBuilder.add(key, eventsArrayBuilder1);
                    }
                }
            });
            if (field != null && this.createResources) {
                this.resourceResolver.create(field, "fd:events", properties);
            }
            if (parentBuilder != null) {
                parentBuilder.add("fd:events", eventsBuilder);
            }
        }
        boolean rulesExist = element.containsKey((Object)"rules") || element.containsKey((Object)"fd:rules");
        boolean bl = propertiesRulesExist = element.containsKey((Object)"properties") && element.getJsonObject("properties").containsKey((Object)"fd:rules");
        if (rulesExist) {
            properties = new HashMap();
            JsonObjectBuilder rulesBuilder = CoreComponentFormGenerator.createObjectBuilderWithDefaults();
            if (element.containsKey((Object)"rules")) {
                rules = element.getJsonObject("rules");
                rules.forEach((key, value) -> {
                    if (value.getValueType() == JsonValue.ValueType.STRING) {
                        JsonString eventValue = (JsonString)value;
                        properties.put(key, eventValue.getString());
                        rulesBuilder.add(key, eventValue.getString());
                    } else {
                        logger.warn("rules should be of type string, got type=" + value.getValueType().name());
                    }
                });
            }
            if (element.containsKey((Object)"fd:rules")) {
                rules = element.getJsonObject("fd:rules");
                rules.forEach((key, value) -> {
                    if (value.getValueType() == JsonValue.ValueType.ARRAY) {
                        JsonArrayBuilder rulesArrayBuilder = Json.createArrayBuilder();
                        JsonArray array = value.asJsonArray();
                        array.forEach(arrayValue -> {
                            if (arrayValue.getValueType() == JsonValue.ValueType.STRING) {
                                rulesArrayBuilder.add(((JsonString)arrayValue).getString());
                            } else {
                                rulesArrayBuilder.add(arrayValue.toString());
                            }
                        });
                        rulesBuilder.add(key, rulesArrayBuilder);
                        String[] valueArr = (String[])array.getValuesAs(JsonString.class).stream().map(JsonString::getString).toArray(String[]::new);
                        properties.put(key, valueArr);
                    } else {
                        logger.warn("rules should be of type string, got type=" + value.getValueType().name());
                    }
                });
            }
            if (field != null && this.createResources) {
                this.resourceResolver.create(field, "rules", properties);
            }
            if (rulesBuilder != null) {
                rulesBuilder.add("rules", (JsonValue)rulesBuilder.build());
            }
            if (rulesBuilder != null) {
                rulesBuilder.add("fd:rules", (JsonValue)rulesBuilder.build());
            }
        }
        if (propertiesRulesExist) {
            properties = new HashMap();
            JsonObjectBuilder fdRulesBuilder = CoreComponentFormGenerator.createObjectBuilderWithDefaults();
            if (element.containsKey((Object)"properties") && element.getJsonObject("properties").containsKey((Object)"fd:rules")) {
                rules = element.getJsonObject("properties").getJsonObject("fd:rules");
                rules.forEach((key, value) -> {
                    if (value.getValueType() == JsonValue.ValueType.STRING) {
                        JsonString eventValue = (JsonString)value;
                        properties.put(key, eventValue.getString());
                        fdRulesBuilder.add(key, eventValue.getString());
                    } else if (value.getValueType() == JsonValue.ValueType.ARRAY) {
                        JsonArrayBuilder rulesArrayBuilder = Json.createArrayBuilder();
                        JsonArray array = value.asJsonArray();
                        array.forEach(arrayValue -> {
                            if (arrayValue.getValueType() == JsonValue.ValueType.STRING) {
                                rulesArrayBuilder.add(((JsonString)arrayValue).getString());
                            } else {
                                rulesArrayBuilder.add(arrayValue.toString());
                            }
                        });
                        fdRulesBuilder.add(key, rulesArrayBuilder);
                        String[] valueArr = (String[])array.getValuesAs(JsonString.class).stream().map(JsonString::getString).toArray(String[]::new);
                        properties.put(key, valueArr);
                    } else {
                        logger.warn("rules should be of type string, got type=" + value.getValueType().name());
                    }
                });
            }
            if (field != null && this.createResources) {
                this.resourceResolver.create(field, "fd:rules", properties);
            }
            if (fdRulesBuilder != null) {
                fdRulesBuilder.add("fd:rules", (JsonValue)fdRulesBuilder.build());
            }
            if (fdRulesBuilder != null) {
                fdRulesBuilder.add("fd:rules", (JsonValue)fdRulesBuilder.build());
            }
        }
        try {
            this.handleSpecialNode(element, field, "fd:dor", "pageTemplate", "fd:pageTemplate", true);
            this.handleSpecialNode(element, field, "fd:dor", "dorContainer", "fd:dorContainer", true);
        }
        catch (Exception ex) {
            logger.warn("Failed to handle special nodes", (Throwable)ex);
        }
        return field;
    }

    private void processJsonObject(JsonObject jsonObj, Map<String, Object> properties, JsonObjectBuilder builder) {
        jsonObj.forEach((key, value) -> {
            switch (value.getValueType()) {
                case OBJECT: {
                    JsonObject nestedObj = value.asJsonObject();
                    HashMap<String, Object> nestedProps = new HashMap<String, Object>();
                    JsonObjectBuilder nestedBuilder = builder != null ? CoreComponentFormGenerator.createObjectBuilderWithDefaults() : null;
                    this.processJsonObject(nestedObj, nestedProps, nestedBuilder);
                    properties.put((String)key, nestedProps);
                    if (builder == null) break;
                    builder.add(key, nestedBuilder);
                    break;
                }
                default: {
                    properties.put((String)key, value.toString());
                    if (builder == null) break;
                    builder.add(key, value.toString());
                }
            }
        });
    }

    private void addPropertiesToBuilder(Map<String, Object> properties, @Nullable JsonObjectBuilder builder) {
        if (builder != null) {
            properties.forEach((key, value) -> {
                if (value == null) {
                    return;
                }
                if (value instanceof String) {
                    builder.add(key, (String)value);
                } else if (value instanceof Number) {
                    Number numberValue = (Number)value;
                    if (numberValue instanceof Long) {
                        builder.add(key, ((Long)numberValue).longValue());
                    } else if (numberValue instanceof Double) {
                        builder.add(key, ((Double)numberValue).doubleValue());
                    } else {
                        builder.add(key, numberValue.toString());
                    }
                } else if (value instanceof Boolean) {
                    builder.add(key, ((Boolean)value).booleanValue());
                } else if (value instanceof JsonObject) {
                    builder.add(key, (JsonValue)((JsonObject)value));
                } else if (value instanceof JsonArray) {
                    builder.add(key, (JsonValue)((JsonArray)value));
                } else if (value instanceof String[]) {
                    List<String> stringList = Arrays.asList((String[])value);
                    JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
                    stringList.forEach(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
                    builder.add(key, (JsonValue)arrayBuilder.build());
                } else if (value instanceof Object[]) {
                    List<Object> objectList = Arrays.asList((Object[])value);
                    JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
                    objectList.forEach(item -> {
                        if (item instanceof String) {
                            arrayBuilder.add((String)item);
                        } else if (item instanceof Number) {
                            Number numberItem = (Number)item;
                            if (numberItem instanceof Long) {
                                arrayBuilder.add(((Long)numberItem).longValue());
                            } else if (numberItem instanceof Double) {
                                arrayBuilder.add(((Double)numberItem).doubleValue());
                            } else {
                                arrayBuilder.add(numberItem.toString());
                            }
                        } else if (item instanceof Boolean) {
                            arrayBuilder.add(((Boolean)item).booleanValue());
                        } else {
                            arrayBuilder.add(item.toString());
                        }
                    });
                    builder.add(key, (JsonValue)arrayBuilder.build());
                } else {
                    builder.add(key, value.toString());
                }
            });
        }
    }
}

