/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common.xfa;

import com.adobe.aemds.guide.common.xfa.XFADraw;
import com.adobe.aemds.guide.common.xfa.XFAElement;
import com.adobe.aemds.guide.common.xfa.XFAExclGroup;
import com.adobe.aemds.guide.common.xfa.XFAField;
import com.adobe.aemds.guide.common.xfa.XFAInstanceManager;
import com.adobe.aemds.guide.common.xfa.XFASubform;
import com.adobe.aemds.guide.common.xfa.XFATable;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class XFAElementFactory {
    private static boolean checkIfContainerIsTableHeader(ObjectNode containerJson) throws Exception {
        boolean isHeader = false;
        ArrayNode containerChildren = (ArrayNode)containerJson.get("children");
        for (int i = 0; i < containerChildren.size(); ++i) {
            ObjectNode childJson = (ObjectNode)containerChildren.get(i);
            String childType = childJson.get("_class").asText();
            if (!"assist".equals(childType)) continue;
            isHeader = "TH".equals(childJson.get("role").asText());
            break;
        }
        return isHeader;
    }

    private static boolean checkIfSupportedTable(ObjectNode containerJson, int tableHeaderCount) throws Exception {
        if (containerJson.has("children") && containerJson.get("children").isArray()) {
            ArrayNode containerChildren = (ArrayNode)containerJson.get("children");
            for (int i = 0; i < containerChildren.size(); ++i) {
                boolean isValidTable;
                ObjectNode childJson = (ObjectNode)containerChildren.get(i);
                String childType = childJson.get("_class").asText();
                if (!"subform".equals(childType)) continue;
                if (childJson.has("layout") && "table".equals(childJson.get("layout").asText())) {
                    return false;
                }
                if (tableHeaderCount == 0) {
                    if (XFAElementFactory.checkIfContainerIsTableHeader(childJson)) {
                        if (isValidTable = XFAElementFactory.checkIfSupportedTable(childJson, tableHeaderCount++)) continue;
                        return false;
                    }
                    return false;
                }
                if (XFAElementFactory.checkIfContainerIsTableHeader(childJson)) {
                    return false;
                }
                isValidTable = XFAElementFactory.checkIfSupportedTable(childJson, tableHeaderCount);
                if (isValidTable) continue;
                return false;
            }
        }
        return true;
    }

    public static XFAElement getXFAElement(ObjectNode object) throws Exception {
        String childType = object.get("_class").asText();
        if ("instanceManager".equals(childType)) {
            return new XFAInstanceManager(object);
        }
        if ("subform".equals(childType)) {
            String layout;
            if (object.has("layout") && object.get("layout").isTextual() && (layout = object.get("layout").asText()) != null && layout.length() > 0 && "table".equals(layout) && XFAElementFactory.checkIfSupportedTable(object, 0)) {
                return new XFATable(object);
            }
            return new XFASubform(object);
        }
        if ("field".equals(childType)) {
            return new XFAField(object);
        }
        if ("draw".equals(childType)) {
            return new XFADraw(object);
        }
        if ("exclGroup".equals(childType)) {
            return new XFAExclGroup(object);
        }
        return new XFAElement(object);
    }
}

