/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.service;

import com.adobe.aemds.guide.service.GuideException;
import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.mail.internet.AddressException;
import org.apache.commons.mail.EmailException;

public class GuideEmailException
extends GuideException {
    private final Code code;
    private final boolean customerActionable;

    public GuideEmailException(Code code, String message, Throwable cause, boolean customerActionable) {
        super(message, cause instanceof Exception ? (Exception)cause : new Exception(cause));
        this.code = code;
        this.customerActionable = customerActionable;
    }

    public Code getCode() {
        return this.code;
    }

    public boolean isCustomerActionable() {
        return this.customerActionable;
    }

    public static GuideEmailException map(Throwable t) {
        if (t instanceof GuideEmailException) {
            return (GuideEmailException)t;
        }
        if (t instanceof EmailException || t instanceof AddressException) {
            boolean invalid = GuideEmailException.containsIgnoreCase(t.getMessage(), "Invalid email address") || t instanceof AddressException;
            return new GuideEmailException(invalid ? Code.INVALID_ADDRESS : Code.SEND_FAILURE, GuideEmailException.safeMessage(t, invalid ? "Invalid email address" : "Email send failure"), t, true);
        }
        if (t instanceof IOException) {
            return new GuideEmailException(Code.ATTACHMENT_IO, GuideEmailException.safeMessage(t, "Attachment IO error"), t, true);
        }
        if (t instanceof RepositoryException) {
            return new GuideEmailException(Code.REPOSITORY_ERROR, GuideEmailException.safeMessage(t, "Repository error"), t, false);
        }
        return new GuideEmailException(Code.UNKNOWN, GuideEmailException.safeMessage(t, "Unknown email error"), t, false);
    }

    private static boolean containsIgnoreCase(String s, String needle) {
        return s != null && needle != null && s.toLowerCase().contains(needle.toLowerCase());
    }

    private static String safeMessage(Throwable t, String fallback) {
        return t != null && t.getMessage() != null && !t.getMessage().isEmpty() ? t.getMessage() : fallback;
    }

    public static enum Code {
        INVALID_ADDRESS,
        SEND_FAILURE,
        ATTACHMENT_IO,
        REPOSITORY_ERROR,
        UNKNOWN;

    }
}

