/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.models.form.print.dorapi;

import com.fasterxml.jackson.annotation.JsonValue;

public enum XfaElementType {
    PAGESET("pageset"),
    PAGEAREA("pagearea"),
    CONTENTAREA("contentarea"),
    MEDIUM("medium"),
    SUBFORM("subform"),
    PANEL("panel"),
    TEXTFIELD("textfield"),
    CHECKBUTTON("checkbutton"),
    BUTTON("button"),
    DATEFIELD("datefield"),
    DATETIMEFIELD("datetimefield"),
    NUMERICFIELD("numericfield"),
    RADIOBUTTON("radiobutton"),
    TEXT("text"),
    IMAGE("image"),
    IMAGEFIELD("imagefield"),
    EXCLUSIONGROUP("exclusiongroup"),
    BARCODE("barcode"),
    LINE("line"),
    RECTANGLE("rectangle"),
    PROTO("proto");

    private String value;

    private XfaElementType(String value) {
        this.value = value;
    }

    public static XfaElementType fromString(String value) {
        for (XfaElementType type : XfaElementType.values()) {
            if (!value.equals(type.value)) continue;
            return type;
        }
        return SUBFORM;
    }

    public String getValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.value;
    }
}

