/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.util;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.cq.forms.core.components.models.form.Captcha;
import com.adobe.cq.forms.core.components.models.form.FieldType;
import com.adobe.cq.forms.core.components.util.AbstractFieldImpl;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCaptchaImpl
extends AbstractFieldImpl
implements Captcha {
    public static final String CUSTOM_RECAPTCHA_PROPERTY_WRAPPER = "fd:captcha";
    protected static final String CAPTCHA_CONFIG = "config";
    protected static final String CAPTCHA_SITE_KEY = "siteKey";
    protected static final String CAPTCHA_URI = "uri";
    protected static final String CAPTCHA_SIZE = "size";
    protected static final String CAPTCHA_THEME = "theme";
    protected static final String CAPTCHA_THEME_LIGHT = "light";
    protected static final String CAPTCHA_TYPE = "type";
    protected static final String CAPTCHA_TYPE_IMAGE = "image";
    protected static final String CAPTCHA_WIDGET_TYPE = "widgetType";

    @Override
    @JsonIgnore
    public abstract String getProvider();

    @Override
    public String getFieldType() {
        return super.getFieldType(FieldType.CAPTCHA);
    }

    @Override
    @JsonIgnore
    public abstract Map<String, Object> getCaptchaProperties();

    @Override
    public Map<String, Object> getProperties() {
        Map<String, Object> properties = super.getProperties();
        HashMap<String, Object> captchaConfig = new HashMap<String, Object>();
        try {
            captchaConfig.put("provider", this.getProvider());
            if (this.getCaptchaProperties() != null && this.getCaptchaProperties().size() > 0) {
                captchaConfig.put(CAPTCHA_CONFIG, this.getCaptchaProperties());
            }
            properties.put(CUSTOM_RECAPTCHA_PROPERTY_WRAPPER, captchaConfig);
        }
        catch (GuideException e) {
            throw new RuntimeException(e);
        }
        return properties;
    }
}

