/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.util;

import com.adobe.cq.forms.core.components.models.form.Field;
import com.adobe.cq.forms.core.components.util.AbstractBaseImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFieldImpl
extends AbstractBaseImpl
implements Field {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFieldImpl.class);
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="readOnly")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    protected Boolean readOnly;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="default")
    @Nullable
    protected Object[] defaultValue;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="fd:emptyValue")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    protected String emptyValue;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="placeholder")
    @Nullable
    protected String placeholder;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="displayFormat")
    @Nullable
    protected String displayFormat;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="fd:customDisplayFormat")
    @Nullable
    protected String customDisplayFormat;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="editFormat")
    @Nullable
    protected String editFormat;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="displayValueExpression")
    @Nullable
    protected String displayValueExpression;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="dataFormat")
    @Nullable
    protected String dataFormat;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="minLength")
    @Nullable
    protected Integer minLength;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="maxLength")
    @Nullable
    protected Integer maxLength;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="minimumDate")
    @Nullable
    protected Date minimumDate;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="maximumDate")
    @Nullable
    protected Date maximumDate;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="minimumDateTime")
    @Nullable
    protected String minimumDateTime;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="maximumDateTime")
    @Nullable
    protected String maximumDateTime;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="maximum")
    @Nullable
    protected Long maximum;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="minimum")
    @Nullable
    protected Long minimum;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="maximum")
    @Nullable
    protected String maximumAsStr;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="minimum")
    @Nullable
    protected String minimumAsStr;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="exclusiveMinimum")
    @Default(booleanValues={false})
    protected boolean exclusiveMinimum;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="exclusiveMaximum")
    @Default(booleanValues={false})
    protected boolean exclusiveMaximum;
    @SlingObject
    private Resource resource;

    @Override
    @Nullable
    public Boolean isReadOnly() {
        return this.readOnly != null ? this.readOnly : Boolean.FALSE;
    }

    @JsonProperty(value="readOnly")
    public Boolean getReadOnlyIfPresent() {
        return this.readOnly;
    }

    @Override
    @Nullable
    public Boolean isRequired() {
        return this.required != null ? this.required : Boolean.FALSE;
    }

    @JsonProperty(value="required")
    public Boolean getRequiredIfPresent() {
        return this.required;
    }

    @Override
    public Object[] getDefault() {
        if (this.defaultValue != null) {
            return Arrays.stream(this.defaultValue).map(p -> {
                if (p instanceof Calendar) {
                    return ((Calendar)p).getTime();
                }
                return p;
            }).toArray();
        }
        return null;
    }

    @Override
    @Nullable
    public String getEmptyValue() {
        if (this.emptyValue == null) {
            return null;
        }
        EmptyValue enumValue = EmptyValue.fromString(this.emptyValue);
        return enumValue != null ? enumValue.getValue() : EmptyValue.EMPTY_STRING.getValue();
    }

    @Override
    @Nullable
    public String getPlaceHolder() {
        return this.translate("placeholder", this.placeholder);
    }

    @Override
    @Nullable
    public String getDisplayFormat() {
        if (this.customDisplayFormat != null) {
            return this.customDisplayFormat;
        }
        return this.displayFormat;
    }

    @Override
    @Nullable
    public String getEditFormat() {
        return this.editFormat;
    }

    @Override
    @Nullable
    public String getDisplayValueExpression() {
        return this.displayValueExpression;
    }

    @Override
    @Nullable
    public String getDataFormat() {
        return this.dataFormat;
    }

    public static enum EmptyValue {
        NULL("null"),
        UNDEFINED("undefined"),
        EMPTY_STRING("");

        private final String value;

        private EmptyValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static EmptyValue fromString(String value) {
            if (value == null) {
                return null;
            }
            for (EmptyValue emptyValue : EmptyValue.values()) {
                if (!emptyValue.getValue().equals(value)) continue;
                return emptyValue;
            }
            return EMPTY_STRING;
        }
    }
}

