/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.forms.core.components.util;

import com.adobe.aemds.guide.model.CustomPropertyInfo;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.cq.forms.core.components.datalayer.FormComponentData;
import com.adobe.cq.forms.core.components.internal.datalayer.ComponentDataImpl;
import com.adobe.cq.forms.core.components.internal.form.ReservedProperties;
import com.adobe.cq.forms.core.components.models.form.BaseConstraint;
import com.adobe.cq.forms.core.components.models.form.FieldType;
import com.adobe.cq.forms.core.components.models.form.FormComponent;
import com.adobe.cq.forms.core.components.models.form.Label;
import com.adobe.cq.forms.core.components.models.form.print.dorapi.DorContainer;
import com.adobe.cq.forms.core.components.util.AbstractComponentImpl;
import com.adobe.cq.wcm.core.components.util.ComponentUtils;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.designer.Style;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractFormComponentImpl
extends AbstractComponentImpl
implements FormComponent {
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="dataRef")
    @Nullable
    protected String dataRef;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="fieldType")
    protected String fieldTypeJcr;
    private FieldType fieldType;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="name")
    @Nullable
    protected String name;
    @ValueMapValue(name="value")
    @Default(values={""})
    protected String value;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="visible")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    protected Boolean visible;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="lang")
    @Nullable
    protected String langJcr;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="unboundFormElement")
    @Nullable
    protected Boolean unboundFormElement;
    @SlingObject
    private Resource resource;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="dorExclusion")
    @Default(booleanValues={false})
    protected boolean dorExclusion;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="dorColspan")
    @Nullable
    protected String dorColspan;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected Style currentStyle;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="fd:viewType")
    @Nullable
    protected String viewType;
    @JsonIgnore
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="dorBindRef")
    @Nullable
    protected String dorBindRef;
    private Boolean dataLayerEnabled;
    private FormComponentData componentData;
    private static final String STATUS_NONE = "none";
    private static final String STATUS_VALID = "valid";
    private static final String STATUS_INVALID = "invalid";
    private static final String RULES_STATUS_PROP_NAME = "validationStatus";
    private static final String NULL_DATA_REF = "null";
    private static final Logger logger = LoggerFactory.getLogger(AbstractFormComponentImpl.class);
    public static final String CUSTOM_DOR_PROPERTY_WRAPPER = "fd:dor";
    public static final String CUSTOM_DOR_CONTAINER_WRAPPER = "dorContainer";
    public static final String CUSTOM_JCR_PATH_PROPERTY_WRAPPER = "fd:path";
    public static final String CUSTOM_RULE_PROPERTY_WRAPPER = "fd:rules";
    private final Predicate<Map.Entry<String, Object>> isEntryNonEmpty = obj -> obj.getValue() instanceof String && ((String)obj.getValue()).length() > 0 || obj.getValue() instanceof String[] && ((String[])obj.getValue()).length > 0;

    @PostConstruct
    protected void initBaseModel() {
        if (StringUtils.isNotEmpty((CharSequence)this.fieldTypeJcr)) {
            this.fieldType = FieldType.fromString(this.fieldTypeJcr);
        }
        if (this.request != null && this.i18n == null) {
            this.i18n = GuideUtils.getI18n(this.request, this.resource);
        }
        if (Boolean.TRUE.equals(this.unboundFormElement)) {
            this.dataRef = NULL_DATA_REF;
        }
        this.getName();
    }

    @Override
    public void setI18n(@Nonnull I18n i18n) {
        this.i18n = i18n;
    }

    @Override
    public void setLang(@Nullable String lang) {
        this.lang = lang;
    }

    @Override
    @Nullable
    public String getLang() {
        return this.langJcr != null ? this.langJcr : this.lang;
    }

    @Override
    @JsonProperty(value="lang")
    public String getLangIfPresent() {
        return this.langJcr;
    }

    public BaseConstraint.Type getType() {
        return null;
    }

    public Label getLabel() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public String getLinkUrl() {
        return null;
    }

    public String getTitle() {
        return null;
    }

    public String getText() {
        return null;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.getDefaultName();
        }
        return this.name;
    }

    protected String getDefaultName() {
        return StringEscapeUtils.escapeHtml4((String)GuideUtils.getGuideName(this.resource));
    }

    @Override
    public String getFieldType() {
        return this.fieldType.getValue();
    }

    protected String getFieldType(@Nonnull FieldType defaultFieldType) {
        if (this.fieldType == null) {
            return defaultFieldType.getValue();
        }
        return this.fieldType.getValue();
    }

    @Override
    @Nullable
    public Boolean isVisible() {
        return this.visible == null || this.visible != false;
    }

    @JsonProperty(value="visible")
    public Boolean getVisibleIfPresent() {
        return this.visible;
    }

    @Override
    @NotNull
    public String getExportedType() {
        if (this.viewType != null) {
            return this.viewType;
        }
        return this.resource.getResourceType();
    }

    @JsonIgnore
    protected boolean getEditMode() {
        String pathInfo;
        boolean matches;
        boolean editMode = false;
        if (this.request != null && this.request.getPathInfo() != null && !(matches = Pattern.matches(".+model.*\\.json$", pathInfo = this.request.getPathInfo()))) {
            editMode = WCMMode.fromRequest((ServletRequest)this.request) == WCMMode.EDIT || WCMMode.fromRequest((ServletRequest)this.request) == WCMMode.DESIGN;
        }
        return editMode;
    }

    @JsonIgnore
    @NotNull
    public Map<String, Object> getCustomLayoutProperties() {
        LinkedHashMap<String, Object> customLayoutProperties = new LinkedHashMap<String, Object>();
        return customLayoutProperties;
    }

    @Override
    @NotNull
    public Map<String, Object> getProperties() {
        List<String> disabledScripts;
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        Map<String, Object> customProperties = this.getCustomProperties();
        if (customProperties.size() > 0) {
            customProperties.forEach(properties::putIfAbsent);
        }
        if (this.getCustomLayoutProperties().size() != 0) {
            properties.put("afs:layout", this.getCustomLayoutProperties());
        }
        if (this.getDorProperties().size() > 0) {
            properties.put(CUSTOM_DOR_PROPERTY_WRAPPER, this.getDorProperties());
        }
        properties.put(CUSTOM_JCR_PATH_PROPERTY_WRAPPER, this.getPath());
        Map<String, Object> rulesProperties = this.getRulesProperties();
        if (rulesProperties.size() > 0) {
            properties.put(CUSTOM_RULE_PROPERTY_WRAPPER, rulesProperties);
        }
        if (!(disabledScripts = this.getDisabledXFAScripts()).isEmpty()) {
            properties.put("fd:disabledXfaScripts", disabledScripts);
        }
        return properties;
    }

    @Override
    @NotNull
    public Map<String, String> getRules() {
        String[] VALID_RULES = new String[]{"description", "enabled", "enum", "enumNames", "exclusiveMaximum", "exclusiveMinimum", "label", "maximum", "minimum", "readOnly", "required", "value", "visible"};
        Predicate<Map.Entry> isRuleNameValid = obj -> Arrays.stream(VALID_RULES).anyMatch(validKey -> validKey.equals(obj.getKey()));
        Predicate<Map.Entry> isRuleValid = this.isEntryNonEmpty.and(isRuleNameValid);
        Resource ruleNode = this.resource.getChild(CUSTOM_RULE_PROPERTY_WRAPPER);
        if (ruleNode != null) {
            ValueMap ruleNodeProps = ruleNode.getValueMap();
            Map<String, String> rules = ruleNodeProps.entrySet().stream().filter(isRuleValid).map(entry -> new AbstractMap.SimpleEntry<String, String>((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return rules;
        }
        return Collections.emptyMap();
    }

    @JsonIgnore
    private Map<String, Object> getRulesProperties() {
        Resource ruleNode = this.resource.getChild(CUSTOM_RULE_PROPERTY_WRAPPER);
        LinkedHashMap<String, Object> customRulesProperties = new LinkedHashMap<String, Object>();
        if (ruleNode == null) {
            logger.debug("No rules node found for resource: {}", (Object)this.resource.getPath());
            return customRulesProperties;
        }
        this.addValidationStatus(ruleNode, customRulesProperties);
        if ("print".equals(this.channel)) {
            this.populateAdditionalRulesProperties(ruleNode, customRulesProperties);
        }
        return customRulesProperties;
    }

    private void addValidationStatus(Resource ruleNode, Map<String, Object> customRulesProperties) {
        String status = this.getRulesStatus(ruleNode);
        if (!STATUS_NONE.equals(status)) {
            customRulesProperties.put(RULES_STATUS_PROP_NAME, status);
        }
    }

    private void populateAdditionalRulesProperties(@NotNull Resource ruleNode, Map<String, Object> customRulesProperties) {
        String[] RULES = new String[]{"fd:formReady", "fd:layoutReady", "fd:docReady", "fd:calc", "fd:init", "fd:validate", "fd:indexChange"};
        ValueMap props = (ValueMap)ruleNode.adaptTo(ValueMap.class);
        if (props != null) {
            Arrays.stream(RULES).forEach(rule -> this.addRuleProperty(props, customRulesProperties, (String)rule));
        }
    }

    private void addRuleProperty(@NotNull ValueMap props, Map<String, Object> customRulesProperties, String rule) {
        Optional<String[]> propertyValue = Optional.ofNullable((String[])props.get(rule, String[].class));
        propertyValue.ifPresent(value -> customRulesProperties.put(rule, value));
    }

    private String getRulesStatus(Resource rulesResource) {
        if (rulesResource == null) {
            return STATUS_NONE;
        }
        ValueMap props = (ValueMap)rulesResource.adaptTo(ValueMap.class);
        if (props == null) {
            return STATUS_NONE;
        }
        String status = (String)props.get(RULES_STATUS_PROP_NAME, (Object)STATUS_NONE);
        if (!(STATUS_NONE.equals(status) || STATUS_VALID.equals(status) || STATUS_INVALID.equals(status))) {
            status = STATUS_INVALID;
        }
        return status;
    }

    private Stream<Map.Entry<String, String[]>> sanitizeEvent(Map.Entry<String, Object> entry) {
        Stream<Map.Entry<String, String[]>> updatedEntry;
        String[] VALID_EVENTS = new String[]{"click", "submit", "initialize", "load", "change", "submitSuccess", "submitError"};
        Predicate<Map.Entry> isEventNameValid = obj -> ((String)obj.getKey()).startsWith("custom_") || Arrays.stream(VALID_EVENTS).anyMatch(validKey -> validKey.equals(obj.getKey()));
        Predicate<Map.Entry> isEventValid = this.isEntryNonEmpty.and(isEventNameValid);
        Object eventValue = entry.getValue();
        String key = entry.getKey();
        if (key.startsWith("custom_")) {
            key = "custom:" + key.substring("custom_".length());
        }
        if (!isEventValid.test(entry)) {
            updatedEntry = Stream.empty();
        } else {
            String[] arrayEventValue = eventValue instanceof String ? new String[]{(String)eventValue} : (String[])eventValue;
            updatedEntry = Stream.of(new AbstractMap.SimpleEntry<String, String[]>(key, arrayEventValue));
        }
        return updatedEntry;
    }

    @Override
    @NotNull
    public Map<String, String[]> getEvents() {
        Resource eventNode = this.resource.getChild("fd:events");
        HashSet<AbstractMap.SimpleEntry<String, String>> eventSet = new HashSet<AbstractMap.SimpleEntry<String, String>>();
        eventSet.add(new AbstractMap.SimpleEntry<String, String>("custom_setProperty", "$event.payload"));
        if (eventNode != null) {
            ValueMap eventNodeProps = eventNode.getValueMap();
            eventSet.addAll(eventNodeProps.entrySet());
        }
        Map<String, String[]> userEvents = eventSet.stream().flatMap(this::sanitizeEvent).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return userEvents;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonSerialize(using=DataRefSerializer.class)
    @Nullable
    public String getDataRef() {
        return this.dataRef;
    }

    @Override
    @JsonIgnore
    public String getPath() {
        if (this.resource != null) {
            return this.resource.getPath();
        }
        return "";
    }

    @Override
    @NotNull
    protected FormComponentData getComponentData() {
        return new ComponentDataImpl((FormComponent)this, this.resource);
    }

    @Override
    @Nullable
    public FormComponentData getData() {
        if (this.componentData == null) {
            if (this.dataLayerEnabled == null) {
                this.dataLayerEnabled = this.getCurrentPage() != null ? Boolean.valueOf(ComponentUtils.isDataLayerEnabled((Resource)this.getCurrentPage().getContentResource())) : Boolean.valueOf(ComponentUtils.isDataLayerEnabled((Resource)this.resource));
            }
            if (this.dataLayerEnabled.booleanValue()) {
                this.componentData = this.getComponentData();
            }
        }
        return this.componentData;
    }

    private boolean isAllowedType(Object value) {
        return value instanceof String || value instanceof String[] || value instanceof Boolean || value instanceof Boolean[] || value instanceof Calendar || value instanceof Calendar[] || value instanceof BigDecimal || value instanceof BigDecimal[] || value instanceof Long || value instanceof Long[];
    }

    private Map<String, Object> getCustomProperties() {
        Map<String, String> templateBasedCustomProperties;
        HashMap<String, Object> customProperties = new HashMap<String, Object>();
        List<String> excludedPrefixes = Arrays.asList("fd:", "jcr:", "sling:");
        Set reservedProperties = ReservedProperties.getReservedProperties();
        ValueMap resourceMap = this.resource.getValueMap();
        Map<String, Object> nodeBasedCustomProperties = resourceMap.entrySet().stream().filter(entry -> this.isAllowedType(entry.getValue()) && !reservedProperties.contains(entry.getKey()) && excludedPrefixes.stream().noneMatch(prefix -> ((String)entry.getKey()).startsWith((String)prefix))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        nodeBasedCustomProperties.forEach(customProperties::putIfAbsent);
        try {
            templateBasedCustomProperties = Optional.ofNullable((CustomPropertyInfo)this.resource.adaptTo(CustomPropertyInfo.class)).map(CustomPropertyInfo::getProperties).orElse(Collections.emptyMap());
        }
        catch (NoClassDefFoundError e) {
            logger.info("CustomPropertyInfo class not found. This feature is available in the latest Forms addon.");
            templateBasedCustomProperties = Collections.emptyMap();
        }
        if (!templateBasedCustomProperties.isEmpty()) {
            templateBasedCustomProperties.forEach(customProperties::putIfAbsent);
        }
        return customProperties;
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getDorProperties() {
        Map<String, Object> dorContainer;
        LinkedHashMap<String, Object> customDorProperties = new LinkedHashMap<String, Object>();
        customDorProperties.put("dorExclusion", this.dorExclusion);
        if (this.dorColspan != null) {
            customDorProperties.put("dorColspan", this.dorColspan);
        }
        if (this.dorBindRef != null) {
            customDorProperties.put("dorBindRef", this.dorBindRef);
        }
        if ((dorContainer = this.getDorContainer()) != null) {
            customDorProperties.put(CUSTOM_DOR_CONTAINER_WRAPPER, dorContainer);
        }
        return customDorProperties;
    }

    private List<String> getDisabledXFAScripts() {
        HashSet<String> disabledScripts = new HashSet<String>();
        String xfaScripts = (String)this.resource.getValueMap().get("fd:xfaScripts", (Object)"");
        if (StringUtils.isNotEmpty((CharSequence)xfaScripts)) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                ArrayNode node = (ArrayNode)mapper.readTree(xfaScripts);
                for (JsonNode jsonNode : node) {
                    if (!jsonNode.has("disabled") || !jsonNode.get("disabled").asBoolean()) continue;
                    disabledScripts.add(jsonNode.get("activity").asText());
                }
            }
            catch (IOException e) {
                logger.error("Error while parsing xfaScripts {} {}", (Object)e, (Object)this.resource.getPath());
            }
        }
        return new ArrayList<String>(disabledScripts);
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getDorContainer() {
        Resource dorContainerResource;
        if ("print".equals(this.channel) && this.resource != null && (dorContainerResource = this.resource.getChild("fd:dorContainer")) != null) {
            DorContainer dorContainer = (DorContainer)dorContainerResource.adaptTo(DorContainer.class);
            ObjectMapper objectMapper = new ObjectMapper();
            if (dorContainer != null) {
                return (Map)objectMapper.convertValue((Object)dorContainer, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
        }
        return null;
    }

    private static class DataRefSerializer
    extends JsonSerializer<String> {
        private DataRefSerializer() {
        }

        public void serialize(String s, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (AbstractFormComponentImpl.NULL_DATA_REF.equals(s)) {
                jsonGenerator.writeString((String)null);
            } else {
                jsonGenerator.writeString(s);
            }
        }

        public boolean isEmpty(SerializerProvider provider, String value) {
            return StringUtils.isEmpty((CharSequence)value);
        }
    }
}

