/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.output.api;

import com.adobe.aemfd.docmanager.Document;
import com.adobe.fd.output.api.RenderType;

public class PrintConfig {
    public static final PrintConfig HP_PCL_5e = new PrintConfig("hppcl5e.xdc", RenderType.PCL);
    public static final PrintConfig GenericColor_PCL_5c = new PrintConfig("hppcl5c.xdc", RenderType.PCL);
    public static final PrintConfig PS_PLAIN = new PrintConfig("ps_plain.xdc", RenderType.PostScript);
    public static final PrintConfig Generic_PS_L3 = new PrintConfig("ps_plain_level3.xdc", RenderType.PostScript);
    public static final PrintConfig ZPL300 = new PrintConfig("zpl300.xdc", RenderType.ZPL);
    public static final PrintConfig ZPL600 = new PrintConfig("zpl600.xdc", RenderType.ZPL);
    public static final PrintConfig IPL300 = new PrintConfig("ipl300.xdc", RenderType.IPL);
    public static final PrintConfig IPL400 = new PrintConfig("ipl400.xdc", RenderType.IPL);
    public static final PrintConfig TPCL305 = new PrintConfig("tpcl305.xdc", RenderType.TPCL);
    public static final PrintConfig TPCL600 = new PrintConfig("tpcl600.xdc", RenderType.TPCL);
    public static final PrintConfig DPL300 = new PrintConfig("dpl300.xdc", RenderType.DPL);
    public static final PrintConfig DPL406 = new PrintConfig("dpl406.xdc", RenderType.DPL);
    public static final PrintConfig DPL600 = new PrintConfig("dpl600.xdc", RenderType.DPL);
    private RenderType renderType;
    private String xdcUri;
    private Document xdc;

    protected PrintConfig(String xdcUri, RenderType renderType) {
        this.xdcUri = xdcUri;
        this.renderType = renderType;
    }

    private PrintConfig(Document xdc, RenderType renderType) {
        this.xdc = xdc;
        this.renderType = renderType;
    }

    private PrintConfig() {
    }

    public static PrintConfig Custom(String xdcUri, RenderType renderType) {
        if (xdcUri == null || renderType == null) {
            throw new IllegalArgumentException("Invalid XDC URI or render type.");
        }
        return new PrintConfig(xdcUri, renderType);
    }

    public static PrintConfig Custom(Document xdc, RenderType renderType) {
        if (xdc == null || renderType == null) {
            throw new IllegalArgumentException("Invalid XDC document or render type.");
        }
        return new PrintConfig(xdc, renderType);
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public String getXdcUri() {
        return this.xdcUri;
    }

    public Document getXdc() {
        return this.xdc;
    }
}

