/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.signatures.pki.client.types.prefs;

import com.adobe.fd.signatures.pki.client.types.common.RevocationCheckStyle;
import com.adobe.fd.signatures.pki.client.types.prefs.PreferencesMap;
import com.adobe.fd.signatures.pki.client.types.prefs.TransportPreferences;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;

public class TransportPreferencesImpl
extends PreferencesMap
implements TransportPreferences {
    private static final long serialVersionUID = -7520020114995580824L;
    private static final String proxyHostStr = "proxyHost";
    private static final String proxyPortStr = "proxyPort";
    private static final Integer proxyPort_Default = new Integer(80);
    private static final String proxyUsernameStr = "proxyUsername";
    private static final String proxyPasswordStr = "proxyPassword";
    private static final String maxDownloadLimitStr = "maxDownloadLimit";
    private static final Integer maxDownloadLimit_Default = new Integer(16);
    private static final String connectionTimeoutStr = "connectionTimeout";
    private static final Integer connectionTimeout_Default = new Integer(5);
    private static final String socketTimeoutStr = "socketTimeout";
    private static final Integer socketTimeout_Default = new Integer(30);
    private static final String disableTransportStr = "disableTransport";
    private static final Boolean disableTransport_default = new Boolean(false);
    private static final String sslRevCheckStr = "sslRevCheck";
    private static final RevocationCheckStyle sslRevCheck_default = RevocationCheckStyle.BestEffort;

    public TransportPreferencesImpl() {
        this.put(proxyPortStr, (Object)proxyPort_Default);
        this.put(maxDownloadLimitStr, (Object)maxDownloadLimit_Default);
        this.put(connectionTimeoutStr, (Object)connectionTimeout_Default);
        this.put(socketTimeoutStr, (Object)socketTimeout_Default);
        this.put(disableTransportStr, (Object)disableTransport_default);
        this.put(sslRevCheckStr, (Object)sslRevCheck_default);
    }

    @Override
    protected Object getPrefValueFromString(String prefName, String value) {
        if (prefName.equalsIgnoreCase(maxDownloadLimitStr) || prefName.equalsIgnoreCase(connectionTimeoutStr) || prefName.equalsIgnoreCase(socketTimeoutStr) || prefName.equalsIgnoreCase(proxyPortStr)) {
            return new Integer(value);
        }
        if (prefName.equalsIgnoreCase(proxyHostStr) || prefName.equalsIgnoreCase(proxyUsernameStr) || prefName.equalsIgnoreCase(proxyPasswordStr)) {
            return value.trim().length() != 0 ? value.trim() : null;
        }
        if (prefName.equalsIgnoreCase(disableTransportStr)) {
            return new Boolean(value);
        }
        if (prefName.equalsIgnoreCase(sslRevCheckStr)) {
            return RevocationCheckStyle.getValueFromString(value);
        }
        return value;
    }

    @Override
    public PreferencesMap newInstance() {
        return new TransportPreferencesImpl();
    }

    @Override
    protected PreferencesMap createChild(String myKey) {
        return null;
    }

    @Override
    @JsonGetter(value="connectionTimeout")
    public int getConnectionTimeout() {
        return (Integer)this.get(connectionTimeoutStr);
    }

    @JsonSetter(value="connectionTimeout")
    public void setConnectionTimeout(int connectionTimeout) {
        this.put(connectionTimeoutStr, (Object)connectionTimeout);
    }

    @Override
    @JsonGetter(value="maxDownloadLimit")
    public int getMaxDownloadLimit() {
        return (Integer)this.get(maxDownloadLimitStr);
    }

    @JsonSetter(value="maxDownloadLimit")
    public void setMaxDownloadLimit(int maxDownloadLimit) {
        this.put(maxDownloadLimitStr, (Object)maxDownloadLimit);
    }

    @Override
    @JsonGetter(value="proxyHost")
    public String getProxyHost() {
        return (String)this.get(proxyHostStr);
    }

    @JsonSetter(value="proxyHost")
    public void setProxyHost(String proxyHost) {
        this.put(proxyHostStr, (Object)proxyHost);
    }

    @Override
    @JsonGetter(value="proxyPort")
    public int getProxyPort() {
        return (Integer)this.get(proxyPortStr);
    }

    @JsonSetter(value="proxyPort")
    public void setProxyPort(int proxyPort) {
        this.put(proxyPortStr, (Object)proxyPort);
    }

    @Override
    @JsonGetter(value="proxyPassword")
    public String getProxyPassword() {
        return (String)this.get(proxyPasswordStr);
    }

    @JsonSetter(value="proxyPassword")
    public void setProxyPassword(String proxyPassword) {
        this.put(proxyPasswordStr, (Object)proxyPassword);
    }

    @Override
    @JsonGetter(value="proxyUsername")
    public String getProxyUsername() {
        return (String)this.get(proxyUsernameStr);
    }

    @JsonSetter(value="proxyUsername")
    public void setProxyUsername(String proxyUsername) {
        this.put(proxyUsernameStr, (Object)proxyUsername);
    }

    @Override
    @JsonGetter(value="socketTimeout")
    public int getSocketTimeout() {
        return (Integer)this.get(socketTimeoutStr);
    }

    @JsonSetter(value="socketTimeout")
    public void setSocketTimeout(int socketTimeout) {
        this.put(socketTimeoutStr, (Object)socketTimeout);
    }

    @Override
    @JsonGetter(value="disableTransport")
    public boolean isTransportDisabled() {
        return (Boolean)this.get(disableTransportStr);
    }

    @JsonSetter(value="disableTransport")
    public void setTransportDisabled(boolean isDisabled) {
        this.put(disableTransportStr, (Object)new Boolean(isDisabled));
    }

    @Override
    @JsonGetter(value="sslRevCheck")
    public RevocationCheckStyle getSSLRevCheckStyle() {
        return (RevocationCheckStyle)((Object)this.get(sslRevCheckStr));
    }

    @JsonSetter(value="sslRevCheck")
    public void setSSLRevCheckStyle(RevocationCheckStyle style) {
        this.put(sslRevCheckStr, (Object)style);
    }
}

