/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.sites.ui.renderconditions;

import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.rendercondition.RenderCondition;
import com.adobe.granite.ui.components.rendercondition.SimpleRenderCondition;
import com.day.cq.security.util.CqActions;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.Template;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=cq/gui/components/renderconditions/canedittemplate", "sling.servlet.methods=GET"})
public class CanEditTemplateRenderCondition
extends SlingSafeMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(CanEditTemplateRenderCondition.class);
    @Reference
    private ExpressionResolver expressionResolver;

    @Override
    protected void doGet(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException, IOException {
        Template template;
        if (this.expressionResolver == null) {
            return;
        }
        ResourceResolver resourceResolver = request.getResourceResolver();
        ExpressionHelper ex = new ExpressionHelper(this.expressionResolver, request);
        Config rcCfg = new Config(request.getResource());
        String path = ex.getString(rcCfg.get("path", String.class));
        boolean canEditTemplate = false;
        Page targetPage = null;
        if (path != null) {
            Resource pageResource = resourceResolver.resolve(path);
            targetPage = pageResource.adaptTo(Page.class);
        }
        if (targetPage != null && (template = targetPage.getTemplate()) != null && template.hasStructureSupport()) {
            try {
                Session session = resourceResolver.adaptTo(Session.class);
                CqActions cqActions = new CqActions(session);
                Collection<String> allowedActions = cqActions.getAllowedActions(template.getPath(), null);
                canEditTemplate = allowedActions.contains("modify");
            }
            catch (RepositoryException e) {
                this.log.error("Unable to retrieve allowed user actions", e);
            }
        }
        request.setAttribute(RenderCondition.class.getName(), new SimpleRenderCondition(canEditTemplate));
    }
}

