/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.models.datalayer.builder;

import com.adobe.cq.wcm.core.components.internal.models.v1.datalayer.builder.DataLayerSupplierImpl;
import com.adobe.cq.wcm.core.components.models.datalayer.AssetData;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.ContainerData;
import com.adobe.cq.wcm.core.components.models.datalayer.ImageData;
import com.adobe.cq.wcm.core.components.models.datalayer.PageData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.AssetDataBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.ComponentDataBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.ComponentDataLayerExtender;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.ContainerDataBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerSupplier;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.IdRequiredDataBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.ImageComponentDataBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.PageDataBuilder;
import com.day.cq.dam.api.Asset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;

public final class DataLayerBuilder {
    private DataLayerBuilder() {
    }

    public static IdRequiredDataBuilder<ComponentDataBuilder, ComponentData> forComponent() {
        return new IdRequiredDataBuilder<ComponentDataBuilder, ComponentData>(new ComponentDataBuilder(DataLayerSupplier.EMPTY_SUPPLIER));
    }

    public static IdRequiredDataBuilder<ContainerDataBuilder, ContainerData> forContainer() {
        return new IdRequiredDataBuilder<ContainerDataBuilder, ContainerData>(new ContainerDataBuilder(DataLayerSupplier.EMPTY_SUPPLIER));
    }

    public static IdRequiredDataBuilder<ImageComponentDataBuilder, ImageData> forImageComponent() {
        return new IdRequiredDataBuilder<ImageComponentDataBuilder, ImageData>(new ImageComponentDataBuilder(DataLayerSupplier.EMPTY_SUPPLIER));
    }

    public static IdRequiredDataBuilder<PageDataBuilder, PageData> forPage() {
        return new IdRequiredDataBuilder<PageDataBuilder, PageData>(new PageDataBuilder(DataLayerSupplier.EMPTY_SUPPLIER));
    }

    public static IdRequiredDataBuilder<AssetDataBuilder, AssetData> forAsset() {
        return new IdRequiredDataBuilder<AssetDataBuilder, AssetData>(new AssetDataBuilder(DataLayerSupplier.EMPTY_SUPPLIER));
    }

    public static AssetDataBuilder forAsset(@NotNull Asset asset) {
        return DataLayerBuilder.forAsset().withId(asset::getID).withFormat(asset::getMimeType).withUrl(asset::getPath).withLastModifiedDate(() -> new Date(Optional.of(asset.getLastModified()).filter(lastMod -> lastMod > 0L).orElseGet(() -> Optional.ofNullable(asset.adaptTo(ValueMap.class)).map(vm -> (Calendar)((Object)vm.get("jcr:created", Calendar.class))).map(Calendar::getTimeInMillis).orElse(0L)))).withTags(() -> (String[])Optional.ofNullable(asset.getMetadataValueFromJcr("cq:tags")).filter(StringUtils::isNotEmpty).map(tagsValue -> tagsValue.split(",")).map(Arrays::stream).orElseGet(Stream::empty).filter(StringUtils::isNotEmpty).toArray(String[]::new));
    }

    public static AssetDataBuilder extending(@NotNull AssetData assetData) {
        return new AssetDataBuilder(DataLayerSupplierImpl.extend((AssetData)assetData));
    }

    public static ComponentDataLayerExtender extending(@NotNull ComponentData componentData) {
        return new ComponentDataLayerExtender(componentData);
    }
}

