/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFByteArray;

class Index {
    public final CFFByteArray data;
    public final int offset;
    protected final int size;
    protected final int entryCount;
    protected final int[] entryOffsets;

    Index(CFFByteArray data, int offset) throws InvalidFontException, UnsupportedFontException {
        this.data = data;
        this.offset = offset;
        this.entryCount = data.getcard16(offset + 0);
        this.entryOffsets = new int[this.entryCount + 1];
        if (this.entryCount == 0) {
            this.size = 2;
            return;
        }
        int offSize = data.getOffSize(offset + 2);
        int firstDataByteOffset = offset + 3 + offSize * (this.entryCount + 1);
        for (int i = 0; i < this.entryCount + 1; ++i) {
            this.entryOffsets[i] = firstDataByteOffset + data.getOffset(offset + 3 + offSize * i, offSize, "INDEX offset too big") - 1;
        }
        this.size = this.entryOffsets[this.entryCount] - offset;
    }

    public int size() {
        return this.size;
    }

    public int getCount() {
        return this.entryCount;
    }

    public int offsetOf(int entry) {
        return this.entryOffsets[entry];
    }

    public int offsetFollowing(int entry) {
        return this.entryOffsets[entry + 1];
    }

    public int sizeOf(int entry) {
        return this.entryOffsets[entry + 1] - this.entryOffsets[entry];
    }

    public void stream(CFFByteArray.CFFByteArrayBuilder bb) throws InvalidFontException {
        bb.addBytes(this.data, this.offset, this.size);
    }

    public static Cursor startIndex(CFFByteArray.CFFByteArrayBuilder bb, int n) {
        if (n == 0) {
            bb.addCard16(0);
            return null;
        }
        bb.addCard16(n);
        bb.addCard8(4);
        bb.addCard32(1);
        Cursor cursor = new Cursor();
        cursor.offset = bb.getSize();
        for (int i = 0; i < n; ++i) {
            bb.addCard32(1);
        }
        cursor.base = bb.getSize() - 1;
        return cursor;
    }

    public static Cursor elementEntered(CFFByteArray.CFFByteArrayBuilder bb, Cursor cursor) {
        bb.setCard32(cursor.offset, bb.getSize() - cursor.base);
        cursor.offset += 4;
        return cursor;
    }

    public static class Cursor {
        int base;
        int offset;
    }
}

