/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.postscript.Token;
import com.adobe.fontengine.font.postscript.TokenType;
import com.adobe.fontengine.font.postscript.Tokenizer;
import com.adobe.fontengine.font.type1.MetricFile;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;

final class AFM
extends MetricFile {
    private String fontName;
    private static final byte[] kFontName = new byte[]{70, 111, 110, 116, 78, 97, 109, 101};
    private static final byte[][] kOptionalTokens = new byte[][]{{83, 116, 97, 114, 116, 75, 101, 114, 110, 80, 97, 105, 114, 115}, {83, 116, 97, 114, 116, 75, 101, 114, 110, 80, 97, 105, 114, 115, 48}};
    private static final byte[][] kKernPairStart = new byte[][]{{75, 80}, {75, 80, 88}};
    private final KernPair[] kernPairs;
    private static final Comparator kpComp = new Comparator(){

        public int compare(Object left, Object right) {
            KernPair leftKP = (KernPair)left;
            KernPair rightKP = (KernPair)right;
            int compRes = leftKP.leftGName.compareTo(rightKP.leftGName);
            if (compRes < 0) {
                return -1;
            }
            if (compRes > 0) {
                return 1;
            }
            compRes = leftKP.rightGName.compareTo(rightKP.rightGName);
            if (compRes < 0) {
                return -1;
            }
            if (compRes > 0) {
                return 1;
            }
            return 0;
        }
    };

    @Override
    public double getKernValue(String leftGlyphName, String rightGlyphName) {
        KernPair thisPair = new KernPair(leftGlyphName, rightGlyphName, 0.0);
        int res = Arrays.binarySearch(this.kernPairs, thisPair, kpComp);
        if (res >= 0) {
            return this.kernPairs[res].kernAmount;
        }
        return 0.0;
    }

    @Override
    public String getFamilyName() {
        return null;
    }

    @Override
    public String getFontName() {
        return this.fontName;
    }

    @Override
    public int getWeight() {
        return 0;
    }

    private AFM(String fontName, KernPair[] kernPairs, URL url) throws IOException, InvalidFontException {
        super(url);
        this.fontName = fontName;
        Arrays.sort(kernPairs, kpComp);
        this.kernPairs = kernPairs;
    }

    static KernPair[] parseKernPairs(Tokenizer tokenizer, int numKernPairs) throws IOException, InvalidFontException {
        KernPair[] kernPairs = new KernPair[numKernPairs];
        for (int i = 0; i < numKernPairs; ++i) {
            double kernVal;
            byte[] tokenFound = tokenizer.findOptionalTokensAtStartOfLine(kKernPairStart);
            if (tokenFound == null) {
                return new KernPair[0];
            }
            Token token = tokenizer.getNextPSToken();
            if (token.tokenType != TokenType.kOPERATOR) {
                return new KernPair[0];
            }
            String leftGName = token.stringTokenToString(0, token.tokenLength);
            token = tokenizer.getNextPSToken();
            if (token.tokenType != TokenType.kOPERATOR) {
                return new KernPair[0];
            }
            String rightGName = token.stringTokenToString(0, token.tokenLength);
            token = tokenizer.getNextPSToken();
            if (token.tokenType == TokenType.kINTEGER) {
                kernVal = token.convertInteger(0);
            } else if (token.tokenType == TokenType.kREAL) {
                kernVal = Double.parseDouble(new String(token.buff, 0, token.tokenLength));
            } else {
                return new KernPair[0];
            }
            kernPairs[i] = new KernPair(leftGName, rightGName, kernVal);
        }
        return kernPairs;
    }

    static MetricFile createAFM(FontInputStream str, URL url) throws IOException, InvalidFontException {
        KernPair[] kernPairs = null;
        Tokenizer tokenizer = new Tokenizer(str);
        tokenizer.findToken(kFontName);
        Token token = tokenizer.getNextPSToken();
        char[] chars = new char[token.tokenLength];
        for (int i = 0; i < token.tokenLength; ++i) {
            chars[i] = (char)token.buff[i];
        }
        String fontName = new String(chars);
        byte[] foundToken = tokenizer.findOptionalTokensAtStartOfLine(kOptionalTokens);
        if (foundToken != null) {
            int numKernPairs;
            token = tokenizer.getNextPSToken();
            if (token.tokenType == TokenType.kINTEGER && (numKernPairs = token.convertInteger(0)) > 0) {
                kernPairs = AFM.parseKernPairs(tokenizer, numKernPairs);
            }
        }
        if (kernPairs == null) {
            kernPairs = new KernPair[]{};
        }
        return new AFM(fontName, kernPairs, url);
    }

    private static class KernPair {
        final String leftGName;
        final String rightGName;
        final double kernAmount;

        KernPair(String left, String right, double kernAmount) {
            this.leftGName = left;
            this.rightGName = right;
            this.kernAmount = kernAmount;
        }
    }
}

