/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement;

import com.adobe.fontengine.font.Base14;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.FontFactory;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.fontmanagement.URLFont;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;

public final class Base14Font
extends URLFont {
    static final long serialVersionUID = 1L;
    private final String mBase14CSSName;
    private final String mBase14PSName;
    private static final HashMap<String, HashMap<String, Object>> mBase14DescCache;

    public Base14Font(String resourceName, String base14CSSName, String base14PSName) {
        super(Base14.class.getResource(resourceName), 0);
        this.mBase14CSSName = base14CSSName;
        this.mBase14PSName = base14PSName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized FontData retrieveFontData() throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        FontData font;
        block5: {
            font = null;
            try {
                font = (FontData)this.fontRef.get();
                if (font != null) break block5;
                FontInputStream stream = new FontInputStream(this.outlineFileURL.openStream());
                try {
                    OpenTypeFont[] arr = FontFactory.load(stream, this.mBase14CSSName, this.mBase14PSName);
                    font = arr[this.index];
                    this.fontRef = new SoftReference<FontData>(font);
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new FontLoadingException(e);
            }
        }
        return font;
    }

    @Override
    public String getCanonicalPath() {
        return null;
    }

    @Override
    public long getLength() {
        return 0L;
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public Object getCachedFontDescription(String key) {
        if (mBase14DescCache == null) {
            return null;
        }
        HashMap<String, Object> descMap = mBase14DescCache.get(this.mBase14PSName);
        if (descMap == null) {
            return null;
        }
        return descMap.get(key);
    }

    public Iterator<String> getCachedFontDescriptionIterator() {
        return null;
    }

    @Override
    public void setCachedFontDescription(String key, Object value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream inStm = null;
        ObjectInputStream objInStm = null;
        HashMap base14DescCache = null;
        try {
            inStm = Base14.class.getResourceAsStream("Base14Cache");
            objInStm = new ObjectInputStream(inStm);
            try {
                base14DescCache = (HashMap)objInStm.readObject();
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (objInStm != null) {
                    objInStm.close();
                } else if (inStm != null) {
                    inStm.close();
                }
            }
            catch (Exception e) {}
        }
        mBase14DescCache = base14DescCache;
    }
}

