/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crypto;

import com.adobe.granite.crypto.CryptoException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import javax.security.auth.x500.X500Principal;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface CryptoSupport {
    public static final String NAME = "com.adobe.granite.crypto.CryptoSupport";

    public byte[] encrypt(byte[] var1) throws CryptoException;

    public byte[] decrypt(byte[] var1) throws CryptoException;

    public byte[] encrypt(byte[] var1, byte[] var2) throws CryptoException;

    public byte[] decrypt(byte[] var1, byte[] var2) throws CryptoException;

    public boolean isProtected(String var1);

    public String protect(String var1) throws CryptoException;

    public String unprotect(String var1) throws CryptoException;

    public String protect(byte[] var1, String var2) throws CryptoException;

    public String unprotect(byte[] var1, String var2) throws CryptoException;

    public byte[] wrapKey(byte[] var1, byte[] var2) throws CryptoException;

    public byte[] wrapKey(byte[] var1) throws CryptoException;

    public byte[] unwrapKey(byte[] var1, byte[] var2) throws CryptoException;

    public byte[] unwrapKey(byte[] var1) throws CryptoException;

    public void nextRandomBytes(byte[] var1) throws CryptoException;

    public byte[] hmac_sha256(byte[] var1, byte[] var2) throws CryptoException;

    public byte[] hmac_sha256(byte[] var1) throws CryptoException;

    public KeyPair createKeyPair(String var1) throws CryptoException;

    public Certificate sign(Certificate var1, KeyPair var2, X500Principal var3, long var4, long var6) throws CryptoException;

    public byte[] sign(byte[] var1, PrivateKey var2, String var3) throws CryptoException;

    public boolean verify(byte[] var1, byte[] var2, PublicKey var3, String var4) throws CryptoException;
}

