/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletRequest;

public class ExpressionCustomizer {
    private static final String KEY_CACHE = ExpressionCustomizer.class.getName();
    private Map<String, Object> variables = new HashMap<String, Object>();

    @Nonnull
    public static ExpressionCustomizer from(@Nonnull ServletRequest request) {
        ExpressionCustomizer instance = (ExpressionCustomizer)request.getAttribute(KEY_CACHE);
        if (instance == null) {
            instance = new ExpressionCustomizer();
            request.setAttribute(KEY_CACHE, instance);
        }
        return instance;
    }

    @CheckForNull
    public Object getVariable(@Nonnull String name) {
        return this.variables.get(name);
    }

    public void setVariable(@Nonnull String name, @Nonnull Object value) {
        this.variables.put(name, value);
    }

    public boolean hasVariable(@Nonnull String name) {
        return this.variables.containsKey(name);
    }
}

