/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.formcalc;

import com.adobe.xfa.formcalc.Builtins;
import com.adobe.xfa.formcalc.CalcException;
import com.adobe.xfa.formcalc.CalcParser;
import com.adobe.xfa.formcalc.CalcSymbol;
import com.adobe.xfa.ut.ISODate;
import com.adobe.xfa.ut.ISOTime;
import com.adobe.xfa.ut.LcData;
import com.adobe.xfa.ut.LcDate;
import com.adobe.xfa.ut.LcTime;

final class BuiltinDate {
    private BuiltinDate() {
    }

    static void Date(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.maxArgs(nArgs, 0);
                LcDate date = new LcDate("", 30);
                oRetSym = new CalcSymbol(date.getDays());
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Date2Num(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 3);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                String s = oParser.getString(oArgSym[0]);
                String f = nArgs > 1 ? oParser.getString(oArgSym[1]) : "MMM D, YYYY";
                String l = nArgs > 2 ? oParser.getString(oArgSym[2]) : oParser.msLocaleName;
                LcDate date = new LcDate(s, f, l, 30);
                oRetSym = new CalcSymbol(date.getDays());
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Num2Date(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 3);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                int nDays = (int)oParser.getNumeric(oArgSym[0]);
                String f = nArgs > 1 ? oParser.getString(oArgSym[1]) : "MMM D, YYYY";
                String l = nArgs > 2 ? oParser.getString(oArgSym[2]) : oParser.msLocaleName;
                LcDate date = new LcDate(nDays, l, 30);
                oRetSym = new CalcSymbol(date.format(f));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void DateFmt(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 0);
                Builtins.maxArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                int n = nArgs > 0 ? (int)oParser.getNumeric(oArgSym[0]) : 0;
                String l = nArgs > 1 ? oParser.getString(oArgSym[1]) : oParser.msLocaleName;
                oRetSym = new CalcSymbol(LcDate.getDateFormat(n, l));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void DateTimeFmt(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 0);
                Builtins.maxArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                int n = nArgs > 0 ? (int)oParser.getNumeric(oArgSym[0]) : 0;
                String l = nArgs > 1 ? oParser.getString(oArgSym[1]) : oParser.msLocaleName;
                LcData data = new LcData(l);
                oRetSym = new CalcSymbol(data.getDateTimeFormat(n, 1));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void LocalDateFmt(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 0);
                Builtins.maxArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                int n = nArgs > 0 ? (int)oParser.getNumeric(oArgSym[0]) : 0;
                String l = nArgs > 1 ? oParser.getString(oArgSym[1]) : oParser.msLocaleName;
                oRetSym = new CalcSymbol(LcDate.getLocalDateFormat(n, l));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void IsoDate2Num(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                String s = oParser.getString(oArgSym[0]);
                ISODate isoDate = new ISODate(s, "");
                oRetSym = new CalcSymbol(isoDate.getDays());
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Time(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.maxArgs(nArgs, 0);
                LcTime time = new LcTime("");
                oRetSym = new CalcSymbol(time.getMillis());
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Time2Num(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 3);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                String s = oParser.getString(oArgSym[0]);
                String f = nArgs > 1 ? oParser.getString(oArgSym[1]) : "h:MM:SS A";
                String l = nArgs > 2 ? oParser.getString(oArgSym[2]) : oParser.msLocaleName;
                LcTime time = new LcTime(s, f, l);
                oRetSym = new CalcSymbol(time.getMillis());
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void IsoTime2Num(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                String s = oParser.getString(oArgSym[0]);
                ISOTime isoTime = new ISOTime(s, "");
                oRetSym = new CalcSymbol(isoTime.getMillis());
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Num2Time(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 3);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                int nMillis = (int)oParser.getNumeric(oArgSym[0]);
                String f = nArgs > 1 ? oParser.getString(oArgSym[1]) : "h:MM:SS A";
                String l = nArgs > 2 ? oParser.getString(oArgSym[2]) : oParser.msLocaleName;
                LcTime time = new LcTime(nMillis, l);
                time.setLocalTime();
                oRetSym = new CalcSymbol(time.format(f));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Num2GmTime(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 3);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                int nMillis = (int)oParser.getNumeric(oArgSym[0]);
                String f = nArgs > 1 ? oParser.getString(oArgSym[1]) : "h:MM:SS A";
                String l = nArgs > 2 ? oParser.getString(oArgSym[2]) : oParser.msLocaleName;
                LcTime time = new LcTime(nMillis, l);
                oRetSym = new CalcSymbol(time.format(f));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void TimeFmt(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 0);
                Builtins.maxArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                int n = nArgs > 0 ? (int)oParser.getNumeric(oArgSym[0]) : 0;
                String l = nArgs > 1 ? oParser.getString(oArgSym[1]) : oParser.msLocaleName;
                oRetSym = new CalcSymbol(LcTime.getTimeFormat(n, l));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void LocalTimeFmt(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 0);
                Builtins.maxArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                int n = nArgs > 0 ? (int)oParser.getNumeric(oArgSym[0]) : 0;
                String l = nArgs > 1 ? oParser.getString(oArgSym[1]) : oParser.msLocaleName;
                oRetSym = new CalcSymbol(LcTime.getLocalTimeFormat(n, l));
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }
}

