/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.gfx.GFXColour;
import com.adobe.xfa.ut.Storage;

class DrawSelection {
    private final Storage<Clip> moClips = new Storage();

    DrawSelection() {
    }

    void addClip(float oLeft, float oRight, GFXColour oFG, GFXColour oBG, boolean bTransparent) {
        Clip oPrev;
        float oSelStart = oLeft;
        float oSelEnd = oRight;
        if (oSelStart == oSelEnd) {
            return;
        }
        if (oSelStart > oSelEnd) {
            float oSwap = oSelStart;
            oSelStart = oSelEnd;
            oSelEnd = oSwap;
        }
        boolean bReplace = false;
        if (this.moClips.size() > 0) {
            oPrev = this.getLastClip();
            if (oPrev.moFG == oFG && oPrev.moBG == oBG && oPrev.moRight >= oSelStart) {
                bReplace = true;
            }
        }
        if (bReplace) {
            oPrev = this.getLastClip();
            if (oSelEnd > oPrev.moRight) {
                oPrev.moRight = oSelEnd;
            }
        } else {
            Clip oClip = new Clip();
            oClip.moLeft = oSelStart;
            oClip.moRight = oSelEnd;
            oClip.moFG = oFG;
            oClip.moBG = oBG;
            oClip.mbTransparent = bTransparent;
            this.moClips.add(oClip);
        }
    }

    int getClipCount() {
        return this.moClips.size();
    }

    Clip getClip(int nIndex) {
        return (Clip)this.moClips.get(nIndex);
    }

    Clip getLastClip() {
        if (this.moClips.size() == 0) {
            return null;
        }
        return this.getClip(this.moClips.size() - 1);
    }

    static class Clip {
        float moLeft;
        float moRight;
        GFXColour moFG;
        GFXColour moBG;
        boolean mbTransparent;

        Clip() {
        }
    }
}

