/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.Pkg;
import com.adobe.xfa.text.StrItem;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextGfxSource;
import com.adobe.xfa.text.markup.MarkupOut;

class StrAttr
extends StrItem {
    private int meState;
    private TextAttr mpoAttr;

    StrAttr() {
        super(1);
        this.meState = 0;
    }

    StrAttr(TextAttr poNewAttr) {
        this(poNewAttr, null, 0);
    }

    StrAttr(TextAttr poNewAttr, TextGfxSource poGfxSource) {
        this(poNewAttr, poGfxSource, 0);
    }

    StrAttr(TextAttr poNewAttr, TextGfxSource poGfxSource, int eState) {
        super(1);
        this.meState = eState;
        this.connectToAttr(poNewAttr, poGfxSource);
    }

    @Override
    TextAttr markup(MarkupOut oMarkup, int nStart, int nSize, boolean bFlattenFields, TextAttr poPrevAttr) {
        if (this.mpoAttr != null) {
            if (!oMarkup.suppressAttributes()) {
                if (poPrevAttr == null) {
                    oMarkup.attr(this.mpoAttr);
                } else {
                    TextAttr oAttr = new TextAttr(this.mpoAttr);
                    oAttr.dropSame(poPrevAttr, false);
                    oMarkup.attr(oAttr);
                }
            }
            poPrevAttr = this.mpoAttr;
        }
        return poPrevAttr;
    }

    @Override
    TextAttr attrAt(int nIndex) {
        return this.mpoAttr;
    }

    @Override
    boolean isEqual(StrItem poCompare) {
        if (!(poCompare instanceof StrAttr)) {
            return false;
        }
        StrAttr poStrAttr = (StrAttr)poCompare;
        if (this.mpoAttr == poStrAttr.mpoAttr) {
            return true;
        }
        if (this.mpoAttr == null || poStrAttr.mpoAttr == null) {
            return false;
        }
        return this.mpoAttr.equals(poStrAttr.mpoAttr);
    }

    @Override
    boolean coalesce(StrItem poAfter, int nIndex) {
        StrAttr poNext = (StrAttr)poAfter;
        assert (this.mpoAttr != null);
        assert (poNext.mpoAttr != null);
        TextAttr poNewAttr = new TextAttr(this.mpoAttr);
        poNewAttr.override(poNext.mpoAttr, null);
        this.mpoAttr = poNewAttr;
        if (poNext.meState == 1) {
            this.meState = 1;
        } else if (this.meState != 2) {
            this.meState = 0;
        }
        return false;
    }

    @Override
    boolean canCoalesce(StrItem poAfter) {
        StrAttr poNext = (StrAttr)poAfter;
        if (this.mpoAttr == null || poNext.mpoAttr == null) {
            return false;
        }
        return this.meState != 1 || poNext.meState != 2 || this.mpoAttr == poNext.mpoAttr;
    }

    @Override
    StrItem cloneItem(TextGfxSource oGfxSource) {
        return new StrAttr(this.mpoAttr, oGfxSource, this.meState);
    }

    @Override
    int attrState() {
        return this.meState;
    }

    @Override
    void attrState(int eNewState) {
        this.meState = eNewState;
    }

    @Override
    void overrideAttr(TextAttr oOverride) {
        if (this.mpoAttr != null) {
            TextAttr poNewAttr = new TextAttr(this.mpoAttr);
            poNewAttr.override(oOverride, null);
            this.mpoAttr = poNewAttr;
        }
    }

    @Override
    void gfxSource(TextGfxSource oGfxSource) {
        if (this.mpoAttr != null && oGfxSource != this.mpoAttr.gfxSource()) {
            TextAttr poOldAttr = this.mpoAttr;
            this.connectToAttr(poOldAttr, oGfxSource);
        }
    }

    @Override
    void debug(int indent) {
        String prefix = Pkg.doIndent(indent + 1);
        System.out.println(prefix + "Attribute");
        if (this.mpoAttr != null) {
            this.mpoAttr.debug();
        }
    }

    private void connectToAttr(TextAttr poNewAttr, TextGfxSource poGfxSource) {
        this.mpoAttr = poNewAttr == null ? new TextAttr(TextAttr.defaultAttr(false)) : (poGfxSource != null && poNewAttr.gfxSource() != poGfxSource ? new TextAttr(poNewAttr, poGfxSource) : poNewAttr);
    }
}

