/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.gfx.GFXColour;
import com.adobe.xfa.gfx.GFXGraphicContext;
import com.adobe.xfa.gfx.GFXTextAttr;
import com.adobe.xfa.gfx.GFXTextContext;

public class TextGfxAttr {
    private final GFXTextAttr moGfxTextAttr = new GFXTextAttr();
    private boolean mbColourEnable;
    private boolean mbColourBgEnable;
    private boolean mbShadeEnable;
    private boolean mbShadeScaleEnable;
    private boolean mbGraphicContextEnable;
    private boolean mbTextContextEnable;

    public TextGfxAttr() {
        this.gfxTextAttrInitialize();
        this.setGfxTextAttrDefault(false);
    }

    public TextGfxAttr(TextGfxAttr oSource) {
        this.gfxTextAttrInitialize();
        this.setGfxTextAttrDefault(false);
        this.copyFrom(oSource);
    }

    public GFXTextAttr getGfxTextAttr() {
        return this.moGfxTextAttr;
    }

    public boolean gfxTextAttrEnable() {
        return this.underlineEnable() && this.overlineEnable() && this.strikeoutEnable() && this.textContextEnable() && this.graphicContextEnable() && this.colourEnable() && this.colourBgEnable() && this.styleEnable() && this.shadeEnable() && this.shadeScaleEnable();
    }

    public boolean anyGfxEnable() {
        return this.underlineEnable() || this.overlineEnable() || this.strikeoutEnable() || this.textContextEnable() || this.graphicContextEnable() || this.colourEnable() || this.colourBgEnable() || this.styleEnable() || this.shadeEnable() || this.shadeScaleEnable();
    }

    public int underline() {
        return this.moGfxTextAttr.underline();
    }

    public void underline(int eNewUnderline) {
        if (eNewUnderline != this.underline()) {
            this.moGfxTextAttr.underline(eNewUnderline);
            this.onUpdateGfxTextAttr();
        }
    }

    public boolean underlineEnable() {
        return this.moGfxTextAttr.underline() != 0;
    }

    public void underlineEnable(boolean bNewEnable) {
        if (bNewEnable != this.underlineEnable()) {
            this.moGfxTextAttr.underline(bNewEnable ? 1 : 0);
            this.onUpdateGfxTextAttr();
        }
    }

    public int overline() {
        return this.moGfxTextAttr.overline();
    }

    public void overline(int eNewOverline) {
        if (eNewOverline != this.overline()) {
            this.moGfxTextAttr.overline(eNewOverline);
            this.onUpdateGfxTextAttr();
        }
    }

    public boolean overlineEnable() {
        return this.moGfxTextAttr.overline() != 0;
    }

    public void overlineEnable(boolean bNewEnable) {
        if (bNewEnable != this.overlineEnable()) {
            this.moGfxTextAttr.overline(bNewEnable ? 1 : 0);
            this.onUpdateGfxTextAttr();
        }
    }

    public int strikeout() {
        return this.moGfxTextAttr.strikeout();
    }

    public void strikeout(int eNewStrikeout) {
        if (eNewStrikeout != this.strikeout()) {
            this.moGfxTextAttr.strikeout(eNewStrikeout);
            this.onUpdateGfxTextAttr();
        }
    }

    public boolean strikeoutEnable() {
        return this.moGfxTextAttr.strikeout() != 0;
    }

    public void strikeoutEnable(boolean bNewEnable) {
        if (bNewEnable != this.strikeoutEnable()) {
            this.moGfxTextAttr.strikeout(bNewEnable ? 1 : 0);
            this.onUpdateGfxTextAttr();
        }
    }

    public GFXTextContext textContext() {
        return this.mbTextContextEnable ? this.moGfxTextAttr.textContext() : null;
    }

    public void textContext(GFXTextContext poTextContext) {
        if (poTextContext != this.moGfxTextAttr.textContext() || !this.mbTextContextEnable) {
            this.moGfxTextAttr.textContext(poTextContext);
            this.mbTextContextEnable = true;
            this.onUpdateGfxTextAttr();
        }
    }

    public boolean textContextEnable() {
        return this.mbTextContextEnable;
    }

    public void textContextEnable(boolean bNewEnable) {
        if (bNewEnable != this.mbTextContextEnable) {
            this.mbTextContextEnable = bNewEnable;
            if (!this.mbTextContextEnable) {
                this.moGfxTextAttr.textContext(null);
            }
            this.onUpdateGfxTextAttr();
        }
    }

    public GFXGraphicContext graphicContext() {
        return this.mbGraphicContextEnable ? this.moGfxTextAttr.graphicContext() : null;
    }

    public void graphicContext(GFXGraphicContext poGraphicContext) {
        if (poGraphicContext != this.moGfxTextAttr.graphicContext() || !this.mbGraphicContextEnable) {
            this.moGfxTextAttr.graphicContext(poGraphicContext);
            this.mbGraphicContextEnable = true;
            this.onUpdateGfxTextAttr();
        }
    }

    public boolean graphicContextEnable() {
        return this.mbGraphicContextEnable;
    }

    public void graphicContextEnable(boolean bNewEnable) {
        if (bNewEnable != this.mbGraphicContextEnable) {
            this.mbGraphicContextEnable = bNewEnable;
            if (!this.mbGraphicContextEnable) {
                this.moGfxTextAttr.graphicContext(null);
            }
            this.onUpdateGfxTextAttr();
        }
    }

    public GFXColour colour() {
        return this.moGfxTextAttr.colour();
    }

    public void colour(GFXColour oNewColour) {
        if (!this.moGfxTextAttr.colour().equals(oNewColour) || !this.mbColourEnable) {
            this.moGfxTextAttr.colour(oNewColour);
            this.mbColourEnable = true;
            this.onUpdateGfxTextAttr();
        }
    }

    public boolean colourEnable() {
        return this.mbColourEnable;
    }

    public void colourEnable(boolean bNewEnable) {
        if (bNewEnable != this.mbColourEnable) {
            this.mbColourEnable = bNewEnable;
            this.onUpdateGfxTextAttr();
        }
    }

    public GFXColour colourBg() {
        return this.moGfxTextAttr.colourBg();
    }

    public void colourBg(GFXColour oNewColourBg) {
        if (!this.moGfxTextAttr.colourBg().equals(oNewColourBg) || !this.mbColourBgEnable) {
            this.moGfxTextAttr.colourBg(oNewColourBg);
            this.mbColourBgEnable = true;
            this.onUpdateGfxTextAttr();
        }
    }

    public boolean colourBgEnable() {
        return this.mbColourBgEnable;
    }

    public void colourBgEnable(boolean bNewEnable) {
        if (bNewEnable != this.mbColourBgEnable) {
            this.mbColourBgEnable = bNewEnable;
            this.onUpdateGfxTextAttr();
        }
    }

    public int style() {
        return this.moGfxTextAttr.style();
    }

    public void style(int eNewStyle) {
        if (eNewStyle != this.style()) {
            this.moGfxTextAttr.style(eNewStyle);
            this.onUpdateGfxTextAttr();
        }
    }

    public boolean styleEnable() {
        return this.moGfxTextAttr.style() != 0;
    }

    public void styleEnable(boolean bNewEnable) {
        if (bNewEnable != this.styleEnable()) {
            this.moGfxTextAttr.style(bNewEnable ? 2 : 0);
            this.onUpdateGfxTextAttr();
        }
    }

    public int shade() {
        return this.mbShadeEnable ? this.moGfxTextAttr.shade() : -1;
    }

    public void shade(int lNewShade) {
        if (lNewShade != this.shade() || !this.mbShadeEnable) {
            this.moGfxTextAttr.shade(lNewShade);
            this.mbShadeEnable = true;
            this.onUpdateGfxTextAttr();
        }
    }

    public boolean shadeEnable() {
        return this.mbShadeEnable;
    }

    public void shadeEnable(boolean bNewEnable) {
        if (bNewEnable != this.shadeEnable()) {
            this.mbShadeEnable = bNewEnable;
            this.onUpdateGfxTextAttr();
        }
    }

    public int shadeScale() {
        return this.mbShadeScaleEnable ? this.moGfxTextAttr.shadeScale() : -1;
    }

    public void shadeScale(int lNewShadeScale) {
        if (lNewShadeScale != this.shadeScale() || !this.mbShadeScaleEnable) {
            this.moGfxTextAttr.shadeScale(lNewShadeScale);
            this.mbShadeScaleEnable = true;
            this.onUpdateGfxTextAttr();
        }
    }

    public boolean shadeScaleEnable() {
        return this.mbShadeScaleEnable;
    }

    public void shadeScaleEnable(boolean bNewEnable) {
        if (bNewEnable != this.shadeScaleEnable()) {
            this.mbShadeScaleEnable = bNewEnable;
            this.onUpdateGfxTextAttr();
        }
    }

    public void setGfxTextAttrDefault(boolean bDefault) {
        if (bDefault) {
            this.moGfxTextAttr.underline(1);
            this.moGfxTextAttr.overline(1);
            this.moGfxTextAttr.strikeout(1);
            this.moGfxTextAttr.textContext(null);
            this.moGfxTextAttr.graphicContext(null);
            this.moGfxTextAttr.colour(GFXColour.black());
            this.moGfxTextAttr.colourBg(GFXColour.white());
            this.moGfxTextAttr.style(2);
            this.moGfxTextAttr.shade(100);
            this.moGfxTextAttr.shadeScale(100);
            this.mbTextContextEnable = true;
            this.mbGraphicContextEnable = true;
            this.mbColourEnable = true;
            this.mbColourBgEnable = true;
            this.mbShadeEnable = true;
            this.mbShadeScaleEnable = true;
            this.onUpdateGfxTextAttr();
        } else {
            this.underlineEnable(false);
            this.overlineEnable(false);
            this.strikeoutEnable(false);
            this.textContextEnable(false);
            this.graphicContextEnable(false);
            this.colourEnable(false);
            this.colourBgEnable(false);
            this.styleEnable(false);
            this.shadeEnable(false);
            this.shadeScaleEnable(false);
        }
    }

    public void copyFrom(TextGfxAttr oSource) {
        if (this != oSource) {
            this.moGfxTextAttr.copyFrom(oSource.moGfxTextAttr);
            this.mbTextContextEnable = oSource.mbTextContextEnable;
            this.mbGraphicContextEnable = oSource.mbGraphicContextEnable;
            this.mbColourEnable = oSource.mbColourEnable;
            this.mbColourBgEnable = oSource.mbColourBgEnable;
            this.mbShadeEnable = oSource.mbShadeEnable;
            this.mbShadeScaleEnable = oSource.mbShadeScaleEnable;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        TextGfxAttr cmp = (TextGfxAttr)object;
        if (this.underlineEnable() != cmp.underlineEnable()) {
            return false;
        }
        if (this.overlineEnable() != cmp.overlineEnable()) {
            return false;
        }
        if (this.strikeoutEnable() != cmp.strikeoutEnable()) {
            return false;
        }
        if (this.textContextEnable() != cmp.textContextEnable()) {
            return false;
        }
        if (this.graphicContextEnable() != cmp.graphicContextEnable()) {
            return false;
        }
        if (this.colourEnable() != cmp.colourEnable()) {
            return false;
        }
        if (this.colourBgEnable() != cmp.colourBgEnable()) {
            return false;
        }
        if (this.styleEnable() != cmp.styleEnable()) {
            return false;
        }
        if (this.shadeEnable() != cmp.shadeEnable()) {
            return false;
        }
        if (this.shadeScaleEnable() != cmp.shadeScaleEnable()) {
            return false;
        }
        if (this.underlineEnable() && this.underline() != cmp.underline()) {
            return false;
        }
        if (this.overlineEnable() && this.overline() != cmp.overline()) {
            return false;
        }
        if (this.strikeoutEnable() && this.strikeout() != cmp.strikeout()) {
            return false;
        }
        if (this.textContextEnable() && this.textContext() != cmp.textContext()) {
            return false;
        }
        if (this.graphicContextEnable() && this.graphicContext() != cmp.graphicContext()) {
            return false;
        }
        if (this.colourEnable() && this.colour() != cmp.colour()) {
            return false;
        }
        if (this.colourBgEnable() && this.colourBg() != cmp.colourBg()) {
            return false;
        }
        if (this.styleEnable() && this.style() != cmp.style()) {
            return false;
        }
        if (this.shadeEnable() && this.shade() != cmp.shade()) {
            return false;
        }
        return !this.shadeScaleEnable() || this.shadeScale() == cmp.shadeScale();
    }

    public int hashCode() {
        int hash = 89;
        if (this.underlineEnable()) {
            hash = hash * 31 ^ this.underline();
        }
        if (this.overlineEnable()) {
            hash = hash * 31 ^ this.overline();
        }
        if (this.strikeoutEnable()) {
            hash = hash * 31 ^ this.strikeout();
        }
        if (this.textContextEnable()) {
            hash = hash * 31 ^ this.textContext().hashCode();
        }
        if (this.graphicContextEnable()) {
            hash = hash * 31 ^ this.graphicContext().hashCode();
        }
        if (this.colourEnable()) {
            hash = hash * 31 ^ this.colour().hashCode();
        }
        if (this.colourBgEnable()) {
            hash = hash * 31 ^ this.colourBg().hashCode();
        }
        if (this.styleEnable()) {
            hash = hash * 31 ^ this.style();
        }
        if (this.shadeEnable()) {
            hash = hash * 31 ^ this.shade();
        }
        if (this.shadeScaleEnable()) {
            hash = hash * 31 ^ this.shadeScale();
        }
        return hash;
    }

    public boolean notEqual(TextGfxAttr oCompare) {
        return !this.equals(oCompare);
    }

    void applyGfxTextAttrs(TextGfxAttr oSource) {
        boolean bAnyChange = false;
        if (oSource.underlineEnable()) {
            this.moGfxTextAttr.underline(oSource.underline());
            bAnyChange = true;
        }
        if (oSource.overlineEnable()) {
            this.moGfxTextAttr.overline(oSource.overline());
            bAnyChange = true;
        }
        if (oSource.strikeoutEnable()) {
            this.moGfxTextAttr.strikeout(oSource.strikeout());
            bAnyChange = true;
        }
        if (oSource.textContextEnable()) {
            this.moGfxTextAttr.textContext(oSource.textContext());
            this.mbTextContextEnable = true;
            bAnyChange = true;
        }
        if (oSource.graphicContextEnable()) {
            this.moGfxTextAttr.graphicContext(oSource.graphicContext());
            this.mbGraphicContextEnable = true;
            bAnyChange = true;
        }
        if (oSource.colourEnable()) {
            this.moGfxTextAttr.colour(oSource.colour());
            this.mbColourEnable = true;
            bAnyChange = true;
        }
        if (oSource.colourBgEnable()) {
            this.moGfxTextAttr.colourBg(oSource.colourBg());
            this.mbColourBgEnable = true;
            bAnyChange = true;
        }
        if (oSource.styleEnable()) {
            this.moGfxTextAttr.style(oSource.style());
            bAnyChange = true;
        }
        if (oSource.shadeEnable()) {
            this.moGfxTextAttr.shade(oSource.shade());
            this.mbShadeEnable = true;
            bAnyChange = true;
        }
        if (oSource.shadeScaleEnable()) {
            this.moGfxTextAttr.shadeScale(oSource.shadeScale());
            this.mbShadeScaleEnable = true;
            bAnyChange = true;
        }
        if (bAnyChange) {
            this.onUpdateGfxTextAttr();
        }
    }

    protected void setGfxTextAttr(GFXTextAttr oGfxTextAttr) {
        this.moGfxTextAttr.copyFrom(oGfxTextAttr);
        this.mbTextContextEnable = true;
        this.mbGraphicContextEnable = true;
        this.mbColourEnable = true;
        this.mbColourBgEnable = true;
        this.mbShadeEnable = true;
        this.mbShadeScaleEnable = true;
    }

    protected void onUpdateGfxTextAttr() {
    }

    private void gfxTextAttrInitialize() {
        this.mbTextContextEnable = false;
        this.mbGraphicContextEnable = false;
        this.mbColourEnable = false;
        this.mbColourBgEnable = false;
        this.mbShadeEnable = false;
        this.mbShadeScaleEnable = false;
    }
}

