/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.font.FontService;
import com.adobe.xfa.text.LoadText;
import com.adobe.xfa.text.MarkerTemp;
import com.adobe.xfa.text.Pkg;
import com.adobe.xfa.text.PosnMarker;
import com.adobe.xfa.text.StrAttr;
import com.adobe.xfa.text.StrEmbed;
import com.adobe.xfa.text.StrEnd;
import com.adobe.xfa.text.StrField;
import com.adobe.xfa.text.StrItem;
import com.adobe.xfa.text.StrNullFrame;
import com.adobe.xfa.text.StrPara;
import com.adobe.xfa.text.StrText;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextContext;
import com.adobe.xfa.text.TextDisplay;
import com.adobe.xfa.text.TextEmbed;
import com.adobe.xfa.text.TextField;
import com.adobe.xfa.text.TextGfxSource;
import com.adobe.xfa.text.TextLegacy;
import com.adobe.xfa.text.TextMarker;
import com.adobe.xfa.text.TextNullFrame;
import com.adobe.xfa.text.TextPosn;
import com.adobe.xfa.text.TextPosnBase;
import com.adobe.xfa.text.TextRange;
import com.adobe.xfa.text.markup.MarkupIn;
import com.adobe.xfa.text.markup.MarkupOut;
import com.adobe.xfa.text.markup.MarkupText;
import com.adobe.xfa.ut.Storage;
import com.adobe.xfa.ut.UniCharIterator;
import java.util.List;

public class TextStream
extends TextLegacy {
    public static final TextStream DEFAULT_STREAM = new TextStream();
    private static final int UPDATE_NORMAL = 0;
    private static final int UPDATE_SUPPRESS_RECONCILE = 1;
    private static final int UPDATE_KEEP_TEMP_ATTR = 2;
    private static final int UPDATE_FULL_SUPPRESS = 3;
    private static final int UPDATE_SUPPRESS_DISPLAY = 4;
    private static final int UPDATE_POSN_FORCE = 0;
    private static final int UPDATE_POSN_NORMAL = 1;
    private static final int UPDATE_POSN_TIGHTEN = 2;
    private final Storage<StrItem> moItems = new Storage();
    private TextPosn mpoAssociated;
    private TextGfxSource moGfxSource;
    private int mnCount;
    private TextDisplay mpoDisplay;
    private TextRange mpoTempAttr;
    private int mnMaxSize;
    private boolean mbAllowNewLines;
    private int mnSuppressAutoLoad;

    public TextStream() {
        this.initialize(null);
    }

    public TextStream(TextStream oSource, TextGfxSource poPool) {
        this.moGfxSource = poPool;
        this.initialize(null);
        LoadText oLoader = new LoadText(oSource, this.moGfxSource);
        this.loadText(oLoader);
    }

    public TextStream(TextStream oSource) {
        this.moGfxSource = null;
        this.initialize(null);
        LoadText oLoader = new LoadText(oSource, this.moGfxSource);
        this.loadText(oLoader);
    }

    public TextStream(String sSource) {
        this.initialize(sSource);
    }

    static TextStream defaultStream() {
        return DEFAULT_STREAM;
    }

    public void enumEmbed(List<TextEmbed> oEmbeds) {
        oEmbeds.clear();
        for (StrItem strItem : this.moItems) {
            strItem.addEmbed(oEmbeds);
        }
    }

    public void enumField(List<TextField> oFields) {
        oFields.clear();
        for (StrItem strItem : this.moItems) {
            strItem.addField(oFields);
        }
    }

    public void enumMarker(List<TextMarker> oMarkers, boolean bPositionMarkers, boolean bRangeMarkers) {
        TextRange oRange = new TextRange(this);
        oRange.enumerateMarkers(oMarkers, bPositionMarkers, bRangeMarkers, false);
    }

    public String text(boolean bIncludeFields) {
        MarkupText oMarkup = new MarkupText();
        this.markup(oMarkup, null, false, bIncludeFields);
        return oMarkup.getText();
    }

    public String text() {
        return this.text(false);
    }

    public void contiguousText(List<TextRange> oRanges) {
        TextPosn oStart = new TextPosn(this);
        TextPosn oEnd = new TextPosn(oStart);
        int eItem = oEnd.next();
        while (true) {
            if (eItem != 2 && eItem != 1) {
                int nEnd = oEnd.index();
                if (eItem != 0) {
                    --nEnd;
                }
                if (nEnd > oStart.index()) {
                    oRanges.add(new TextRange(this, oStart.index(), nEnd));
                }
                if (eItem == 0) break;
                oStart = oEnd;
            }
            eItem = oEnd.next();
        }
    }

    public void setText(String sText) {
        TextRange oRange = new TextRange(this);
        oRange.replace(sText);
    }

    public void append(String sText) {
        TextPosnBase oPosn = new TextPosnBase(this, Integer.MAX_VALUE);
        oPosn.insert(sText);
    }

    public void append(TextAttr oAttr) {
        TextPosnBase oPosn = new TextPosnBase(this, Integer.MAX_VALUE);
        oPosn.attribute(oAttr);
    }

    public void append(TextField poField) {
        TextPosnBase oPosn = new TextPosnBase(this, Integer.MAX_VALUE);
        oPosn.insert(poField);
    }

    public void append(TextEmbed poEmbed) {
        TextPosnBase oPosn = new TextPosnBase(this, Integer.MAX_VALUE);
        oPosn.insert(poEmbed);
    }

    public void append(TextMarker oMarker) {
    }

    public void append(TextStream oText) {
        TextPosnBase oPosn = new TextPosnBase(this, Integer.MAX_VALUE);
        oPosn.insert(oText);
    }

    public TextDisplay display() {
        return this.mpoDisplay;
    }

    public void suppressFormat(boolean bSuppress) {
        if (this.display() != null) {
            if (bSuppress) {
                this.display().pushSuppressFormat();
            } else {
                this.display().popSuppressFormat();
            }
        }
    }

    public FontService fontService() {
        return this.moGfxSource == null ? null : this.moGfxSource.getFontService();
    }

    public void fontService(FontService poNewFontService) {
        if (this.moGfxSource != null && poNewFontService == this.moGfxSource.getFontService()) {
            return;
        }
        this.moGfxSource = new TextGfxSource(poNewFontService);
        this.updateGfxSource();
    }

    public TextGfxSource gfxSource() {
        return this.moGfxSource;
    }

    public void gfxSource(TextGfxSource newSource) {
        if (newSource == this.moGfxSource) {
            return;
        }
        if (newSource != null && this.moGfxSource != null && newSource.getFontService() == this.moGfxSource.getFontService()) {
            return;
        }
        this.moGfxSource = newSource;
        this.updateGfxSource();
    }

    public int maxSize() {
        return this.mnMaxSize;
    }

    public void maxSize(int nNewSize, boolean bAllowExistingOverflow) {
        if (bAllowExistingOverflow || nNewSize == 0 || nNewSize < this.currentSize()) {
            // empty if block
        }
        this.mnMaxSize = nNewSize;
    }

    public int currentSize() {
        int nCount = 0;
        int nSize = this.moItems.size();
        for (int i = 0; i < nSize; ++i) {
            StrItem poItem = this.getItem(i);
            int nType = poItem.strType();
            if (nType != 2 && nType != 5 && nType != 4) continue;
            nCount += poItem.count();
        }
        return nCount;
    }

    public int spaceLeft() {
        if (this.mnMaxSize == 0) {
            return Integer.MAX_VALUE;
        }
        int nCurrentSize = this.currentSize();
        return nCurrentSize > this.mnMaxSize ? 0 : this.mnMaxSize - nCurrentSize;
    }

    public boolean allowNewLines() {
        return this.mbAllowNewLines;
    }

    public void allowNewLines(boolean bNewAllow) {
        if (bNewAllow || this.anyNewLines()) {
            // empty if block
        }
        this.mbAllowNewLines = bNewAllow;
    }

    public boolean anyNewLines() {
        return this.find("\n", null);
    }

    public boolean find(String sSearch, TextPosnBase poFoundPosn) {
        if (sSearch.length() == 0) {
            return false;
        }
        TextRange oCount = new TextRange(this);
        int nCount = oCount.countText();
        if (nCount > sSearch.length()) {
            return false;
        }
        nCount -= sSearch.length() - 1;
        UniCharIterator iter = new UniCharIterator(sSearch);
        TextPosnBase oBase = new TextPosnBase(this);
        oBase.nextChar();
        while (nCount > 0) {
            TextPosnBase oScan = new TextPosnBase(oBase);
            oScan.prev();
            int i = 0;
            while (i < sSearch.length()) {
                int eItem = oScan.next(true);
                if (eItem == 2) {
                    int c = oScan.nextChar();
                    iter.setIndex(i);
                    if (c != iter.next()) break;
                    i = iter.getIndex();
                    continue;
                }
                if (eItem != 1) break;
                oScan.next();
            }
            if (i >= sSearch.length()) {
                if (poFoundPosn != null) {
                    oBase.prev();
                    poFoundPosn.copyFrom(oBase);
                }
                return true;
            }
            oBase.nextChar();
            --nCount;
        }
        return false;
    }

    public boolean find(String sSearch) {
        return this.find(sSearch, null);
    }

    public void markup(MarkupOut oMarkup, TextAttr poInitAttr, boolean bDefaultInitAttr, boolean bFlattenFields) {
        TextRange oRange = new TextRange(this, 0, Integer.MAX_VALUE);
        oRange.markup(oMarkup, poInitAttr, bDefaultInitAttr, bFlattenFields);
    }

    public void markup(MarkupOut oMarkup, TextAttr poInitAttr, boolean bDefaultInitAttr) {
        this.markup(oMarkup, poInitAttr, bDefaultInitAttr, false);
    }

    public void markup(MarkupOut oMarkup, TextAttr poInitAttr) {
        this.markup(oMarkup, poInitAttr, false, false);
    }

    public void markup(MarkupOut oMarkup) {
        this.markup(oMarkup, null, false, false);
    }

    public void markup(MarkupIn oMarkup) {
        TextRange oRange = new TextRange(this);
        oRange.markup(oMarkup);
    }

    public boolean isDescendentOf(TextStream poAncestor, TextPosnBase poPosn) {
        if (this == poAncestor) {
            return true;
        }
        TextPosn poParentPosn = this.position();
        if (poParentPosn == null) {
            return false;
        }
        TextStream poParentStream = poParentPosn.stream();
        if (poParentStream == null) {
            return false;
        }
        if (poParentStream == poAncestor) {
            if (poPosn != null) {
                poPosn.copyFrom(poParentPosn);
            }
            return true;
        }
        return poParentStream.isDescendentOf(poAncestor, poPosn);
    }

    public boolean isDescendentOf(TextStream poAncestor) {
        return this.isDescendentOf(poAncestor, null);
    }

    public void legacyPositioning(boolean bLegacyPositioning) {
        this.cascadeLegacyLevel(bLegacyPositioning ? -1 : 0);
    }

    public void cascadeLegacyLevel(int eLevel) {
        this.setLegacyLevel(eLevel);
        int nSize = this.moItems.size();
        for (int i = 0; i < nSize; ++i) {
            this.getItem(i).cascadeLegacyLevel(eLevel);
        }
    }

    public void copyFrom(TextStream oSource) {
        LoadText oLoader = new LoadText(oSource, this.moGfxSource);
        this.loadText(oLoader);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        TextStream oCompare = (TextStream)object;
        if (this.moItems.size() != oCompare.moItems.size()) {
            return false;
        }
        int nSize = this.moItems.size();
        for (int i = 0; i < nSize; ++i) {
            StrItem poSource = this.getItem(i);
            StrItem poCompare = oCompare.getItem(i);
            if (poSource.strType() != poCompare.strType()) {
                return false;
            }
            if (poSource.isEqual(poCompare)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash;
        block0: {
            hash = 47;
            int i = 0;
            int nSize = this.moItems.size();
            if (i >= nSize) break block0;
            StrItem oSource = this.getItem(i);
            hash = hash * 31 ^ oSource.hashCode();
        }
        return hash;
    }

    public boolean notEqual(TextStream oCompare) {
        return !this.equals(oCompare);
    }

    public TextContext getContext() {
        TextStream poParentStream;
        TextPosn poPosn = this.position();
        if (poPosn != null && (poParentStream = poPosn.stream()) != null) {
            return poParentStream.getContext();
        }
        return null;
    }

    public TextPosn position() {
        return null;
    }

    public void updateNotification() {
    }

    void posnAttach(TextPosn poPosn) {
        poPosn.mpoNext = this.mpoAssociated;
        this.mpoAssociated = poPosn;
        poPosn.mpoStream = this;
    }

    void posnDetach(TextPosn poPosn) {
        TextPosn poPrev = null;
        TextPosn poSearch = this.mpoAssociated;
        while (poSearch != poPosn && poSearch != null) {
            poPrev = poSearch;
            poSearch = poSearch.mpoNext;
        }
        if (poSearch != null) {
            if (poPrev == null) {
                this.mpoAssociated = poSearch.mpoNext;
            } else {
                poPrev.mpoNext = poSearch.mpoNext;
            }
            poSearch.mpoNext = null;
            poSearch.cleanup();
        }
    }

    public int posnCount() {
        return this.mnCount;
    }

    void posnFirst(TextPosnBase oPosn) {
        oPosn.index(0);
        int eItem = oPosn.next();
        while (eItem == 1) {
            eItem = oPosn.next();
        }
        if (eItem != 0) {
            oPosn.prev();
        }
    }

    public int[] posnNext(TextPosnBase oPosn, int eNullFrameMode, boolean bTestOnly) {
        return this.posnMove(oPosn, true, eNullFrameMode, bTestOnly);
    }

    public int posnNextType(TextPosnBase oPosn, int eNullFrameMode, boolean bTestOnly) {
        int[] result = this.posnNext(oPosn, eNullFrameMode, bTestOnly);
        return result == null ? 0 : result[0];
    }

    public int posnNextType(TextPosnBase oPosn, int eNullFrameMode) {
        int[] result = this.posnNext(oPosn, eNullFrameMode, false);
        return result == null ? 0 : result[0];
    }

    public int[] posnPrev(TextPosnBase oPosn, int eNullFrameMode, boolean bTestOnly) {
        return this.posnMove(oPosn, false, eNullFrameMode, bTestOnly);
    }

    public int posnPrevType(TextPosnBase oPosn, int eNullFrameMode, boolean bTestOnly) {
        int[] result = this.posnPrev(oPosn, eNullFrameMode, bTestOnly);
        return result == null ? 0 : result[0];
    }

    public int posnPrevType(TextPosnBase oPosn, int eNullFrameMode) {
        int[] result = this.posnPrev(oPosn, eNullFrameMode, false);
        return result == null ? 0 : result[0];
    }

    public int posnNextChar(TextPosnBase oPosn, boolean bTestOnly) {
        StrItem poItem = this.getItem(oPosn.major());
        int c = poItem.charAt(oPosn.minor());
        if (c != 0 && (c != 10 || poItem.strType() != 5)) {
            if (!bTestOnly) {
                oPosn.next();
            }
        } else {
            TextPosnBase oTempPosn = new TextPosnBase(oPosn);
            boolean bMore = this.posnSearchForward(oTempPosn, 2);
            if (!bTestOnly) {
                oPosn.copyFrom(oTempPosn);
            }
            if (!bMore) {
                c = 0;
            } else {
                oTempPosn.prev();
                c = this.getItem(oTempPosn.major()).charAt(oTempPosn.minor());
            }
        }
        return c;
    }

    public int posnPrevChar(TextPosnBase oPosn, boolean bTestOnly) {
        TextPosnBase oTempPosn = new TextPosnBase(oPosn);
        boolean bMore = this.posnSearchBackward(oTempPosn, 2);
        if (!bTestOnly) {
            oPosn.copyFrom(oTempPosn);
        }
        if (!bMore) {
            return 0;
        }
        return this.getItem(oTempPosn.major()).charAt(oTempPosn.minor());
    }

    public TextField posnNextField(TextPosnBase oPosn, boolean bTestOnly) {
        TextPosnBase oTempPosn = new TextPosnBase(oPosn);
        boolean bMore = this.posnSearchForward(oTempPosn, 3, 2);
        if (!bTestOnly) {
            oPosn.copyFrom(oTempPosn);
        }
        if (!bMore) {
            return null;
        }
        oTempPosn.prev();
        return this.getItem(oTempPosn.major()).fieldAt(oTempPosn.minor());
    }

    public TextField posnPrevField(TextPosnBase oPosn, boolean bTestOnly) {
        TextPosnBase oTempPosn = new TextPosnBase(oPosn);
        boolean bMore = this.posnSearchBackward(oTempPosn, 3, 2);
        if (!bTestOnly) {
            oPosn.copyFrom(oTempPosn);
        }
        if (!bMore) {
            return null;
        }
        return this.getItem(oTempPosn.major()).fieldAt(oTempPosn.minor());
    }

    public TextEmbed posnNextEmbed(TextPosnBase oPosn, boolean bTestOnly) {
        TextPosnBase oTempPosn = new TextPosnBase(oPosn);
        boolean bMore = this.posnSearchForward(oTempPosn, 4, 2);
        if (!bTestOnly) {
            oPosn.copyFrom(oTempPosn);
        }
        if (!bMore) {
            return null;
        }
        oTempPosn.prev();
        return this.getItem(oTempPosn.major()).embedAt(oTempPosn.minor());
    }

    public TextEmbed posnPrevEmbed(TextPosnBase oPosn, boolean bTestOnly) {
        TextPosnBase oTempPosn = new TextPosnBase(oPosn);
        boolean bMore = this.posnSearchBackward(oTempPosn, 4, 2);
        if (!bTestOnly) {
            oPosn.copyFrom(oTempPosn);
        }
        if (!bMore) {
            return null;
        }
        return this.getItem(oTempPosn.major()).embedAt(oTempPosn.minor());
    }

    public TextAttr posnNextAttr(TextPosnBase oPosn, boolean bTestOnly) {
        TextPosnBase oTempPosn = new TextPosnBase(oPosn);
        boolean bMore = this.posnSearchForward(oTempPosn, 1, 2);
        if (!bTestOnly) {
            oPosn.copyFrom(oTempPosn);
        }
        if (!bMore) {
            return null;
        }
        oTempPosn.prev();
        return this.getItem(oTempPosn.major()).attrAt(oTempPosn.minor());
    }

    public TextAttr posnPrevAttr(TextPosnBase oPosn, boolean bTestOnly) {
        TextPosnBase oTempPosn = new TextPosnBase(oPosn);
        boolean bMore = this.posnSearchBackward(oTempPosn, 1, 2);
        if (!bTestOnly) {
            oPosn.copyFrom(oTempPosn);
        }
        if (!bMore) {
            return null;
        }
        return this.getItem(oTempPosn.major()).attrAt(oTempPosn.minor());
    }

    void posnInsert(TextPosnBase oPosn, char cInsert) {
        String sInsert = "";
        sInsert = sInsert + cInsert;
        this.posnInsert(oPosn, sInsert);
    }

    void posnInsert(TextPosnBase oPosn, String sInsert) {
        if (sInsert.length() == 0) {
            return;
        }
        if (this.mbAllowNewLines || sInsert.indexOf(10) >= 0) {
            // empty if block
        }
        this.insert(oPosn, (StrItem)new StrText(sInsert), true, 4);
    }

    public void posnInsert(TextPosnBase oPosn, TextStream oInsert) {
        int i;
        int nInsertSize;
        TextAttr poFirstAttr;
        this.insertTest(oInsert.currentSize());
        if (this.mbAllowNewLines || oInsert.find("")) {
            // empty if block
        }
        TextRange oMarkerRange = new TextRange(this, oPosn.index(), oPosn.index());
        TextAttr poPrevAttr = poFirstAttr = this.posnAttrPtr(oPosn);
        boolean bAttrChange = false;
        boolean bSplitItem = oPosn.minor() != 0;
        int nIndex = oPosn.mnIndex;
        int nCount = oInsert.mnCount;
        int nCopySize = nInsertSize = oInsert.moItems.size() - 1;
        if (bSplitItem) {
            nCopySize += 2;
        }
        int nNewIndex = 0;
        Storage oNewItems = new Storage(nCopySize);
        for (i = 0; i < nCopySize; ++i) {
            oNewItems.add(null);
        }
        if (bSplitItem) {
            StrItem[] split = this.getItem(oPosn.mnMajor).split(oPosn.mnMinor);
            StrItem splitFirst = split[0];
            StrItem splitLast = split[1];
            oNewItems.set(0, splitFirst);
            oNewItems.set(nCopySize - 1, splitLast);
            nCount += splitFirst.count() + splitLast.count();
            nCount -= this.getItem(oPosn.major()).count();
            ++nNewIndex;
        }
        for (i = 0; i < nInsertSize; ++i) {
            StrItem poItem = oInsert.getItem(i);
            TextAttr poItemAttr = poItem.attrAt(0);
            StrItem poNewItem = null;
            if (poPrevAttr != null && poItemAttr != null) {
                poNewItem = new StrAttr(poPrevAttr);
                poNewItem.overrideAttr(poItemAttr);
                poPrevAttr = poNewItem.attrAt(0);
                bAttrChange = true;
            } else {
                poNewItem = oInsert.getItem(i).cloneItem(this.moGfxSource);
            }
            oNewItems.set(nNewIndex, poNewItem);
            ++nNewIndex;
        }
        if (bAttrChange) {
            int lastIndex = nCopySize++;
            oNewItems.setSize(nCopySize);
            StrAttr restoreAttr = new StrAttr(poFirstAttr);
            if (bSplitItem) {
                int penultimate = lastIndex - 1;
                oNewItems.set(lastIndex, oNewItems.get(penultimate));
                oNewItems.set(penultimate, restoreAttr);
            } else {
                oNewItems.set(lastIndex, restoreAttr);
            }
            ++nCount;
        }
        int nNewSize = this.moItems.size() + nCopySize;
        if (bSplitItem) {
            --nNewSize;
            this.moItems.remove(oPosn.major());
        }
        int nOldSize = this.moItems.size();
        this.moItems.setSize(nNewSize);
        int nSrc = nOldSize;
        int nDst = nNewSize;
        while (nSrc > oPosn.major()) {
            this.moItems.set(--nDst, this.moItems.get(--nSrc));
        }
        for (i = 0; i < nCopySize; ++i) {
            this.moItems.set(oPosn.major() + i, oNewItems.get(i));
        }
        TextRange oInsertRange = new TextRange(this, nIndex, nIndex);
        if (!this.completeInsert(nIndex, nCount, true, 5, bAttrChange, 0)) {
            oInsertRange.delete();
            return;
        }
        this.setEmbedPositions();
        this.splitParaMarkers(oMarkerRange, null);
    }

    void posnInsert(TextPosnBase oPosn, TextField poField) {
        this.insert(oPosn, (StrItem)new StrField(poField, this.moGfxSource, this.getLegacyLevel()), false, 2);
        this.setEmbedPositions();
    }

    public void posnInsert(TextPosnBase oPosn, TextEmbed poEmbed) {
        this.insertTest(1);
        this.insert(oPosn, (StrItem)new StrEmbed(poEmbed, this.getLegacyLevel()), true, 1);
        this.setEmbedPositions();
    }

    public void posnInsertPara(TextPosnBase oPosn) {
        TextRange oMarkerRange = new TextRange(this, oPosn.index(), oPosn.index());
        this.insert(oPosn, (StrItem)new StrPara(), true, 3);
        this.splitParaMarkers(oMarkerRange, null);
    }

    TextAttr posnAttrPtr(TextPosnBase oPosn) {
        TextPosnBase oSearch = new TextPosnBase(oPosn);
        if (this.posnSearchBackward(oSearch, 1, 2)) {
            return this.getItem(oSearch.mnMajor).attrAt(0);
        }
        TextPosn poPosn = this.position();
        if (poPosn != null) {
            return poPosn.attributePtr();
        }
        return null;
    }

    TextAttr posnAttr(TextPosnBase oPosn) {
        TextAttr poAttr = this.posnAttrPtr(oPosn);
        if (poAttr == null) {
            poAttr = TextAttr.defaultAttr(true);
        }
        return new TextAttr(poAttr);
    }

    void posnAttr(TextPosnBase oPosn, TextAttr oNewAttr, boolean bRaw) {
        TextRange oRange = new TextRange(this, oPosn.mnIndex, oPosn.mnIndex);
        oRange.attribute(oNewAttr);
        oPosn.index(oRange.position((int)0).mnIndex);
    }

    TextMarker posnMarker(TextPosnBase oPosn, TextMarker poMarker) {
        TextMarker poCopy = poMarker.cloneMarker();
        PosnMarker poLocation = new PosnMarker(oPosn, poCopy);
        poCopy.setLocation(poLocation);
        return poCopy;
    }

    TextMarker posnMarkerStart(TextPosnBase oPosn, TextMarker poMarker) {
        return new MarkerTemp(oPosn, poMarker);
    }

    void posnMarkerEnd(TextPosnBase oPosn, TextMarker poMarker) {
        MarkerTemp poStartInfo = (MarkerTemp)poMarker;
        TextMarker poCopy = poStartInfo.getMarkerCopy();
        this.rangeMarkerInternal(poStartInfo.getStart(), oPosn, poCopy);
    }

    void posnDelete(TextPosnBase oPosn, int nDelete, boolean bRaw) {
        this.delete(oPosn, nDelete, bRaw, 0);
    }

    public void posnUpdateStreamLoc(TextPosnBase oPosn, int nIndex) {
        int nCurrent;
        int nEnd = nIndex;
        if (nEnd > this.posnCount()) {
            nEnd = this.posnCount();
        }
        if (oPosn.mnIndex > nEnd || oPosn.mbIsInvalid) {
            oPosn.mnIndex = 0;
            oPosn.mnMajor = 0;
            oPosn.mnMinor = 0;
        }
        for (int nLeft = nEnd - oPosn.mnIndex; nLeft > 0 && oPosn.mnMajor < this.moItems.size(); nLeft -= nCurrent) {
            nCurrent = this.getItem(oPosn.mnMajor).count() - oPosn.mnMinor;
            if (nCurrent <= nLeft) {
                ++oPosn.mnMajor;
                oPosn.mnMinor = 0;
                continue;
            }
            nCurrent = nLeft;
            oPosn.mnMinor += nCurrent;
        }
        oPosn.mnIndex = nEnd;
        oPosn.cleanupTarget();
        oPosn.mbIsInvalid = false;
    }

    void posnInsertNullFrame(TextPosnBase oPosn, TextNullFrame poNullFrame) {
        this.insert(oPosn, (StrItem)new StrNullFrame(poNullFrame), 4, -1);
    }

    void posnRemoveNullFrame(TextPosnBase oPosn) {
        TextPosnBase oTighten = new TextPosnBase(oPosn);
        oTighten.tighten(true);
        this.delete(oTighten, 1, true, 4);
    }

    String rangeText(TextPosn oStart, TextPosn oEnd, boolean bIncludeFields) {
        MarkupText oMarkup = new MarkupText();
        this.rangeMarkup(oStart, oEnd, oMarkup, null, false, bIncludeFields);
        return oMarkup.getText();
    }

    void rangeText(TextPosn oStart, TextPosn oEnd, TextStream oText) {
        LoadText oLoader = new LoadText(oStart, oEnd, oText.moGfxSource);
        oText.loadText(oLoader);
    }

    void rangeReplace(TextPosnBase oPosn, int nDelete, String sReplace, boolean bRaw) {
        this.delete(oPosn, nDelete, bRaw, 3);
        this.posnInsert(oPosn, sReplace);
    }

    void rangeReplace(TextPosnBase oPosn, int nDelete, TextStream sReplace, boolean bRaw) {
        this.delete(oPosn, nDelete, bRaw, 3);
        this.posnInsert(oPosn, sReplace);
    }

    TextAttr rangeGetAttr(TextPosn oStart, TextPosn oEnd) {
        TextAttr oAttr = this.posnAttr(oStart);
        int nSize = this.moItems.size();
        for (int nSearch = oStart.major(); nSearch < oEnd.major() && nSearch < nSize; ++nSearch) {
            StrItem poItem = this.getItem(nSearch);
            if (poItem.strType() != 1) continue;
            oAttr.dropDiff(poItem.attrAt(0));
        }
        return oAttr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rangeSetAttr(TextPosn oStart, TextPosn oEnd, TextAttr oNewAttr, boolean bRaw) {
        this.suppressFormat(true);
        try {
            if (oEnd.index() > oStart.index()) {
                Storage<TextMarker> oMarkers = new Storage<TextMarker>();
                int nStart = oStart.index();
                int nEnd = oEnd.index();
                this.enumerateOverlappingRangeMarkers(nStart, nEnd, oMarkers);
                for (int i = 0; i < oMarkers.size(); ++i) {
                    TextMarker poMarker = (TextMarker)oMarkers.get(i);
                    int[] markers = new int[]{nStart, nEnd};
                    TextStream.intersectMarkerRange(poMarker, markers);
                    poMarker.onAttributeChange(nStart, nEnd, oNewAttr);
                }
            }
            TextPosn oParaStart = null;
            TextPosn oParaEnd = null;
            boolean bTreatAsRaw = bRaw;
            if (!bTreatAsRaw) {
                if (!oNewAttr.hasParaAttrs()) {
                    bTreatAsRaw = true;
                } else {
                    TextRange oParaRange = new TextRange(this, oStart.index(), oEnd.index());
                    oParaRange.grabPara();
                    oParaStart = oParaRange.start();
                    oParaEnd = oParaRange.end();
                    if (oStart.equals(oParaStart) && oEnd.equals(oParaEnd)) {
                        bTreatAsRaw = true;
                    }
                }
            }
            if (bTreatAsRaw) {
                this.rangeAttr(oStart, oEnd, oNewAttr, 0);
            } else {
                TextAttr oTempAttr = new TextAttr(oNewAttr);
                oTempAttr.isolatePara(true, this.hasLegacyPositioning());
                this.rangeAttr(oParaStart, oParaEnd, oTempAttr, 1);
                oTempAttr.copyFrom(oNewAttr);
                oTempAttr.isolatePara(false, this.hasLegacyPositioning());
                this.rangeAttr(oStart, oEnd, oTempAttr, 0);
            }
        }
        finally {
            this.suppressFormat(false);
        }
    }

    void rangeMarkup(TextPosn oStart, TextPosn oEnd, MarkupOut oMarkup, TextAttr poInitAttr, boolean bDefaultInitAttr, boolean bFlattenFields) {
        oMarkup.reset();
        TextPosnBase oBase = new TextPosnBase(oStart);
        TextAttr poPrevAttr = null;
        if (!oMarkup.suppressAttributes()) {
            if (!bDefaultInitAttr) {
                if (poInitAttr != null) {
                    oMarkup.attr(poInitAttr);
                } else {
                    poPrevAttr = this.posnAttrPtr(oBase);
                    if (poPrevAttr != null) {
                        oMarkup.attr(poPrevAttr);
                    }
                }
            } else {
                if (oBase.next(true) == 1) {
                    oBase.next();
                }
                if ((poPrevAttr = this.posnAttrPtr(oBase)) != null) {
                    TextAttr oAttr = new TextAttr(poPrevAttr);
                    if (poInitAttr != null) {
                        oAttr.dropSame(poInitAttr);
                    }
                    if (!oAttr.isEmpty()) {
                        oMarkup.attr(oAttr);
                    }
                }
            }
        }
        int nMinor = oBase.minor();
        for (int nMajor = oBase.major(); nMajor < oEnd.major() || nMajor == oEnd.major() && nMinor < oEnd.minor(); ++nMajor) {
            int nMax = nMajor == oEnd.major() ? oEnd.minor() : this.getItem(nMajor).count();
            this.getItem(nMajor).markup(oMarkup, nMinor, nMax - nMinor, bFlattenFields, poPrevAttr);
            nMinor = 0;
        }
    }

    void rangeMarkup(TextPosn oStart, MarkupIn oMarkup) {
        TextPosn oPosn = new TextPosn(oStart);
        oMarkup.setup(oPosn, this.moGfxSource);
        oMarkup.translate();
    }

    public TextMarker rangeMarker(TextPosn oStart, TextPosn oEnd, TextMarker poMarker) {
        TextMarker poCopy = poMarker.cloneMarker();
        this.rangeMarkerInternal(oStart, oEnd, poCopy);
        return poCopy;
    }

    public void rangeMarkerInternal(TextPosnBase oStart, TextPosnBase oEnd, TextMarker poMarker) {
        TextRange oRange = new TextRange(this, oStart.index(), oEnd.index());
        if (poMarker.isParaMarker()) {
            oRange.grabPara();
        }
        oRange.tighten();
        PosnMarker poLocation = new PosnMarker(oRange.start(), poMarker, 1);
        PosnMarker poEndLoc = new PosnMarker(oRange.end(), poMarker, 0);
        poLocation.setMate(poEndLoc);
        poEndLoc.setMate(poLocation);
        poMarker.setLocation(poLocation);
        if (poMarker.getSplitState() == 1) {
            this.splitParaMarkers(oRange, poMarker);
        }
    }

    public void rangeEnumMarker(TextPosnBase oStart, TextPosnBase oEnd, List<TextMarker> oMarkers, boolean bPositionMarkers, boolean bRangeMarkers, boolean bSubsetOnly) {
        oMarkers.clear();
        int nStart = oStart.index();
        int nEnd = oEnd.index();
        TextPosn poPosn = this.mpoAssociated;
        while (poPosn != null) {
            int nIndex = poPosn.index();
            if (poPosn.isMarkerPosition()) {
                PosnMarker poLocation = (PosnMarker)poPosn;
                PosnMarker poMate = poLocation.getMate();
                if (bPositionMarkers && poMate == null && nIndex >= nStart && nIndex <= nEnd) {
                    oMarkers.add(poLocation.getMarker());
                }
                if (bRangeMarkers && poMate != null) {
                    int nMateIndex = poMate.index();
                    boolean bProcess = false;
                    if (nIndex < nMateIndex) {
                        bProcess = true;
                    } else if (nIndex == nMateIndex) {
                        boolean bl = bProcess = poLocation.position() == 1;
                    }
                    if (bProcess) {
                        if (bSubsetOnly) {
                            bProcess = nIndex >= nStart && nMateIndex <= nEnd;
                        } else {
                            boolean bl = bProcess = nIndex <= nEnd && nMateIndex >= nStart;
                        }
                        if (bProcess) {
                            oMarkers.add(poLocation.getMarker());
                        }
                    }
                }
            }
            poPosn = poPosn.mpoNext;
        }
    }

    public TextMarker splitMarker(TextMarker poSource, int nSplitStart, int nSplitEnd, int eMarkerSplitReason) {
        TextMarker poNewMarker = null;
        PosnMarker poMarkerStart = poSource.getLocation();
        int nMarkerStart = poMarkerStart.index();
        PosnMarker poMarkerEnd = poMarkerStart.getMate();
        int nMarkerEnd = poMarkerEnd.index();
        if (nMarkerStart >= nSplitEnd || nMarkerEnd <= nSplitStart) {
            return null;
        }
        TextPosnBase oStart = new TextPosnBase(this, nSplitStart);
        oStart.tighten(false);
        nSplitStart = oStart.index();
        TextPosnBase oEnd = new TextPosnBase(this, nSplitEnd);
        oEnd.tighten(false);
        nSplitEnd = oEnd.index();
        if (nSplitStart <= nMarkerStart) {
            if (nSplitEnd >= nMarkerEnd) {
                if (poSource.getAutoRemove()) {
                    this.removeMarker(poSource, true);
                }
            } else {
                int[] markers = new int[]{nSplitStart, nSplitEnd};
                TextStream.intersectMarkerRange(poSource, markers);
                nSplitStart = markers[0];
                nSplitEnd = markers[1];
                if (poSource.onTruncate(nSplitStart, nSplitEnd, false, eMarkerSplitReason)) {
                    poMarkerStart.setMarkerIndex(nSplitEnd);
                }
            }
        } else if (nSplitEnd >= nMarkerEnd) {
            int[] markers = new int[]{nSplitStart, nSplitEnd};
            TextStream.intersectMarkerRange(poSource, markers);
            nSplitStart = markers[0];
            nSplitEnd = markers[1];
            if (poSource.onTruncate(nSplitStart, nSplitEnd, true, eMarkerSplitReason)) {
                poMarkerEnd.setMarkerIndex(nSplitStart);
            }
        } else {
            poNewMarker = poSource.onSplit(nSplitStart, nSplitEnd, eMarkerSplitReason);
            if (poNewMarker != null) {
                TextPosnBase oNewStart = new TextPosnBase(this, nSplitEnd);
                oNewStart.tighten(true);
                this.rangeMarkerInternal(oNewStart, poMarkerEnd, poNewMarker);
                poMarkerEnd.setMarkerIndex(nSplitStart);
            }
        }
        return poNewMarker;
    }

    public boolean coalesceMarker(TextMarker poFirst, TextMarker poOther) {
        int nEnd;
        if (!poFirst.onCoalesce(poOther)) {
            return false;
        }
        PosnMarker poFirstStart = poFirst.getLocation();
        int nFirstStart = poFirstStart.index();
        PosnMarker poFirstEnd = poFirstStart.getMate();
        int nFirstEnd = poFirstEnd == null ? nFirstStart : poFirstEnd.index();
        PosnMarker poOtherStart = poOther.getLocation();
        int nOtherStart = poOtherStart.index();
        PosnMarker poOtherEnd = poOtherStart.getMate();
        int nOtherEnd = poOtherEnd == null ? nOtherStart : poOtherEnd.index();
        int nStart = nFirstStart < nOtherStart ? nFirstStart : nOtherStart;
        int n = nEnd = nFirstEnd > nOtherEnd ? nFirstEnd : nOtherEnd;
        if (nStart != nFirstStart) {
            poFirstStart.setMarkerIndex(nFirstStart);
        }
        if (poFirstEnd == null) {
            poFirstEnd = new PosnMarker(poFirst);
            poFirstEnd.position(0);
            poFirstEnd.index(nFirstEnd);
            poFirstStart.setMate(poFirstEnd);
            poFirstEnd.setMate(poFirstStart);
        } else if (nEnd != nFirstEnd) {
            poFirstEnd.setMarkerIndex(nFirstEnd);
        }
        if (poOther.getAutoRemove()) {
            this.removeMarker(poOther, true);
        } else {
            poOtherStart.setMarkerIndex(nEnd);
            if (poOtherEnd != null) {
                poOtherEnd.setMarkerIndex(nEnd);
            }
        }
        return true;
    }

    public void removeMarker(TextMarker poRemove, boolean bEditOnly) {
        PosnMarker poLocation = poRemove.getLocation();
        if (poLocation != null) {
            poRemove.setLocation(null);
        }
        poRemove.onRemove(bEditOnly);
    }

    public TextMarker findRangeMarkerOver(int nIndex, int nSpan) {
        int nEnd = nIndex + nSpan;
        TextPosn poPosn = this.mpoAssociated;
        while (poPosn != null) {
            PosnMarker poLocation;
            PosnMarker poMate;
            if (poPosn.isMarkerPosition() && (poMate = (poLocation = (PosnMarker)poPosn).getMate()) != null && poLocation.index() <= nIndex && poMate.index() >= nEnd) {
                TextMarker poMarker = poLocation.getMarker();
                return poMarker;
            }
            poPosn = poPosn.mpoNext;
        }
        return null;
    }

    void textDisplaySet(TextDisplay poTextDisplay) {
        this.mpoDisplay = poTextDisplay;
    }

    List<StrItem> items() {
        return this.moItems;
    }

    void suppressAutoLoad(boolean bSuppress) {
        this.mnSuppressAutoLoad = bSuppress ? ++this.mnSuppressAutoLoad : --this.mnSuppressAutoLoad;
    }

    boolean isAutoLoadSuppressed() {
        return this.mnSuppressAutoLoad != 0;
    }

    public void debug() {
        this.debug(0);
    }

    void debug(int indent) {
        System.out.println(Pkg.doIndent(++indent) + "Text stream content:");
        for (int i = 0; i < this.moItems.size(); ++i) {
            this.getItem(i).debug(indent);
        }
    }

    protected boolean updateDisplay(boolean bJustifyOnly) {
        boolean bFit = true;
        if (this.mpoDisplay != null) {
            if (bJustifyOnly) {
                this.mpoDisplay.updateJustify();
            } else {
                bFit = this.mpoDisplay.update();
            }
        }
        return bFit;
    }

    protected boolean updateDisplay() {
        return this.updateDisplay(false);
    }

    protected void cleanupContent(boolean bReinitialize) {
        if (this.mpoDisplay != null) {
            this.mpoDisplay.detach(this);
            this.mpoDisplay = null;
        }
        TextPosn poPosn = this.mpoAssociated;
        while (poPosn != null) {
            TextPosn poCleanup = poPosn;
            poPosn = poPosn.mpoNext;
            if (poCleanup.isMarkerPosition()) {
                PosnMarker poLocation = (PosnMarker)poCleanup;
                TextMarker poMarker = poLocation.getMarker();
                if (poMarker != null) {
                    poMarker.setLocation(null);
                    this.removeMarker(poMarker, false);
                    PosnMarker poMate = poLocation.getMate();
                    if (poMate != null) {
                        poMate.setMarker(null);
                    }
                }
                poCleanup.mpoStream = null;
                continue;
            }
            poCleanup.cleanup();
            poCleanup.mpoNext = null;
        }
        this.mpoAssociated = null;
        this.moItems.setSize(0);
        this.mpoTempAttr = null;
        if (bReinitialize) {
            this.initialize(null);
        }
    }

    private void initialize(String psSourceText) {
        this.mpoAssociated = null;
        this.mnCount = 0;
        this.mpoDisplay = null;
        this.mpoTempAttr = null;
        this.mnMaxSize = 0;
        this.mnSuppressAutoLoad = 0;
        this.mbAllowNewLines = true;
        StrText poText = null;
        StrEnd poEnd = null;
        int nSize = 1;
        poEnd = StrEnd.newObject();
        if (psSourceText != null && psSourceText.length() > 0) {
            poText = new StrText(psSourceText);
            ++nSize;
        }
        this.moItems.setSize(nSize);
        this.mnCount = 0;
        if (poText != null) {
            this.moItems.set(nSize - 2, poText);
            this.mnCount = poText.count();
        }
        this.moItems.set(nSize - 1, poEnd);
    }

    private void insertTest(int nSize) {
        if (this.mnMaxSize <= 0 || nSize > this.spaceLeft()) {
            // empty if block
        }
    }

    private void insert(TextPosnBase oPosn, StrItem poInsert, boolean bTestSpace, int eMarkerSplitReason) {
        int nIndex = oPosn.index();
        int nCount = poInsert.count();
        this.insertTest(nCount);
        boolean bFit = this.insert(oPosn, poInsert, 0, eMarkerSplitReason);
        if (bTestSpace && !bFit) {
            TextPosnBase oRemovePosn = new TextPosnBase(this, nIndex);
            oRemovePosn.deleteAhead(nCount);
            return;
        }
    }

    private boolean insert(TextPosnBase oPosn, StrItem poInsert, int eUpdate, int eMarkerSplitReason) {
        int nCount = poInsert.count();
        if (oPosn.minor() == 0) {
            this.moItems.add(oPosn.major(), poInsert);
        } else {
            StrItem poItem = this.getItem(oPosn.major());
            StrItem[] split = poItem.split(oPosn.minor());
            StrItem poBefore = split[0];
            StrItem poAfter = split[1];
            nCount -= poItem.count() - (poBefore.count() + poAfter.count());
            this.moItems.setSize(this.moItems.size() + 2);
            for (int i = this.moItems.size() - 3; i > oPosn.major(); --i) {
                this.moItems.set(i + 2, this.moItems.get(i));
            }
            this.moItems.set(oPosn.major(), poBefore);
            this.moItems.set(oPosn.major() + 1, poInsert);
            this.moItems.set(oPosn.major() + 2, poAfter);
        }
        int eItem = poInsert.strType();
        boolean bOther = eItem != 2 && eItem != 4;
        return this.completeInsert(oPosn.mnIndex, nCount, bOther, eMarkerSplitReason, false, eUpdate);
    }

    private void delete(TextPosnBase oPosn, int nDelete, boolean bRaw, int eUpdate) {
        int i;
        if (nDelete == 0) {
            return;
        }
        TextPosnBase oAttrPosn = new TextPosnBase();
        boolean bPara = false;
        if (!bRaw) {
            TextPosnBase oSearch = new TextPosnBase(this, oPosn.index() + nDelete);
            while (oSearch.gt(oPosn)) {
                switch (oSearch.prev()) {
                    case 1: {
                        if (oAttrPosn.stream() != null) break;
                        oAttrPosn = oSearch;
                        break;
                    }
                    case 5: {
                        bPara = true;
                    }
                }
            }
        }
        if (oAttrPosn != null || bPara) {
            // empty if block
        }
        int nDelStart = oPosn.index();
        int nDelEnd = nDelStart + nDelete;
        TextRange oMarkerRange = new TextRange(this, nDelStart, nDelEnd);
        Storage<TextMarker> oMarkers = new Storage<TextMarker>();
        oMarkerRange.enumerateMarkers(oMarkers, true, true, false);
        for (i = 0; i < oMarkers.size(); ++i) {
            int nMarkerEnd;
            TextMarker poMarker = (TextMarker)oMarkers.get(i);
            if (!poMarker.getAutoRemove()) continue;
            PosnMarker poLocation = poMarker.getLocation();
            PosnMarker poMate = poLocation.getMate();
            int nMarkerStart = poLocation.index();
            int n = nMarkerEnd = poMate == null ? nMarkerStart : poMate.index();
            if (nMarkerStart > nMarkerEnd) {
                int nSwap = nMarkerStart;
                nMarkerStart = nMarkerEnd;
                nMarkerEnd = nSwap;
            }
            if (nMarkerStart < nDelStart || nMarkerEnd > nDelEnd) continue;
            this.removeMarker(poMarker, true);
            oMarkers.set(i, null);
        }
        TextAttr poParaAttr = null;
        TextRange oRange = null;
        if (oAttrPosn.stream() == null) {
            this.delete2(oPosn, nDelete, eUpdate);
        } else {
            int nBefore = oAttrPosn.index() - oPosn.index();
            int nAfter = nDelete - nBefore - 1;
            if (nBefore == 0 && nAfter == 0) {
                nAfter = 1;
            }
            oAttrPosn.next();
            this.delete2(oAttrPosn, nAfter, 0);
            this.delete2(oPosn, nBefore, 0);
        }
        if (bPara) {
            oRange = new TextRange();
            oRange.associate(this, oPosn.index(), oPosn.index() + nDelete);
            oRange.grabPara();
            oRange.tighten();
            if (oRange.start().index() < oPosn.index()) {
                TextAttr oBefore = oRange.start().attribute();
                poParaAttr = new TextAttr(oBefore);
                poParaAttr.isolatePara(true, this.hasLegacyPositioning());
            }
            for (i = 0; i < oMarkers.size(); ++i) {
                PosnMarker poLocation;
                PosnMarker poMate;
                TextMarker poMarker = (TextMarker)oMarkers.get(i);
                if (poMarker == null || !poMarker.isParaMarker() || (poMate = (poLocation = poMarker.getLocation()).getMate()) == null) continue;
                oMarkerRange.associate(this, poLocation.index(), poMate.index());
                oMarkerRange.grabPara();
                poLocation = (PosnMarker)oMarkerRange.start();
                poMate = (PosnMarker)oMarkerRange.end();
            }
        }
        if (poParaAttr != null) {
            if (oRange != null) {
                oRange.attribute(poParaAttr);
            }
        } else {
            int eNext;
            TextPosnBase oTest;
            if (!bRaw && (oTest = new TextPosnBase(oPosn)).prev(true) == 1 && (eNext = oTest.next(true)) == 0) {
                this.updateTempAttr(new TextRange(this, oTest.mnIndex, oTest.mnIndex));
                eUpdate |= 2;
            }
            this.completeUpdate(eUpdate);
        }
    }

    private void delete2(TextPosnBase oPosn, int nDelete, int eUpdate) {
        int nActual = this.mnCount - oPosn.mnIndex;
        if (nActual > nDelete) {
            nActual = nDelete;
        }
        if (nActual == 0) {
            return;
        }
        Storage<TextMarker> oMarkers = new Storage<TextMarker>();
        int nStart = oPosn.index();
        int nEnd = nStart + nDelete;
        this.enumerateOverlappingRangeMarkers(nStart, nEnd, oMarkers);
        for (int i = 0; i < oMarkers.size(); ++i) {
            int[] markers;
            TextMarker poMarker = (TextMarker)oMarkers.get(i);
            if (!TextStream.intersectMarkerRange(poMarker, markers = new int[]{nStart, nEnd})) continue;
            poMarker.onDeleteContent(markers[0], markers[1]);
        }
        int nMajor = oPosn.major();
        int nMinor = oPosn.minor();
        int nThisTime = 0;
        Storage oDeleteItems = new Storage();
        for (int nLeft = nActual; nLeft > 0; nLeft -= nThisTime) {
            StrItem poItem = this.getItem(nMajor);
            int nCount = poItem.count();
            if (nMinor > 0 || nLeft < nCount) {
                nThisTime = nCount - nMinor;
                if (nThisTime > nLeft) {
                    nThisTime = nLeft;
                }
                poItem.delete(nMinor, nThisTime);
                nMinor = 0;
                ++nMajor;
                continue;
            }
            this.moItems.remove(nMajor);
            oDeleteItems.add(poItem);
            nThisTime = nCount;
        }
        this.completeDelete(oPosn.mnIndex, nActual, eUpdate | 3);
    }

    private void loadText(LoadText oLoader) {
        int i;
        int nOldSize = this.moItems.size() - 1;
        StrItem poEndMarker = this.getItem(nOldSize);
        this.moItems.setSize(nOldSize);
        int nNewSize = oLoader.size();
        int nNewCount = 0;
        this.moItems.setSize(nNewSize + 1);
        for (i = 0; i < nNewSize; ++i) {
            StrItem poItem = oLoader.nextItem();
            this.moItems.set(i, poItem);
            nNewCount += poItem.count();
        }
        this.moItems.set(i, poEndMarker);
        this.mnCount = nNewCount;
        this.mnMaxSize = oLoader.maxSize();
        this.mbAllowNewLines = oLoader.allowNewLines();
        this.completeUpdate(0, false, 0, 0, false);
        this.setEmbedPositions();
    }

    private int[] posnMove(TextPosnBase oPosn, boolean bNext, int eNullFrameMode, boolean bTestOnly) {
        StrItem poItem;
        int nCharMinor;
        int eReturn = 0;
        int cSpanned = 0;
        int nMajor = oPosn.major();
        int nMinor = oPosn.minor();
        int nIndex = oPosn.mnIndex;
        boolean bFirst = true;
        while (true) {
            int nOldIndex = nIndex;
            nCharMinor = nMinor++;
            poItem = null;
            if (bNext) {
                if (nIndex >= this.posnCount()) {
                    return null;
                }
                poItem = this.getItem(nMajor);
                eReturn = poItem.strType();
                ++nIndex;
                if (nMinor >= poItem.count()) {
                    ++nMajor;
                    nMinor = 0;
                }
            } else {
                if (nIndex == 0) {
                    return null;
                }
                --nIndex;
                if (nMinor > 0) {
                    --nMinor;
                    poItem = this.getItem(nMajor);
                } else {
                    poItem = this.getItem(--nMajor);
                    nMinor = poItem.count() - 1;
                }
                nCharMinor = nMinor;
                eReturn = poItem.strType();
            }
            if (eReturn != 6 || eNullFrameMode == 1) break;
            if (eNullFrameMode == 3 || this.mnSuppressAutoLoad > 0 && eNullFrameMode != 2) {
                return null;
            }
            if (eNullFrameMode != 0) continue;
            TextPosn oSafeIter = new TextPosn();
            if (bNext) {
                oSafeIter.associate(oPosn.stream(), nOldIndex, 1);
                oSafeIter.tighten(false);
            } else {
                oSafeIter.associate(oPosn.stream(), nOldIndex, 0);
                oSafeIter.tighten(true);
            }
            boolean bTightened = oSafeIter.index() != nOldIndex;
            TextPosn oSafePosn = null;
            if (!bNext) {
                oSafePosn = new TextPosn(oPosn.stream(), oPosn.index(), 0);
            }
            TextNullFrame poNullFrame = poItem.nullFrameAt(nMinor);
            assert (poNullFrame != null);
            if (bTightened) {
                oSafeIter.tighten(bNext);
            }
            if (bNext) {
                if (bFirst) {
                    bFirst = false;
                    oPosn.associate(oPosn.stream(), oSafeIter.index());
                }
            } else {
                oPosn.index(oSafePosn.index());
            }
            nMajor = oSafeIter.major();
            nMinor = oSafeIter.minor();
            nIndex = oSafeIter.mnIndex;
        }
        cSpanned = poItem.charAt(nCharMinor);
        if (!bTestOnly) {
            oPosn.mnMajor = nMajor;
            oPosn.mnMinor = nMinor;
            oPosn.mnIndex = nIndex;
            if (eReturn != 1) {
                oPosn.cleanupTarget();
            }
        }
        int[] result = new int[]{eReturn, cSpanned};
        return result;
    }

    private boolean posnSearchForward(TextPosnBase oPosn, int eSearch, int eNullFrameMode) {
        int eType;
        while ((eType = this.posnNextType(oPosn, eNullFrameMode)) != 0) {
            if (eType == eSearch) {
                return true;
            }
            StrItem poItem = this.getItem(oPosn.major());
            if (poItem.strType() == 0) {
                return false;
            }
            if (oPosn.minor() <= 0) continue;
            oPosn.mnIndex = oPosn.index() - oPosn.minor() + poItem.count();
            ++oPosn.mnMajor;
            oPosn.mnMinor = 0;
        }
        return false;
    }

    private boolean posnSearchForward(TextPosnBase oPosn, int eSearch) {
        return this.posnSearchForward(oPosn, eSearch, 0);
    }

    private boolean posnSearchBackward(TextPosnBase oPosn, int eSearch, int eNullFrameMode) {
        int eType;
        while ((eType = this.posnPrevType(oPosn, eNullFrameMode)) != 0) {
            if (eType == eSearch) {
                return true;
            }
            if (oPosn.minor() <= 0) continue;
            oPosn.mnIndex -= oPosn.minor();
            oPosn.mnMinor = 0;
        }
        return false;
    }

    private boolean posnSearchBackward(TextPosnBase oPosn, int eSearch) {
        return this.posnSearchBackward(oPosn, eSearch, 0);
    }

    private void rangeAttr(TextPosn oStart, TextPosn oEnd, TextAttr oNewAttr, int eUpdate) {
        TextAttr poFullAttr = new TextAttr(oNewAttr, this.moGfxSource);
        TextAttr poRestoreAttr = null;
        TextAttr poPrevAttr = this.posnAttrPtr(oStart);
        if (poPrevAttr != null) {
            poFullAttr.addDisabled(poPrevAttr);
            if (oEnd.mnIndex < this.mnCount) {
                poRestoreAttr = this.posnAttrPtr(oEnd);
            }
        }
        StrAttr poItemChange = null;
        StrAttr poItemRestore = null;
        boolean bRestoreInserted = false;
        this.updateTempAttr(null);
        poItemChange = new StrAttr(poFullAttr);
        this.insert((TextPosnBase)oStart, (StrItem)poItemChange, 1, -1);
        if (poRestoreAttr != null) {
            poItemRestore = new StrAttr(poRestoreAttr, this.moGfxSource);
            this.insert((TextPosnBase)oEnd, (StrItem)poItemRestore, 1, -1);
            bRestoreInserted = true;
        }
        oStart.next();
        if (bRestoreInserted) {
            oEnd.prev();
        }
        int nSearch = oStart.major();
        int nIndex = oStart.mnIndex;
        int nSize = this.moItems.size();
        while (nSearch < oEnd.major() && nSearch < nSize) {
            StrItem poItem = this.getItem(nSearch);
            if (poItem.strType() == 1) {
                poItem.overrideAttr(oNewAttr);
            }
            ++nSearch;
            nIndex += poItem.count();
        }
        if (oStart.mnIndex == oEnd.mnIndex) {
            this.updateTempAttr(new TextRange(this, oStart.mnIndex, oEnd.mnIndex));
        }
        if (this.display() != null) {
            this.display().updateOther(this, oStart.index(), oEnd.index() - oStart.index());
        }
        this.completeUpdate(eUpdate | 2);
    }

    private void remove(int nItemIndex, int nPosnIndex, int nRemoveCount) {
        this.moItems.remove(nItemIndex);
        this.mnCount -= nRemoveCount;
        this.updatePositions(nPosnIndex, nRemoveCount, false, 0);
    }

    private void setEmbedPositions() {
        int nIndex = 0;
        int nSize = this.moItems.size();
        for (int i = 0; i < nSize; ++i) {
            StrItem poItem = this.getItem(i);
            TextField poField = poItem.fieldAt(0);
            TextEmbed poEmbed = poItem.embedAt(0);
            if (poField != null) {
                poField.positionSet(this, nIndex);
            } else if (poEmbed != null) {
                poEmbed.position(new TextPosn(this, nIndex, 0));
            }
            nIndex += poItem.count();
        }
    }

    private boolean completeInsert(int nIndex, int nChange, boolean bOther, int eMarkerSplitReason, boolean bTighten, int eUpdate) {
        this.completeUpdate(eUpdate, true, nIndex, nChange, bTighten);
        if (nChange > 0 && eMarkerSplitReason != -1) {
            TextRange oRange = new TextRange(this, nIndex, nIndex + nChange);
            oRange.tighten();
            if (!oRange.isEmpty()) {
                int nSplitStart = oRange.start().index();
                int nSplitEnd = oRange.end().index();
                Storage<TextMarker> oMarkers = new Storage<TextMarker>();
                oRange.enumerateMarkers(oMarkers);
                for (int i = 0; i < oMarkers.size(); ++i) {
                    TextMarker poMarker = (TextMarker)oMarkers.get(i);
                    if (!poMarker.isRangeMarker() || poMarker.getSplitState() != 2) continue;
                    poMarker.forceSplit(nSplitStart, nSplitEnd, eMarkerSplitReason);
                }
            }
        }
        boolean bFit = true;
        if (this.mpoDisplay != null && (eUpdate & 4) == 0) {
            bFit = bOther ? this.mpoDisplay.updateOther(this, nIndex, 0) : this.mpoDisplay.updateInsert(this, nIndex, nChange);
        }
        this.updateNotification();
        return bFit;
    }

    private boolean completeDelete(int nIndex, int nChange, int eUpdate) {
        this.completeUpdate(eUpdate, false, nIndex, nChange, false);
        boolean bFit = true;
        if (this.mpoDisplay != null && (eUpdate & 4) == 0) {
            bFit = this.mpoDisplay.updateDelete(this, nIndex, nChange);
        }
        this.coalesceAdjacentMarkers(nIndex);
        this.updateNotification();
        return bFit;
    }

    private void completeUpdate(int eUpdate) {
        this.completeUpdate(eUpdate, false, 0, 0, false);
    }

    private void completeUpdate(int eUpdate, boolean bInsert, int nIndex, int nChange, boolean bTighten) {
        this.mnCount = bInsert ? (this.mnCount += nChange) : (this.mnCount -= nChange);
        int nPosnChange = nChange;
        int eUpdatePosn = 1;
        if (bTighten) {
            eUpdatePosn = 2;
            if (bInsert && nPosnChange > 0) {
                --nPosnChange;
            }
        }
        this.updatePositions(nIndex, nPosnChange, bInsert, eUpdatePosn);
        if ((eUpdate & 2) == 0) {
            this.updateTempAttr(null);
        }
        if ((eUpdate & 1) == 0) {
            int nReconcileIndex = 0;
            TextAttr poPrevAttr = null;
            int nLastAttr = 0;
            int nLastAttrIndex = 0;
            int i = 1;
            while (i < this.moItems.size()) {
                boolean bAdvance = true;
                StrItem poPrev = this.getItem(i - 1);
                StrItem poNext = this.getItem(i);
                if (poPrev.strType() == poNext.strType() && poPrev.canCoalesce(poNext)) {
                    int nPrev = poPrev.count();
                    int nNext = poNext.count();
                    int nOldCount = nPrev + nNext;
                    if (poPrev.coalesce(poNext, nReconcileIndex)) {
                        this.remove(i, nReconcileIndex + nPrev, nNext);
                        this.remove(i - 1, nReconcileIndex, nPrev);
                        if (i > 1) {
                            --i;
                        }
                    } else {
                        nPrev = poPrev.count();
                        int nDiff = nOldCount - nPrev;
                        this.remove(i, nReconcileIndex + nPrev, nDiff);
                    }
                    bAdvance = false;
                } else {
                    TextAttr poAttr = poPrev.attrAt(0);
                    if (poAttr == null) {
                        if (poPrev.strType() != 0) {
                            nLastAttr = 0;
                        }
                    } else if (poPrevAttr != null && poPrevAttr != poAttr && poPrevAttr == poAttr) {
                        this.remove(--i, nReconcileIndex, poPrev.count());
                        this.coalesceAdjacentMarkers(nReconcileIndex);
                        nReconcileIndex -= this.getItem(i - 1).count();
                        if (i == 1) {
                            poPrevAttr = null;
                        }
                        bAdvance = false;
                    } else {
                        poPrevAttr = poAttr;
                        if (nLastAttr == 0) {
                            nLastAttr = i - 1;
                            nLastAttrIndex = nReconcileIndex;
                        }
                    }
                }
                if (!bAdvance) continue;
                ++i;
                nReconcileIndex += poPrev.count();
            }
            if (nLastAttr > 0) {
                int nSize = this.moItems.size();
                while (nLastAttr < nSize - 1) {
                    StrItem poItem = this.getItem(nLastAttr);
                    int nCount = poItem.count();
                    if (poItem.attrState() == 1) {
                        nLastAttrIndex += nCount;
                        ++nLastAttr;
                        continue;
                    }
                    this.remove(nLastAttr, nLastAttrIndex, nCount);
                    --nSize;
                }
            }
        }
    }

    private void updatePositions(int nIndex, int nChange, boolean bInsert, int eUpdate) {
        int nItemEnd;
        if (nChange == 0 && eUpdate != 0) {
            return;
        }
        if (nIndex > this.posnCount()) {
            nIndex = this.posnCount();
        }
        int nChangeStartIndex = 0;
        for (int i = 0; i < this.moItems.size() && nIndex > (nItemEnd = nChangeStartIndex + this.getItem(i).count()); ++i) {
            nChangeStartIndex = nItemEnd;
        }
        TextPosn poPosn = this.mpoAssociated;
        while (poPosn != null) {
            if (poPosn.mnIndex >= nChangeStartIndex) {
                if (bInsert) {
                    if (poPosn.mnIndex > nIndex || poPosn.mnIndex == nIndex && poPosn.position() == 0) {
                        poPosn.mnIndex += nChange;
                    }
                } else if (poPosn.mnIndex > nIndex) {
                    int nMove = poPosn.mnIndex - nIndex;
                    if (nMove > nChange) {
                        nMove = nChange;
                    }
                    poPosn.mnIndex -= nMove;
                }
                poPosn.invalidate(eUpdate == 2);
            }
            poPosn = poPosn.mpoNext;
        }
    }

    private void updateTempAttr(TextRange poNewTempAttr) {
        if (poNewTempAttr == this.mpoTempAttr) {
            return;
        }
        if (this.mpoTempAttr != null) {
            this.updateAttrRange(this.mpoTempAttr, 0, 0);
            this.mpoTempAttr = null;
        }
        if (poNewTempAttr != null) {
            this.mpoTempAttr = poNewTempAttr;
            this.updateAttrRange(this.mpoTempAttr, 1, 2);
        }
    }

    private void updateAttrRange(TextRange oRange, int eStart, int eEnd) {
        int nStart = oRange.position(2).index();
        int nEnd = oRange.position(3).index();
        if (nStart > 0) {
            this.updateAttrState(--nStart, eStart);
        }
        if (nEnd < this.mnCount) {
            this.updateAttrState(nEnd, eEnd);
        }
    }

    private void updateAttrState(int nIndex, int eState) {
        TextPosnBase oPosn = new TextPosnBase(this, nIndex);
        StrItem poItem = this.getItem(oPosn.mnMajor);
        poItem.attrState(eState);
    }

    private void updateGfxSource() {
        int nSize = this.moItems.size();
        for (int i = 0; i < nSize; ++i) {
            this.getItem(i).gfxSource(this.moGfxSource);
        }
    }

    final StrItem getItem(int index) {
        return (StrItem)this.moItems.get(index);
    }

    private void splitParaMarkers(TextRange oRange, TextMarker poCandidate) {
        TextRange oMarkerRange = new TextRange(oRange);
        oMarkerRange.tighten();
        TextPosnBase oParaPosn = new TextPosnBase(oMarkerRange.start());
        Storage<TextMarker> oMarkers = new Storage<TextMarker>();
        if (poCandidate != null) {
            oMarkers.add(poCandidate);
        }
        while (oParaPosn.nextPara(2)) {
            int nSplitEnd = oParaPosn.index();
            oParaPosn.tighten(false);
            if (oParaPosn.index() > oMarkerRange.end().index()) break;
            TextPosnBase oPrev = new TextPosnBase(oParaPosn);
            oPrev.prev();
            oPrev.tighten(false);
            int nSplitStart = oPrev.index();
            TextRange oParaRange = new TextRange(this, oPrev.index(), nSplitEnd);
            if (poCandidate == null) {
                oParaRange.enumerateMarkers(oMarkers, false, true, false);
            }
            for (int i = 0; i < oMarkers.size(); ++i) {
                TextMarker poMarker = (TextMarker)oMarkers.get(i);
                if (poMarker.getSplitState() != 1) continue;
                poMarker.forceSplit(nSplitStart, nSplitEnd, 6);
            }
        }
    }

    private void coalesceAdjacentMarkers(int nIndex) {
        Storage oBefore = new Storage();
        Storage oAfter = new Storage();
        TextPosn poPosn = this.mpoAssociated;
        while (poPosn != null) {
            PosnMarker poMate;
            PosnMarker poLocation;
            TextMarker poMarker;
            if (poPosn.isMarkerPosition() && (poMarker = (poLocation = (PosnMarker)poPosn).getMarker()) != null && poLocation == poMarker.getLocation() && poMarker.getAutoCoalesce() && (poMate = poLocation.getMate()) != null && poLocation.index() != poMate.index()) {
                if (poMate.index() == nIndex) {
                    oBefore.add(poMarker);
                } else if (poLocation.index() == nIndex) {
                    oAfter.add(poMarker);
                }
            }
            poPosn = poPosn.mpoNext;
        }
        if (oAfter.size() == 0) {
            return;
        }
        block1: for (int i = 0; i < oBefore.size(); ++i) {
            TextMarker poBefore = (TextMarker)oBefore.get(i);
            for (int j = 0; j < oAfter.size(); ++j) {
                TextMarker poAfter = (TextMarker)oAfter.get(j);
                if (!poBefore.canCoalesce(poAfter) || !this.coalesceMarker(poBefore, poAfter)) continue;
                oAfter.set(j, null);
                continue block1;
            }
        }
    }

    private void enumerateOverlappingRangeMarkers(int nStart, int nEnd, Storage<TextMarker> oMarkers) {
        oMarkers.setSize(0);
        TextRange oRange = new TextRange(this, nStart, nEnd);
        oRange.tighten();
        if (oRange.isEmpty()) {
            return;
        }
        nStart = oRange.start().index();
        nEnd = oRange.end().index();
        oRange.enumerateMarkers(oMarkers);
        int i = 0;
        while (i < oMarkers.size()) {
            PosnMarker poLocation;
            TextMarker poMarker = (TextMarker)oMarkers.get(i);
            boolean bKeep = false;
            if (poMarker.isRangeMarker() && (poLocation = poMarker.getLocation()).index() < nEnd && poLocation.getMate().index() > nStart) {
                bKeep = true;
            }
            if (bKeep) {
                ++i;
                continue;
            }
            oMarkers.remove(i);
        }
    }

    private static boolean intersectMarkerRange(TextMarker poMarker, int[] markers) {
        PosnMarker poLocation = poMarker.getLocation();
        if (poLocation == null) {
            return false;
        }
        int nMarkerStart = poLocation.index();
        PosnMarker poMate = poLocation.getMate();
        int nMarkerEnd = poMate == null ? nMarkerStart : poMate.index();
        int nStart = markers[0];
        int nEnd = markers[1];
        if (nStart > nMarkerEnd || nEnd < nMarkerStart) {
            return false;
        }
        if (nStart < nMarkerStart) {
            nStart = nMarkerStart;
        }
        if (nEnd > nMarkerEnd) {
            nEnd = nMarkerEnd;
        }
        markers[0] = nStart;
        markers[1] = nEnd;
        return true;
    }
}

