/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text.markup;

import com.adobe.xfa.gfx.GFXColour;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextBaselineShift;
import com.adobe.xfa.text.TextMeasurement;
import com.adobe.xfa.text.TextTab;
import com.adobe.xfa.text.TextTabList;
import com.adobe.xfa.text.markup.MarkupAttr;
import com.adobe.xfa.text.markup.MarkupEngineIn;
import com.adobe.xfa.text.markup.RTFAttr;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.ut.UnitSpan;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MarkupRtfIn
extends MarkupEngineIn {
    private static final String gsBlue = "\\blue";
    private static final String gsCodePage = "\\ansicpg";
    private static final String gsColourtbl = "{\\colortbl";
    private static final String gsGreen = "\\green";
    private static final String gsPt = "pt";
    private static final String gsRed = "\\red";
    private static final String gsSkip = " ";
    private static final String gsStyleSheet = "{\\stylesheet";
    private static final String gsTab = "\t";
    private final Map<Integer, TextAttr> moStyleSheets = new HashMap<Integer, TextAttr>();
    private boolean mbCollectingStyle = false;
    private int mnStyleNum;
    private final Map<Integer, String> moFontMap = new HashMap<Integer, String>();
    private final Map<Integer, Integer> moFontCharset = new HashMap<Integer, Integer>();
    private final List<GFXColour> moColourTable = new ArrayList<GFXColour>();
    private int mnDefaultFont;
    private int mnUC_count = 1;

    public MarkupRtfIn(String sStrSource, MarkupAttr pMarkupAttr) {
        super(sStrSource, pMarkupAttr == null ? RTFAttr.GetDefault() : pMarkupAttr);
    }

    public MarkupRtfIn(String sStrSource) {
        this(sStrSource, null);
    }

    @Override
    public void translate() {
        StringBuilder sStrCopy = new StringBuilder(this.sourceText());
        String sStrRtfFontMap = null;
        int nPos = sStrCopy.indexOf("\n\\");
        while (nPos >= 0) {
            sStrCopy.deleteCharAt(nPos);
            nPos = sStrCopy.indexOf("\n\\");
        }
        nPos = sStrCopy.indexOf("\\par\n");
        while (nPos >= 0) {
            sStrCopy.replace(nPos + 4, nPos + 4, gsSkip);
            nPos = sStrCopy.indexOf("\\par\n");
        }
        char cPrev = '\u0000';
        for (int i = 0; i < sStrCopy.length(); ++i) {
            char c = sStrCopy.charAt(i);
            if (i > 0 && c == this.mcBlockPrefix) {
                while (cPrev == '\r' || cPrev == ' ') {
                    sStrCopy.deleteCharAt(i - 1);
                    if (--i == 0) break;
                    cPrev = sStrCopy.charAt(i - 1);
                }
            }
            if (c == this.mcBlockSuffix && cPrev != this.mcCommandPrefix && i + 1 < sStrCopy.length()) {
                char cNext = sStrCopy.charAt(i + 1);
                while (cNext == '\r' || cNext == ' ') {
                    sStrCopy.deleteCharAt(i + 1);
                    if (i == sStrCopy.length()) break;
                    cNext = sStrCopy.charAt(i + 1);
                }
            }
            if (c == '\r' && i + 1 < sStrCopy.length()) {
                sStrCopy.deleteCharAt(i);
                if (sStrCopy.charAt(i) == '\r') {
                    ++i;
                }
            }
            cPrev = sStrCopy.charAt(i);
        }
        sStrRtfFontMap = this.extractFontTableData(sStrCopy);
        String finalSource = sStrCopy.toString();
        if (sStrRtfFontMap != null) {
            int nFoundAt = finalSource.indexOf(gsCodePage);
            if (nFoundAt >= 0) {
                int nLength = 0;
                int i = nFoundAt += gsCodePage.length();
                while (Character.isDigit(finalSource.charAt(i))) {
                    ++nLength;
                    ++i;
                }
            }
            this.buildFontMap(sStrRtfFontMap);
            this.setSourceText(finalSource);
        }
        this.buildColourTable(finalSource);
        this.buildStyleSheets(finalSource);
        super.translate();
        this.flushAttr();
        this.commitPending(true);
    }

    @Override
    public String defaultTypeface() {
        return this.moFontMap.get(this.mnDefaultFont);
    }

    @Override
    public boolean skipThisCommand(int eTag) {
        return eTag == 7 || eTag == 8 || eTag == 23 || eTag == 9 || eTag == 10 || eTag == 11 || eTag == 12 || eTag == 13 || eTag == 14 || eTag == 15 || eTag == 16 || eTag == 27 && !this.mbCollectingStyle || eTag == 84;
    }

    @Override
    protected void flushAttr() {
        if (!this.textAttr().isEmpty()) {
            super.flushAttr();
        }
    }

    @Override
    protected boolean onCommand(int eTag, String sCommand) {
        boolean seUnder0 = true;
        int seUnderS = 18;
        int seUnderDbl = 34;
        int seUnderW = 19;
        boolean bCommandHandled = true;
        switch (eTag) {
            case 18: {
                this.flushText();
                break;
            }
            case 19: {
                this.flushAttr();
                this.para();
                break;
            }
            case 20: {
                TextAttr value = this.moStyleSheets.get(0);
                if (value == null) break;
                this.moCurrentAttr = value;
                break;
            }
            case 21: {
                String sTypeface = this.textAttr().typeface();
                this.textAttr().setDefault(true);
                this.textAttr().typeface(sTypeface);
                this.textAttr().size(this.defaultFontSize());
                break;
            }
            case 24: {
                byte[] cc = new byte[]{this.getHexValue(sCommand)};
                this.mbText(cc);
                break;
            }
            case 26: {
                this.mnUC_count = StringUtils.safeNumber(sCommand);
                break;
            }
            case 152: {
                this.text("\n");
                break;
            }
            case 153: {
                this.text(gsTab);
                break;
            }
            case 25: {
                Integer lUnicodeVal = StringUtils.number(sCommand);
                if (lUnicodeVal != null) {
                    this.flushAttr();
                    char c = (char)(lUnicodeVal & 0xFFFF);
                    String sOut = "";
                    sOut = sOut + c;
                    this.text(sOut);
                    if (this.mpStrSource.charAt(this.mnIndex) == ' ') {
                        ++this.mnIndex;
                    }
                    for (int j = 0; j < this.mnUC_count; ++j) {
                        char cNext = this.mpStrSource.charAt(this.mnIndex);
                        if (cNext == '\\') {
                            if (this.mpStrSource.charAt(this.mnIndex + 1) != '\'') continue;
                            this.mnIndex += 4;
                            continue;
                        }
                        ++this.mnIndex;
                    }
                }
                bCommandHandled = false;
                --this.mnIndex;
                break;
            }
            case 28: {
                this.text(" -");
                break;
            }
            case 29: {
                this.text(" --");
                break;
            }
            case 30: {
                this.text(gsSkip);
                break;
            }
            case 31: {
                this.text("  ");
                break;
            }
            case 32: {
                this.text("\u00b7");
                break;
            }
            case 33: {
                this.text("`");
                break;
            }
            case 34: {
                this.text("'");
                break;
            }
            case 35: 
            case 36: {
                this.text("\"");
                break;
            }
            case 37: {
                this.text("\n");
                break;
            }
            case 57: {
                UnitSpan oValue = this.loadNumber(sCommand);
                if (oValue.value() < 0) {
                    UnitSpan oOffset = oValue;
                    if (this.textAttr().marginLEnable()) {
                        oOffset = oOffset.add(this.textAttr().marginL().getLength());
                    }
                    this.textAttr().marginL(new TextMeasurement(oOffset));
                }
                this.textAttr().special(new TextMeasurement(oValue));
                break;
            }
            case 58: {
                if (sCommand.length() == 0) {
                    this.flushAttr();
                    break;
                }
                UnitSpan oValue = this.loadNumber(sCommand);
                if (this.textAttr().special().getLengthValue() < 0) {
                    oValue = oValue.add(this.textAttr().special().getLength());
                }
                this.textAttr().marginL(new TextMeasurement(oValue));
                break;
            }
            case 59: {
                this.textAttr().marginR(new TextMeasurement(this.loadNumber(sCommand)));
                break;
            }
            case 61: {
                this.textAttr().spaceBefore(new TextMeasurement(this.loadNumber(sCommand, 19)));
                break;
            }
            case 62: {
                this.textAttr().spaceAfter(new TextMeasurement(this.loadNumber(sCommand, 19)));
                break;
            }
            case 63: {
                UnitSpan oSpacing = this.loadNumber(sCommand, 19);
                if (oSpacing.gt(this.textAttr().size())) {
                    this.textAttr().spacing(new TextMeasurement(oSpacing));
                    break;
                }
                if (oSpacing.value() >= 0) break;
                oSpacing = new UnitSpan(oSpacing.units(), -oSpacing.value());
                this.textAttr().spacing(new TextMeasurement(oSpacing));
                break;
            }
            case 65: {
                this.commitPending(true);
                int uFontIndex = StringUtils.safeNumber(sCommand);
                this.textAttr().typeface(this.moFontMap.get(uFontIndex));
                this.charset(this.moFontCharset.get(uFontIndex));
                this.flushAttr();
                break;
            }
            case 66: {
                this.textAttr().size(this.loadNumber(sCommand, 19, this.markupAttr().pointSizeFactor()));
                this.flushAttr();
                break;
            }
            case 75: {
                int lColour = StringUtils.safeNumber(sCommand);
                this.textAttr().colour(this.moColourTable.get(lColour));
                break;
            }
            case 74: {
                int lFontIndex;
                this.mnDefaultFont = lFontIndex = StringUtils.safeNumber(sCommand);
                break;
            }
            case 77: {
                this.textAttr().weight(sCommand.length() == 0 ? 700 : 400);
                break;
            }
            case 81: 
            case 82: {
                if (sCommand.charAt(0) == '0') {
                    this.textAttr().strikeout(1);
                    break;
                }
                this.textAttr().strikeout(18);
                break;
            }
            case 79: {
                this.textAttr().italic(sCommand.length() == 0);
                break;
            }
            case 85: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                this.textAttr().underline(sCommand.length() == 0 ? 18 : 1);
                break;
            }
            case 90: 
            case 91: {
                this.textAttr().underline(1);
                break;
            }
            case 86: {
                this.textAttr().underline(34);
                break;
            }
            case 87: {
                this.textAttr().underline(19);
                break;
            }
            case 113: {
                UnitSpan oShift = this.textAttr().size();
                oShift = oShift.multiply(-0.31f);
                if (this.textAttr().baselineShiftEnable()) {
                    UnitSpan oBase = new UnitSpan(this.textAttr().baselineShift().getString(false));
                    oShift = oShift.add(oBase);
                }
                this.textAttr().baselineShift(new TextBaselineShift(oShift));
                UnitSpan size = this.textAttr().size();
                size = size.multiply(0.66f);
                this.textAttr().size(size);
                break;
            }
            case 118: {
                UnitSpan oShift = new UnitSpan(sCommand + gsPt);
                oShift = oShift.multiply(-0.5);
                if (this.textAttr().baselineShiftEnable()) {
                    UnitSpan oBase = new UnitSpan(this.textAttr().baselineShift().getString(false));
                    oShift = oShift.add(oBase);
                }
                this.textAttr().baselineShift(new TextBaselineShift(oShift));
                break;
            }
            case 117: {
                UnitSpan oShift = new UnitSpan(sCommand + gsPt);
                oShift = oShift.multiply(0.5);
                if (this.textAttr().baselineShiftEnable()) {
                    UnitSpan oBase = new UnitSpan(this.textAttr().baselineShift().getString(false));
                    oShift = oShift.add(oBase);
                }
                this.textAttr().baselineShift(new TextBaselineShift(oShift));
                break;
            }
            case 115: {
                UnitSpan oShift = this.textAttr().size();
                oShift = oShift.multiply(0.15f);
                if (this.textAttr().baselineShiftEnable()) {
                    UnitSpan oBase = new UnitSpan(this.textAttr().baselineShift().getString(false));
                    oShift = oShift.add(oBase);
                }
                this.textAttr().baselineShift(new TextBaselineShift(oShift));
                UnitSpan size = this.textAttr().size();
                size = size.multiply(0.66f);
                this.textAttr().size(size);
                break;
            }
            case 120: {
                this.textAttr().justifyH(8);
                break;
            }
            case 121: {
                this.textAttr().justifyH(9);
                break;
            }
            case 122: {
                this.textAttr().justifyH(5);
                break;
            }
            case 123: {
                this.textAttr().justifyH(6);
                break;
            }
            case 124: {
                this.textAttr().justifyH(7);
                break;
            }
            case 133: {
                this.textAttr().justifyV(1);
                break;
            }
            case 134: {
                this.textAttr().justifyV(2);
                break;
            }
            case 135: {
                this.textAttr().justifyV(3);
                break;
            }
            case 136: {
                this.flushAttr();
                this.text(gsTab);
                break;
            }
            case 137: {
                TextTab oTab = new TextTab(this.loadNumber(sCommand), 4);
                TextTabList oTabList = new TextTabList();
                if (this.textAttr().tabsEnable()) {
                    oTabList = this.textAttr().tabs();
                }
                oTabList.uniform(oTab);
                this.textAttr().tabs(oTabList);
                break;
            }
            case 138: {
                TextTab oTab = new TextTab(this.loadNumber(sCommand), this.pendingTab());
                TextTabList oTabList = new TextTabList();
                if (this.textAttr().tabsEnable()) {
                    oTabList = this.textAttr().tabs();
                }
                oTabList.set(oTab);
                this.textAttr().tabs(oTabList);
                break;
            }
            case 139: {
                this.pendingTab(0);
                break;
            }
            case 140: {
                this.pendingTab(1);
                break;
            }
            case 141: {
                this.pendingTab(2);
                break;
            }
            case 142: {
                this.pendingTab(3);
                break;
            }
            case 150: {
                this.mnStyleNum *= -1;
                break;
            }
            case 151: {
                if (!this.mbCollectingStyle) break;
                int nLookup = StringUtils.safeNumber(sCommand);
                TextAttr value = this.moStyleSheets.get(nLookup);
                if (value == null) {
                    value = this.moStyleSheets.get(nLookup *= -1);
                }
                if (value == null) break;
                TextAttr oStyle = value;
                this.moCurrentAttr.addDisabled(oStyle);
                break;
            }
            case 148: 
            case 149: {
                int nFontIndex = StringUtils.safeNumber(sCommand);
                if (this.mbCollectingStyle) {
                    this.mnStyleNum = nFontIndex;
                    break;
                }
                int nLookup = nFontIndex;
                TextAttr value = this.moStyleSheets.get(nLookup);
                boolean bAdditive = false;
                if (value == null) {
                    value = this.moStyleSheets.get(nLookup *= -1);
                    bAdditive = true;
                }
                if (value == null) break;
                TextAttr oStyle = value;
                if (bAdditive) {
                    oStyle.isolatePara(false);
                    this.moCurrentAttr.override(oStyle);
                    break;
                }
                this.moCurrentAttr = oStyle;
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 27: 
            case 84: {
                break;
            }
            default: {
                bCommandHandled = false;
            }
        }
        return bCommandHandled;
    }

    @Override
    protected void startBlock() {
        if (this.mbCollectingStyle) {
            this.moCurrentAttr.setDefault(false);
        }
    }

    @Override
    protected void endBlock() {
        if (this.mbCollectingStyle) {
            if (this.mnStyleNum >= 0) {
                String value;
                if (!this.moCurrentAttr.typefaceEnable() && (value = this.moFontMap.get(this.mnDefaultFont)) != null) {
                    String sTypeface = value;
                    this.moCurrentAttr.typeface(sTypeface);
                    this.charset(this.moFontCharset.get(this.mnDefaultFont));
                }
                this.moCurrentAttr.addDisabled(TextAttr.defaultFull);
            }
            this.moStyleSheets.put(this.mnStyleNum, this.moCurrentAttr);
            this.mnStyleNum = 0;
        }
    }

    protected void charset(int lCharset) {
    }

    @Override
    protected void text(String sText) {
        if (!this.mbCollectingStyle) {
            super.text(sText);
        }
    }

    @Override
    protected void attr(TextAttr oAttr) {
        if (!this.mbCollectingStyle) {
            super.attr(oAttr);
        }
    }

    private void buildFontMap(String oStrRtfFontMap) {
        int ciINVALID_FONT = -1;
        boolean FT_COMMAND = false;
        boolean FT_NAME = true;
        int FT_UNKNOWN = 2;
        int eState = 2;
        StringBuilder sCommand = new StringBuilder();
        RTFAttr pMkAttr = (RTFAttr)this.markupAttr();
        int iFontTableIndex = -1;
        int iFontCharset = 0;
        this.moFontMap.clear();
        StringBuilder cFontName = new StringBuilder();
        for (int nIndex = 0; nIndex < oStrRtfFontMap.length(); ++nIndex) {
            char c = oStrRtfFontMap.charAt(nIndex);
            if (c == '\\' && oStrRtfFontMap.charAt(nIndex + 1) == '\'') {
                byte b = this.getHexValue(oStrRtfFontMap.substring(nIndex + 2, nIndex + 4));
                cFontName.append(b);
                eState = 1;
                nIndex += 3;
                continue;
            }
            if (eState == 2) {
                if (c == '@' && iFontTableIndex != -1) {
                    eState = 1;
                    continue;
                }
                if (c == ' ' && cFontName.length() == 0 && iFontTableIndex != -1) {
                    eState = 1;
                    continue;
                }
            }
            switch (eState) {
                case 0: {
                    if (pMkAttr.isDelimiter(c)) {
                        if (sCommand.length() <= 0) break;
                        int eTag = pMkAttr.extractTag(sCommand);
                        String finalCommand = sCommand.toString();
                        if (eTag == 65) {
                            iFontTableIndex = StringUtils.safeNumber(finalCommand);
                        } else if (eTag == 76) {
                            iFontCharset = StringUtils.safeNumber(finalCommand);
                        } else if (pMkAttr.IsFontNameSpecifier(finalCommand)) {
                            if (c == pMkAttr.blockPrefix()) {
                                nIndex = this.skipBlock(nIndex + 1, oStrRtfFontMap);
                            }
                            eState = 1;
                        } else if (sCommand.toString().equals("panose")) {
                            nIndex = this.skipBlock(nIndex + 1, oStrRtfFontMap);
                            eState = 1;
                        }
                        if (c == ' ') {
                            eState = 1;
                        }
                        sCommand.delete(0, sCommand.length());
                        break;
                    }
                    if (c == pMkAttr.commandPrefix()) break;
                    sCommand.append(c);
                    break;
                }
                case 1: {
                    if (c == this.mcCommandPrefix) {
                        eState = 0;
                        break;
                    }
                    if (pMkAttr.isDelimiter(c)) {
                        if (c != ' ' && c != '(' && c != ')' && c != '_' && cFontName.length() != 0) {
                            if (iFontTableIndex != -1) {
                                this.moFontMap.remove(iFontTableIndex);
                                String sFontName = cFontName.toString();
                                this.moFontMap.put(iFontTableIndex, sFontName);
                                this.moFontCharset.remove(iFontTableIndex);
                                this.moFontCharset.put(iFontTableIndex, iFontCharset);
                                iFontCharset = 0;
                                iFontTableIndex = -1;
                            }
                            cFontName.delete(0, cFontName.length());
                            eState = 2;
                            break;
                        }
                        if (c == pMkAttr.blockPrefix()) {
                            nIndex = this.skipBlock(nIndex + 1, oStrRtfFontMap);
                            break;
                        }
                        if (c == pMkAttr.commandPrefix() || c == '@') break;
                        cFontName.append(c);
                        break;
                    }
                    if (c == '@') break;
                    cFontName.append(c);
                    break;
                }
                case 2: {
                    if (c != this.mcCommandPrefix) break;
                    eState = 0;
                }
            }
            if (c != this.mcBlockSuffix) continue;
            sCommand.delete(0, sCommand.length());
            iFontTableIndex = -1;
            iFontCharset = 0;
        }
    }

    private String extractFontTableData(StringBuilder oStrSource) {
        String fontMap = null;
        boolean bValid = false;
        int nStartIndex = oStrSource.indexOf("{\\fonttbl");
        if (nStartIndex >= 0) {
            int nIndex;
            int iScopedBlockCount = 1;
            for (nIndex = nStartIndex + 1; iScopedBlockCount > 0 && nIndex < oStrSource.length(); ++nIndex) {
                char c = oStrSource.charAt(nIndex);
                if (c == this.mcBlockPrefix) {
                    ++iScopedBlockCount;
                    continue;
                }
                if (c != this.mcBlockSuffix || --iScopedBlockCount != 0) continue;
                bValid = true;
                break;
            }
            if (bValid) {
                fontMap = oStrSource.substring(nStartIndex, nIndex);
                oStrSource.delete(nStartIndex, nIndex);
            }
        }
        return fontMap;
    }

    private void buildColourTable(String oSource) {
        int nPos;
        int nFoundAt = oSource.indexOf(gsColourtbl);
        if (nFoundAt < 0) {
            return;
        }
        int nFoundAt2 = oSource.indexOf(125, nFoundAt);
        String sColourTable = oSource.substring(nFoundAt, nFoundAt2);
        if (sColourTable.charAt(nPos = StringUtils.skipOver(sColourTable, gsSkip, gsColourtbl.length())) == ';') {
            this.moColourTable.add(new GFXColour());
        }
        int nOffset = 0;
        nFoundAt = sColourTable.indexOf(gsRed);
        while (nFoundAt >= 0) {
            int nRed = this.getNumber(sColourTable, nFoundAt + gsRed.length());
            nFoundAt = sColourTable.indexOf(gsGreen, nOffset);
            if (nFoundAt >= 0) {
                int nGreen = this.getNumber(sColourTable, nFoundAt + gsGreen.length());
                nFoundAt = sColourTable.indexOf(gsBlue, nOffset);
                if (nFoundAt >= 0) {
                    int nBlue = this.getNumber(sColourTable, nFoundAt + gsBlue.length());
                    this.moColourTable.add(new GFXColour(nRed, nGreen, nBlue, 255));
                }
            }
            nOffset = nFoundAt + gsBlue.length();
            nFoundAt = sColourTable.indexOf(gsRed, nOffset);
        }
    }

    private void buildStyleSheets(String sSource) {
        int i;
        int nFoundAt = sSource.indexOf("\\deff");
        if (nFoundAt >= 0) {
            StringBuilder sNum = new StringBuilder();
            nFoundAt += 5;
            while (sSource.charAt(nFoundAt) >= '0' && sSource.charAt(nFoundAt) <= '9') {
                sNum.append(sSource.charAt(nFoundAt++));
            }
            this.mnDefaultFont = StringUtils.safeNumber(sNum.toString());
        }
        if ((nFoundAt = sSource.indexOf(gsStyleSheet)) < 0) {
            return;
        }
        this.mbCollectingStyle = true;
        this.mnStyleNum = 0;
        int nBraceLevel = 1;
        for (i = nFoundAt += gsStyleSheet.length(); i < sSource.length(); ++i) {
            if (sSource.charAt(i) == '{') {
                ++nBraceLevel;
            } else if (sSource.charAt(i) == '}') {
                --nBraceLevel;
            }
            if (nBraceLevel == 0) break;
        }
        String sTable = sSource.substring(nFoundAt, i);
        this.setSourceText(sTable);
        super.translate();
        this.setSourceText(sTable);
        this.mbCollectingStyle = false;
        this.reset();
    }

    private int getNumber(String sStr, int nOffset) {
        int lValue = 0;
        while (sStr.charAt(nOffset) >= '0' && sStr.charAt(nOffset) <= '9') {
            lValue = lValue * 10 + (sStr.charAt(nOffset) - 48);
            ++nOffset;
        }
        return lValue;
    }

    private byte getHexValue(String sCommand) {
        return Byte.decode(sCommand);
    }
}

