/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateParser {
    private static final Logger log = LoggerFactory.getLogger(DateParser.class);
    private static DateFormat[] RFC822_DATE_FORMATS;
    private static DateFormat[] W3C_DATE_FORMATS;
    private static Pattern w3cTZPattern;

    public static Date parseDate(String sDate) {
        Date result = null;
        result = DateParser.parseRFC822Date(sDate);
        if (result == null) {
            result = DateParser.parseW3CDate(sDate);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Date parseRFC822Date(String sDate) {
        Date result = null;
        if (sDate == null) return result;
        if (sDate.length() <= 0) return result;
        DateFormat[] dateFormatArray = RFC822_DATE_FORMATS;
        synchronized (RFC822_DATE_FORMATS) {
            return DateParser.parseDate(sDate, RFC822_DATE_FORMATS, TimeZone.getDefault());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Date parseW3CDate(String sDate) {
        int tzIndex;
        Date result = null;
        if (sDate == null) return result;
        if (sDate.length() <= 0) return result;
        TimeZone timeZone = TimeZone.getDefault();
        int tIndex = sDate.indexOf(84);
        if (tIndex > 0 && ((tzIndex = sDate.indexOf(90, tIndex)) != -1 || (tzIndex = sDate.indexOf(43, tIndex)) != -1 || (tzIndex = sDate.indexOf(45, tIndex)) != -1)) {
            timeZone = DateParser.parseW3CTimeZone(sDate.substring(tzIndex));
        }
        DateFormat[] dateFormatArray = W3C_DATE_FORMATS;
        synchronized (W3C_DATE_FORMATS) {
            return DateParser.parseDate(sDate, W3C_DATE_FORMATS, timeZone);
        }
    }

    private static Date parseDate(String sDate, DateFormat[] formats, TimeZone timeZone) {
        Date result = null;
        for (int i = 0; i < formats.length; ++i) {
            formats[i].setTimeZone(timeZone);
            try {
                formats[i].setLenient(false);
                result = formats[i].parse(sDate, new ParsePosition(0));
            }
            catch (NumberFormatException ex) {
                result = null;
            }
            catch (Exception ex) {
                log.error("Unexpected exception while parsing date \"" + sDate + "\" using format \"" + formats[i].toString() + "\"", ex);
            }
            if (result != null) break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TimeZone parseW3CTimeZone(String tz) {
        TimeZone timeZone = null;
        Class<DateParser> clazz = DateParser.class;
        synchronized (DateParser.class) {
            block10: {
                try {
                    w3cTZPattern = Pattern.compile("^[+-][0-9][0-9]:[0-9][0-9]$");
                }
                catch (PatternSyntaxException ex) {
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            switch (tz.charAt(0)) {
                case 'Z': {
                    timeZone = TimeZone.getTimeZone("GMT");
                    break;
                }
                case '+': 
                case '-': {
                    Matcher matcher = w3cTZPattern.matcher(tz);
                    if (matcher.matches()) {
                        timeZone = TimeZone.getTimeZone("GMT" + tz);
                    }
                    if (timeZone != null) break;
                    timeZone = TimeZone.getDefault();
                    break;
                }
                default: {
                    timeZone = TimeZone.getDefault();
                }
            }
            return timeZone;
        }
    }

    static {
        W3C_DATE_FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss 'GMT'Z"), new SimpleDateFormat("yyyy:MM:dd HH:mm:ss"), new SimpleDateFormat("yyyy:MM:dd HH:mm"), new SimpleDateFormat("yyyy:MM:dd"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("dd.MM.yyyy HH:mm:ss"), new SimpleDateFormat("dd.MM.yyyy")};
        RFC822_DATE_FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.US), new SimpleDateFormat("EEE d MMM yyyy HH:mm:ss", Locale.US)};
        w3cTZPattern = null;
    }
}

