/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import com.day.cq.search.Predicate;
import com.day.cq.search.eval.DateRangePredicateEvaluator;
import com.day.cq.search.eval.EvaluationContext;
import java.util.GregorianCalendar;
import java.util.Scanner;
import org.apache.felix.scr.annotations.Component;

@Component(metatype=false, factory="com.day.cq.search.eval.PredicateEvaluator/relativedaterange")
public class RelativeDateRangePredicateEvaluator
extends DateRangePredicateEvaluator {
    @Override
    public String getXPathExpression(Predicate p, EvaluationContext context) {
        Predicate modifiedPredicate = p.clone();
        long now = new GregorianCalendar().getTimeInMillis();
        long upperBound = 0L;
        long lowerBound = 0L;
        try {
            upperBound = this.parseDateRange(p.get("upperBound"));
            modifiedPredicate.set("upperBound", "" + (upperBound += now));
        }
        catch (Exception nfe) {
            modifiedPredicate.set("upperBound", null);
        }
        try {
            lowerBound = this.parseDateRange(p.get("lowerBound"));
            modifiedPredicate.set("lowerBound", "" + (lowerBound += now));
        }
        catch (Exception nfe) {
            modifiedPredicate.set("lowerBound", null);
        }
        return super.getXPathExpression(modifiedPredicate, context);
    }

    public long parseDateRange(String daterange) throws NumberFormatException {
        if (daterange == null || daterange.length() == 0) {
            throw new NumberFormatException("cannot parse empty string");
        }
        if (daterange.matches("^(-)?\\d+$")) {
            return Long.parseLong(daterange);
        }
        String cleandaterange = daterange.replaceAll("[^dsmhdwMy\\d-]", "");
        boolean negative = cleandaterange.matches("^-.*");
        if (!(cleandaterange = cleandaterange.replaceAll("-", "")).matches("^(\\d+\\w)+$")) {
            throw new NumberFormatException("only s, m, h, d, w, M, y are allowed modifiers");
        }
        cleandaterange = cleandaterange.replaceAll("(\\d+)(\\w)", "$1 $2 ");
        Scanner scanner = new Scanner(cleandaterange);
        long value = 0L;
        while (scanner.hasNext()) {
            long number = scanner.nextLong();
            String unit = scanner.next();
            if ("s".equals(unit)) {
                value += number * 1000L;
                continue;
            }
            if ("m".equals(unit)) {
                value += number * 60L * 1000L;
                continue;
            }
            if ("h".equals(unit)) {
                value += number * 60L * 60L * 1000L;
                continue;
            }
            if ("d".equals(unit)) {
                value += number * 24L * 60L * 60L * 1000L;
                continue;
            }
            if ("w".equals(unit)) {
                value += number * 7L * 24L * 60L * 60L * 1000L;
                continue;
            }
            if ("M".equals(unit)) {
                value += number * 30L * 24L * 60L * 60L * 1000L;
                continue;
            }
            if (!"y".equals(unit)) continue;
            value += number * 365L * 24L * 60L * 60L * 1000L;
        }
        if (negative) {
            value *= -1L;
        }
        return value;
    }
}

