/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.commons;

import com.adobe.cq.launches.api.Launch;
import com.day.cq.tagging.Tag;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.ComponentManager;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import com.day.cq.wcm.commons.policy.ContentPolicyStyle;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.jcr.Node;
import javax.servlet.ServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WCMUtils {
    private static final Logger log = LoggerFactory.getLogger(WCMUtils.class);
    public static final String DEBUG_PARAM = "debug";

    private WCMUtils() {
    }

    public static Component getComponent(Resource resource) {
        if (resource == null) {
            log.debug("Resource to get component from must not be null");
            return null;
        }
        ComponentManager compMgr = resource.getResourceResolver().adaptTo(ComponentManager.class);
        if (compMgr == null) {
            log.warn("Unable to retrieve component manager for {}", (Object)resource);
            return null;
        }
        return compMgr.getComponentOfResource(resource);
    }

    public static String getInheritedProperty(Page page, ResourceResolver resolver, String name) {
        String value = null;
        while (value == null && page != null) {
            Launch launch;
            value = (String)((Object)page.getProperties().get(name, String.class));
            if (value != null) continue;
            Resource res = resolver.getResource(page.getPath() + "/..");
            if (res == null) {
                page = null;
                continue;
            }
            Page previousPage = page;
            page = res.adaptTo(Page.class);
            if (page != null || (launch = previousPage.adaptTo(Resource.class).adaptTo(Launch.class)) == null) continue;
            page = launch.getSourceRootResource().adaptTo(Page.class);
        }
        return value;
    }

    @Nullable
    private static Style getContentPolicyStyle(ComponentContext ctx) {
        ContentPolicy currentPolicy;
        Resource resource = ctx.getResource();
        if (resource == null) {
            return null;
        }
        ResourceResolver resourceResolver = resource.getResourceResolver();
        ContentPolicyManager policyManager = resourceResolver.adaptTo(ContentPolicyManager.class);
        if (policyManager != null && (currentPolicy = policyManager.getPolicy(ctx)) != null) {
            return new ContentPolicyStyle(currentPolicy, ctx.getCell());
        }
        return null;
    }

    public static Style getStyle(SlingHttpServletRequest request) {
        Design design;
        Page page;
        ComponentContext ctx = WCMUtils.getComponentContext(request);
        Resource resource = request.getResource();
        ResourceResolver resourceResolver = request.getResourceResolver();
        PageManager pageManager = resourceResolver.adaptTo(PageManager.class);
        Page page2 = page = ctx == null ? null : ctx.getPage();
        if (page == null) {
            page = pageManager.getContainingPage(resource);
        }
        if (page == null) {
            return null;
        }
        Template template = page.getTemplate();
        if (ctx != null && template != null && template.hasStructureSupport()) {
            return WCMUtils.getContentPolicyStyle(ctx);
        }
        Designer designer = resourceResolver.adaptTo(Designer.class);
        String designId = "";
        String cellPath = "";
        String suffix = request.getRequestPathInfo().getSuffix();
        if (suffix != null && suffix.length() > 0) {
            int idx;
            if (!suffix.startsWith("/")) {
                suffix = "/" + suffix;
            }
            if ((idx = suffix.indexOf("/-/")) >= 0) {
                designId = suffix.substring(0, idx);
                cellPath = suffix.substring(idx + 3);
            } else {
                designId = suffix;
            }
        }
        if (designId.length() > 0 && designer.hasDesign(designId)) {
            design = designer.getDesign(designId);
        } else {
            cellPath = "";
            design = designer.getDesign(page);
        }
        if (design == null) {
            return null;
        }
        if (cellPath.length() > 0) {
            return design.getStyle(cellPath);
        }
        if (ctx == null) {
            return design.getStyle(resource);
        }
        return design.getStyle(ctx.getCell());
    }

    public static ComponentContext getComponentContext(ServletRequest request) {
        return (ComponentContext)request.getAttribute("com.day.cq.wcm.componentcontext");
    }

    public static Node getNode(Resource resource) {
        if (resource != null) {
            return resource.adaptTo(Node.class);
        }
        return null;
    }

    public static String getKeywords(Page page) {
        return WCMUtils.getKeywords(page, false);
    }

    public static String getKeywords(Page page, boolean onlyLocalized) {
        StringBuffer keywords = new StringBuffer();
        if (page != null) {
            Locale locale = page.getLanguage(false);
            Tag[] tags = page.getTags();
            for (int i = 0; i < tags.length; ++i) {
                if (onlyLocalized) {
                    String title = tags[i].getLocalizedTitle(locale);
                    if (title == null) continue;
                    if (keywords.length() > 0) {
                        keywords.append(", ");
                    }
                    keywords.append(title);
                    continue;
                }
                if (keywords.length() > 0) {
                    keywords.append(", ");
                }
                keywords.append(tags[i].getTitle(locale));
            }
        }
        return keywords.toString();
    }
}

